/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.jdbc;

import com.huawei.dws.pbq.api.model.RowType;
import com.huawei.dws.pbq.api.model.StatementResult;
import com.huawei.dws.pbq.api.model.StatementResultSet;
import com.huawei.gauss200.jdbc.Driver;
import com.huawei.gauss200.jdbc.jdbc.PayByQueryConnection;
import com.huawei.gauss200.jdbc.jdbc.PbqResultSet;
import com.huawei.gauss200.jdbc.jdbc.PbqStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PbqDatabaseMetadata
implements DatabaseMetaData {
    protected final PayByQueryConnection connection;

    public PbqDatabaseMetadata(PayByQueryConnection conn) {
        this.connection = conn;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return "";
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "GaussDB(DWS)";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "";
    }

    @Override
    public String getDriverName() throws SQLException {
        return "PostgreSQL JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "42.2.23";
    }

    @Override
    public int getDriverMajorVersion() {
        return 42;
    }

    @Override
    public int getDriverMinorVersion() {
        return 2;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,round,sign,sin,sqrt,tan,truncate";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        String funcs = "ascii,char,concat,lcase,left,length,ltrim,repeat,rtrim,space,substring,ucase";
        funcs = funcs + ",replace";
        return funcs;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "database,ifnull,user";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        String timeDateFuncs = "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,second,week,year";
        timeDateFuncs = timeDateFuncs + ",timestampadd";
        return timeDateFuncs;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0x40000000;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getProcedures()");
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getProcedureColumns()");
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "";
        }
        if (tableNamePattern == null) {
            tableNamePattern = "";
        }
        schemaPattern = schemaPattern.replaceAll("\\\\_", "_");
        String sql = "SELECT catalog_name as table_cat, schema_name as TABLE_SCHEM, table_name, table_type, description as REMARKS, '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME, '' AS SELF_REFERENCING_COL_NAME, '' AS REF_GENERATION from pg_get_tables(" + this.escapeQuotes(schemaPattern) + ", " + this.escapeQuotes(tableNamePattern) + ", '') ";
        if (types != null && types.length > 0) {
            sql = sql + " where table_type in (";
            StringBuilder orclause = new StringBuilder();
            for (String type : types) {
                orclause.append("'").append(type).append("',");
            }
            orclause.deleteCharAt(orclause.length() - 1);
            sql = sql + orclause.toString() + ") ";
        }
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("TABLE_CAT");
        List<RowType> rowTypes = columns.stream().map(name -> {
            RowType rowType = new RowType();
            rowType.setName(name);
            rowType.setType(1043);
            return rowType;
        }).collect(Collectors.toList());
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        ArrayList<String> row = new ArrayList<String>();
        row.add(this.connection.getCatalog());
        rows.add(row);
        return this.getPbqResultSet(rowTypes, rows);
    }

    @NotNull
    private PbqResultSet getPbqResultSet(List<RowType> rowTypes, List<List<String>> rows) throws SQLException {
        StatementResult statementResult = new StatementResult();
        StatementResultSet statementResultSet = new StatementResultSet();
        statementResultSet.setColumns(rowTypes);
        statementResult.setResultSet(statementResultSet);
        statementResultSet.setRows(rows);
        return new PbqResultSet(statementResult, (PbqStatement)this.createMetaDataStatement(), 0);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("TABLE_TYPE");
        List<RowType> rowTypes = columns.stream().map(name -> {
            RowType rowType = new RowType();
            rowType.setName(name);
            return rowType;
        }).collect(Collectors.toList());
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        ArrayList<String> row = new ArrayList<String>();
        row.add("MANAGED_TABLE");
        rows.add(row);
        row = new ArrayList();
        row.add("EXTERNAL_TABLE");
        rows.add(row);
        return this.getPbqResultSet(rowTypes, rows);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "";
        }
        if (tableNamePattern == null) {
            tableNamePattern = "";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "";
        }
        tableNamePattern = tableNamePattern.replaceAll("\\\\_", "_");
        schemaPattern = schemaPattern.replaceAll("\\\\_", "_");
        String sql = "SELECT catalog_name as TABLE_CAT, schema_name as TABLE_SCHEM, table_name,  column_name,  origintype, atttypid, atttypmod, typename, typtype, attnum, attnum, description as REMARKS, attnotnull  from pg_get_columns(" + this.escapeQuotes(schemaPattern) + ", " + this.escapeQuotes(tableNamePattern) + ", " + this.escapeQuotes(columnNamePattern) + ") ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("TABLE_CAT");
        columns.add("TABLE_SCHEM");
        columns.add("TABLE_NAME");
        columns.add("COLUMN_NAME");
        columns.add("DATA_TYPE");
        columns.add("TYPE_NAME");
        columns.add("COLUMN_SIZE");
        columns.add("BUFFER_LENGTH");
        columns.add("DECIMAL_DIGITS");
        columns.add("NUM_PREC_RADIX");
        columns.add("NULLABLE");
        columns.add("REMARKS");
        columns.add("COLUMN_DEF");
        columns.add("SQL_DATA_TYPE");
        columns.add("SQL_DATETIME_SUB");
        columns.add("CHAR_OCTET_LENGTH");
        columns.add("ORDINAL_POSITION");
        columns.add("IS_NULLABLE");
        columns.add("SCOPE_CATALOG");
        columns.add("SCOPE_SCHEMA");
        columns.add("SCOPE_TABLE");
        columns.add("SOURCE_DATA_TYPE");
        columns.add("IS_AUTOINCREMENT");
        columns.add("IS_GENERATEDCOLUMN");
        List rowTypes = columns.stream().map(name -> {
            RowType rowType = new RowType();
            rowType.setName(name);
            return rowType;
        }).collect(Collectors.toList());
        StatementResult statementResult = new StatementResult();
        StatementResultSet statementResultSet = new StatementResultSet();
        statementResultSet.setColumns(rowTypes);
        statementResult.setResultSet(statementResultSet);
        ArrayList rows = new ArrayList();
        statementResultSet.setRows(rows);
        while (rs.next()) {
            ArrayList<String> row = new ArrayList<String>();
            String tableCat = rs.getString("TABLE_CAT");
            String tableSchem = rs.getString("TABLE_SCHEM");
            String tableName = rs.getString("table_name");
            String columnName = rs.getString("column_name");
            int typeOid = (int)rs.getLong("atttypid");
            String typtype = rs.getString("typtype");
            int sqlType = "c".equals(typtype) ? 2002 : ("d".equals(typtype) ? 2001 : this.connection.getTypeInfo().getSQLType(typeOid));
            String pgType = this.connection.getTypeInfo().getPGType(typeOid);
            String typename = rs.getString("typename");
            int typeMod = rs.getInt("atttypmod");
            int columnSize = this.connection.getTypeInfo().getPrecision(typeOid, typeMod);
            Object bufferLength = null;
            int decimalDigits = this.connection.getTypeInfo().getScale(typeOid, typeMod);
            int numPrecRadix = 10;
            if ("bit".equals(pgType) || "varbit".equals(pgType)) {
                numPrecRadix = 2;
            }
            boolean nullable = rs.getBoolean("attnotnull");
            String remarks = rs.getString("REMARKS");
            String columnDef = rs.getString("typename");
            Object sqlDataType = null;
            Object sqlDatetimeSub = null;
            int charOctetLength = columnSize;
            String ordinalPosition = rs.getString("attnum");
            String isNullable = rs.getBoolean("attnotnull") ? "YES" : "NO";
            Object SCOPE_CATALOG = null;
            Object SCOPE_SCHEMA = null;
            Object SCOPE_TABLE = null;
            Object SOURCE_DATA_TYPE = null;
            String autoinc = "NO";
            if (typename != null && typename.contains("nextval(")) {
                autoinc = "YES";
            }
            String IS_AUTOINCREMENT = autoinc;
            String IS_GENERATEDCOLUMN = "";
            row.add(tableCat);
            row.add(tableSchem);
            row.add(tableName);
            row.add(columnName);
            row.add(String.valueOf(sqlType));
            row.add(typename);
            row.add(String.valueOf(columnSize));
            row.add((String)bufferLength);
            row.add(String.valueOf(decimalDigits));
            row.add(String.valueOf(numPrecRadix));
            row.add(String.valueOf(nullable ? 1 : 0));
            row.add(remarks);
            row.add(columnDef);
            row.add((String)sqlDataType);
            row.add((String)sqlDatetimeSub);
            row.add(String.valueOf(charOctetLength));
            row.add(ordinalPosition);
            row.add(isNullable);
            row.add((String)SCOPE_CATALOG);
            row.add((String)SCOPE_SCHEMA);
            row.add((String)SCOPE_TABLE);
            row.add((String)SOURCE_DATA_TYPE);
            row.add(IS_AUTOINCREMENT);
            row.add(IS_GENERATEDCOLUMN);
            rows.add(row);
        }
        return new PbqResultSet(statementResult, (PbqStatement)stmt, 0);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getColumnPrivileges()");
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTablePrivileges()");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBestRowIdentifier()");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getVersionColumns()");
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getPrimaryKeys()");
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getImportedKeys()");
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getExportedKeys()");
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCrossReference()");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTypeInfo()");
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getIndexInfo()");
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type == 1005) {
            return false;
        }
        if (concurrency == 1008) {
            return true;
        }
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getUDTs()");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSuperTypes()");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSuperTables()");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getAttributes()");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowIdLifetime()");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "";
        }
        String sql = "SELECT schema_name as TABLE_SCHEM, NULL AS TABLE_CATALOG FROM pg_get_schemas(" + this.escapeQuotes(schemaPattern) + ") ";
        sql = sql + " ORDER BY TABLE_SCHEM";
        return this.createMetaDataStatement().executeQuery(sql);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClientInfoProperties()");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getFunctions()");
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getFunctionColumns()");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getPseudoColumns()");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    protected Statement createMetaDataStatement() throws SQLException {
        return this.connection.createStatement(1004, 1007);
    }

    protected String escapeQuotes(String s) throws SQLException {
        StringBuilder sb = new StringBuilder();
        if (!this.connection.getStandardConformingStrings()) {
            sb.append("E");
        }
        sb.append("'");
        sb.append(this.connection.escapeString(s));
        sb.append("'");
        return sb.toString();
    }
}

