/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class NaturalIdCacheKey
implements DataSerializable {
    private Serializable[] naturalIdValues;
    private String entityName;
    private String tenantId;
    private int hashCode;

    public NaturalIdCacheKey() {
    }

    public NaturalIdCacheKey(Object[] naturalIdValues, Type[] propertyTypes, int[] naturalIdPropertyIndexes, String entityName, SharedSessionContractImplementor session) {
        this.naturalIdValues = new Serializable[naturalIdValues.length];
        this.entityName = entityName;
        this.tenantId = session.getTenantIdentifier();
        SessionFactoryImplementor factory = session.getFactory();
        int result = 1;
        result = 31 * result + (entityName != null ? entityName.hashCode() : 0);
        result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        for (int i = 0; i < naturalIdValues.length; ++i) {
            int naturalIdPropertyIndex = naturalIdPropertyIndexes[i];
            Type type = propertyTypes[naturalIdPropertyIndex];
            Object value = naturalIdValues[i];
            result = 31 * result + (value != null ? type.getHashCode(value, factory) : 0);
            this.naturalIdValues[i] = type instanceof EntityType && type.getSemiResolvedType(factory).getReturnedClass().isInstance(value) ? (Serializable)value : type.disassemble(value, session, null);
        }
        this.hashCode = result;
    }

    Serializable[] getNaturalIdValues() {
        return this.naturalIdValues;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.naturalIdValues.length);
        for (Serializable naturalIdValue : this.naturalIdValues) {
            out.writeObject((Object)naturalIdValue);
        }
        out.writeUTF(this.entityName);
        out.writeUTF(this.tenantId);
        out.writeInt(this.hashCode);
    }

    public void readData(ObjectDataInput in) throws IOException {
        int length = in.readInt();
        this.naturalIdValues = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            this.naturalIdValues[i] = (Serializable)in.readObject();
        }
        this.entityName = in.readUTF();
        this.tenantId = in.readUTF();
        this.hashCode = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NaturalIdCacheKey that = (NaturalIdCacheKey)o;
        if (!Arrays.deepEquals(this.naturalIdValues, that.naturalIdValues)) {
            return false;
        }
        if (this.entityName != null ? !this.entityName.equals(that.entityName) : that.entityName != null) {
            return false;
        }
        return this.tenantId != null ? this.tenantId.equals(that.tenantId) : that.tenantId == null;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

