/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.h2.command.Command;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.constraint.Constraint;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.Engine;
import org.h2.engine.Procedure;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionWithState;
import org.h2.engine.Setting;
import org.h2.engine.SysProperties;
import org.h2.engine.UndoLog;
import org.h2.engine.UndoLogRecord;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.TransactionStore;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.store.DataHandler;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Session
extends SessionWithState {
    public static final int LOG_WRITTEN = -1;
    private static final String SYSTEM_IDENTIFIER_PREFIX = "_";
    private static int nextSerialId;
    private final int serialId = nextSerialId++;
    private final Database database;
    private ConnectionInfo connectionInfo;
    private final User user;
    private final int id;
    private final ArrayList<Table> locks = New.arrayList();
    private final UndoLog undoLog;
    private boolean autoCommit = true;
    private Random random;
    private int lockTimeout;
    private Value lastIdentity = ValueLong.get(0L);
    private Value lastScopeIdentity = ValueLong.get(0L);
    private int firstUncommittedLog = -1;
    private int firstUncommittedPos = -1;
    private HashMap<String, Savepoint> savepoints;
    private HashMap<String, Table> localTempTables;
    private HashMap<String, Index> localTempTableIndexes;
    private HashMap<String, Constraint> localTempTableConstraints;
    private int throttle;
    private long lastThrottle;
    private Command currentCommand;
    private boolean allowLiterals;
    private String currentSchemaName;
    private String[] schemaSearchPath;
    private Trace trace;
    private HashMap<String, Value> unlinkLobMap;
    private int systemIdentifier;
    private HashMap<String, Procedure> procedures;
    private boolean undoLogEnabled = true;
    private boolean redoLogBinary = true;
    private boolean autoCommitAtTransactionEnd;
    private String currentTransactionName;
    private volatile long cancelAt;
    private boolean closed;
    private final long sessionStart = System.currentTimeMillis();
    private long transactionStart;
    private long currentCommandStart;
    private HashMap<String, Value> variables;
    private HashSet<LocalResult> temporaryResults;
    private int queryTimeout;
    private boolean commitOrRollbackDisabled;
    private Table waitForLock;
    private Thread waitForLockThread;
    private int modificationId;
    private int objectId;
    private final int queryCacheSize;
    private SmallLRUCache<String, Command> queryCache;
    private long modificationMetaID = -1L;
    private ArrayList<Value> temporaryLobs;
    private TransactionStore.Transaction transaction;
    private long startStatement = -1L;

    public Session(Database database, User user, int n) {
        this.database = database;
        this.queryTimeout = database.getSettings().maxQueryTimeout;
        this.queryCacheSize = database.getSettings().queryCacheSize;
        this.undoLog = new UndoLog(this);
        this.user = user;
        this.id = n;
        Setting setting = database.findSetting(SetTypes.getTypeName(6));
        this.lockTimeout = setting == null ? 2000 : setting.getIntValue();
        this.currentSchemaName = "PUBLIC";
    }

    public boolean setCommitOrRollbackDisabled(boolean bl) {
        boolean bl2 = this.commitOrRollbackDisabled;
        this.commitOrRollbackDisabled = bl;
        return bl2;
    }

    private void initVariables() {
        if (this.variables == null) {
            this.variables = this.database.newStringMap();
        }
    }

    public void setVariable(String string, Value value) {
        Value value2;
        this.initVariables();
        ++this.modificationId;
        if (value == ValueNull.INSTANCE) {
            value2 = this.variables.remove(string);
        } else {
            value = value.link(this.database, -1);
            value2 = this.variables.put(string, value);
        }
        if (value2 != null) {
            value2.unlink(this.database);
            value2.close();
        }
    }

    public Value getVariable(String string) {
        this.initVariables();
        Value value = this.variables.get(string);
        return value == null ? ValueNull.INSTANCE : value;
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.variables.size()];
        this.variables.keySet().toArray(stringArray);
        return stringArray;
    }

    public Table findLocalTempTable(String string) {
        if (this.localTempTables == null) {
            return null;
        }
        return this.localTempTables.get(string);
    }

    public ArrayList<Table> getLocalTempTables() {
        if (this.localTempTables == null) {
            return New.arrayList();
        }
        return New.arrayList(this.localTempTables.values());
    }

    public void addLocalTempTable(Table table) {
        if (this.localTempTables == null) {
            this.localTempTables = this.database.newStringMap();
        }
        if (this.localTempTables.get(table.getName()) != null) {
            throw DbException.get(42101, table.getSQL());
        }
        ++this.modificationId;
        this.localTempTables.put(table.getName(), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTable(Table table) {
        ++this.modificationId;
        this.localTempTables.remove(table.getName());
        Database database = this.database;
        synchronized (database) {
            table.removeChildrenAndResources(this);
        }
    }

    public Index findLocalTempTableIndex(String string) {
        if (this.localTempTableIndexes == null) {
            return null;
        }
        return this.localTempTableIndexes.get(string);
    }

    public HashMap<String, Index> getLocalTempTableIndexes() {
        if (this.localTempTableIndexes == null) {
            return New.hashMap();
        }
        return this.localTempTableIndexes;
    }

    public void addLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes == null) {
            this.localTempTableIndexes = this.database.newStringMap();
        }
        if (this.localTempTableIndexes.get(index.getName()) != null) {
            throw DbException.get(42111, index.getSQL());
        }
        this.localTempTableIndexes.put(index.getName(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes != null) {
            this.localTempTableIndexes.remove(index.getName());
            Database database = this.database;
            synchronized (database) {
                index.removeChildrenAndResources(this);
            }
        }
    }

    public Constraint findLocalTempTableConstraint(String string) {
        if (this.localTempTableConstraints == null) {
            return null;
        }
        return this.localTempTableConstraints.get(string);
    }

    public HashMap<String, Constraint> getLocalTempTableConstraints() {
        if (this.localTempTableConstraints == null) {
            return New.hashMap();
        }
        return this.localTempTableConstraints;
    }

    public void addLocalTempTableConstraint(Constraint constraint) {
        String string;
        if (this.localTempTableConstraints == null) {
            this.localTempTableConstraints = this.database.newStringMap();
        }
        if (this.localTempTableConstraints.get(string = constraint.getName()) != null) {
            throw DbException.get(90045, constraint.getSQL());
        }
        this.localTempTableConstraints.put(string, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLocalTempTableConstraint(Constraint constraint) {
        if (this.localTempTableConstraints != null) {
            this.localTempTableConstraints.remove(constraint.getName());
            Database database = this.database;
            synchronized (database) {
                constraint.removeChildrenAndResources(this);
            }
        }
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int n) {
        this.lockTimeout = n;
    }

    @Override
    public synchronized CommandInterface prepareCommand(String string, int n) {
        return this.prepareLocal(string);
    }

    public Prepared prepare(String string) {
        return this.prepare(string, false);
    }

    public Prepared prepare(String string, boolean bl) {
        Parser parser = new Parser(this);
        parser.setRightsChecked(bl);
        return parser.prepare(string);
    }

    public Command prepareLocal(String string) {
        Command command;
        if (this.closed) {
            throw DbException.get(90067, "session closed");
        }
        if (this.queryCacheSize > 0) {
            if (this.queryCache == null) {
                this.queryCache = SmallLRUCache.newInstance(this.queryCacheSize);
                this.modificationMetaID = this.database.getModificationMetaId();
            } else {
                long l = this.database.getModificationMetaId();
                if (l != this.modificationMetaID) {
                    this.queryCache.clear();
                    this.modificationMetaID = l;
                }
                if ((command = (Command)this.queryCache.get(string)) != null && command.canReuse()) {
                    command.reuse();
                    return command;
                }
            }
        }
        Parser parser = new Parser(this);
        command = parser.prepareCommand(string);
        if (this.queryCache != null && command.isCacheable()) {
            this.queryCache.put(string, command);
        }
        return command;
    }

    public Database getDatabase() {
        return this.database;
    }

    @Override
    public int getPowerOffCount() {
        return this.database.getPowerOffCount();
    }

    @Override
    public void setPowerOffCount(int n) {
        this.database.setPowerOffCount(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean bl) {
        Object object;
        this.checkCommitRollback();
        this.currentTransactionName = null;
        this.transactionStart = 0L;
        if (this.transaction != null) {
            if (this.locks.size() > 0) {
                int n = this.locks.size();
                for (int i = 0; i < n; ++i) {
                    object = this.locks.get(i);
                    if (!(object instanceof MVTable)) continue;
                    ((MVTable)object).commit();
                }
            }
            this.transaction.commit();
            this.transaction = null;
        }
        if (this.containsUncommitted()) {
            this.database.commit(this);
        }
        if (this.temporaryLobs != null) {
            for (Value value : this.temporaryLobs) {
                if (value.isLinked()) continue;
                value.close();
            }
            this.temporaryLobs.clear();
        }
        if (this.undoLog.size() > 0) {
            if (this.database.isMultiVersion()) {
                ArrayList arrayList = New.arrayList();
                Database database = this.database;
                synchronized (database) {
                    while (this.undoLog.size() > 0) {
                        object = this.undoLog.getLast();
                        ((UndoLogRecord)object).commit();
                        arrayList.add(((UndoLogRecord)object).getRow());
                        this.undoLog.removeLast(false);
                    }
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        Row row = (Row)arrayList.get(i);
                        row.commit();
                    }
                }
            }
            this.undoLog.clear();
        }
        if (!bl) {
            this.cleanTempTables(false);
            if (this.autoCommitAtTransactionEnd) {
                this.autoCommit = true;
                this.autoCommitAtTransactionEnd = false;
            }
        }
        this.endTransaction();
    }

    private void checkCommitRollback() {
        if (this.commitOrRollbackDisabled && this.locks.size() > 0) {
            throw DbException.get(90058);
        }
    }

    private void endTransaction() {
        if (this.unlinkLobMap != null && this.unlinkLobMap.size() > 0) {
            this.database.flush();
            for (Value value : this.unlinkLobMap.values()) {
                value.unlink(this.database);
                value.close();
            }
            this.unlinkLobMap = null;
        }
        this.unlockAll();
    }

    public void rollback() {
        this.checkCommitRollback();
        this.currentTransactionName = null;
        boolean bl = false;
        if (this.undoLog.size() > 0) {
            this.rollbackTo(null, false);
            bl = true;
        }
        if (this.transaction != null) {
            this.rollbackTo(null, false);
            bl = true;
            this.transaction.commit();
            this.transaction = null;
        }
        if (this.locks.size() > 0 || bl) {
            this.database.commit(this);
        }
        this.cleanTempTables(false);
        if (this.autoCommitAtTransactionEnd) {
            this.autoCommit = true;
            this.autoCommitAtTransactionEnd = false;
        }
        this.endTransaction();
    }

    public void rollbackTo(Savepoint savepoint, boolean bl) {
        Object object;
        int n;
        int n2 = n = savepoint == null ? 0 : savepoint.logIndex;
        while (this.undoLog.size() > n) {
            UndoLogRecord undoLogRecord = this.undoLog.getLast();
            undoLogRecord.undo(this);
            this.undoLog.removeLast(bl);
        }
        if (this.transaction != null) {
            long l = savepoint == null ? 0L : savepoint.transactionSavepoint;
            HashMap<String, MVTable> hashMap = this.database.getMvStore().getTables();
            Iterator<TransactionStore.Change> iterator = this.transaction.getChanges(l);
            while (iterator.hasNext()) {
                Row row;
                short s;
                TransactionStore.Change object2 = iterator.next();
                object = hashMap.get(object2.mapName);
                if (object == null) continue;
                long l2 = ((ValueLong)object2.key).getLong();
                ValueArray valueArray = (ValueArray)object2.value;
                if (valueArray == null) {
                    s = 0;
                    row = ((MVTable)object).getRow(this, l2);
                } else {
                    s = 1;
                    row = new Row(valueArray.getList(), -1);
                }
                row.setKey(l2);
                UndoLogRecord undoLogRecord = new UndoLogRecord((Table)object, s, row);
                undoLogRecord.undo(this);
            }
        }
        if (this.savepoints != null) {
            String[] stringArray = new String[this.savepoints.size()];
            this.savepoints.keySet().toArray(stringArray);
            for (String string : stringArray) {
                object = this.savepoints.get(string);
                int n3 = ((Savepoint)object).logIndex;
                if (n3 <= n) continue;
                this.savepoints.remove(string);
            }
        }
    }

    @Override
    public boolean hasPendingTransaction() {
        return this.undoLog.size() > 0;
    }

    public Savepoint setSavepoint() {
        Savepoint savepoint = new Savepoint();
        savepoint.logIndex = this.undoLog.size();
        if (this.database.getMvStore() != null) {
            savepoint.transactionSavepoint = this.getStatementSavepoint();
        }
        return savepoint;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void cancel() {
        this.cancelAt = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.database.checkPowerOff();
                this.cleanTempTables(true);
                this.undoLog.clear();
                this.database.removeSession(this);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public void addLock(Table table) {
        if (SysProperties.CHECK && this.locks.contains(table)) {
            DbException.throwInternalError();
        }
        this.locks.add(table);
    }

    public void log(Table table, short s, Row row) {
        if (table.isMVStore()) {
            return;
        }
        if (this.undoLogEnabled) {
            int n;
            UndoLogRecord undoLogRecord = new UndoLogRecord(table, s, row);
            if (SysProperties.CHECK && (n = this.database.getLockMode()) != 0 && !this.database.isMultiVersion()) {
                String string = undoLogRecord.getTable().getTableType();
                if (this.locks.indexOf(undoLogRecord.getTable()) < 0 && !"TABLE LINK".equals(string) && !"EXTERNAL".equals(string)) {
                    DbException.throwInternalError();
                }
            }
            this.undoLog.add(undoLogRecord);
        } else if (this.database.isMultiVersion()) {
            ArrayList<Index> arrayList = table.getIndexes();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Index index = arrayList.get(i);
                index.commit(s, row);
            }
            row.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockReadLocks() {
        if (this.database.isMultiVersion()) {
            return;
        }
        for (int i = 0; i < this.locks.size(); ++i) {
            Table table = this.locks.get(i);
            if (table.isLockedExclusively()) continue;
            Database database = this.database;
            synchronized (database) {
                table.unlock(this);
                this.locks.remove(i);
            }
            --i;
        }
    }

    void unlock(Table table) {
        this.locks.remove(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockAll() {
        if (SysProperties.CHECK && this.undoLog.size() > 0) {
            DbException.throwInternalError();
        }
        if (this.locks.size() > 0) {
            Database database = this.database;
            synchronized (database) {
                int n = this.locks.size();
                for (int i = 0; i < n; ++i) {
                    Table table = this.locks.get(i);
                    table.unlock(this);
                }
                this.locks.clear();
            }
        }
        this.savepoints = null;
        this.sessionStateChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTempTables(boolean bl) {
        if (this.localTempTables != null && this.localTempTables.size() > 0) {
            Database database = this.database;
            synchronized (database) {
                for (Table table : New.arrayList(this.localTempTables.values())) {
                    if (bl || table.getOnCommitDrop()) {
                        ++this.modificationId;
                        table.setModified();
                        this.localTempTables.remove(table.getName());
                        table.removeChildrenAndResources(this);
                        if (!bl) continue;
                        this.database.commit(this);
                        continue;
                    }
                    if (!table.getOnCommitTruncate()) continue;
                    table.truncate(this);
                }
            }
        }
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    @Override
    public Trace getTrace() {
        if (this.trace != null && !this.closed) {
            return this.trace;
        }
        String string = "jdbc[" + this.id + "]";
        if (this.closed) {
            return new TraceSystem(null).getTrace(string);
        }
        this.trace = this.database.getTrace(string);
        return this.trace;
    }

    public void setLastIdentity(Value value) {
        this.lastIdentity = value;
        this.lastScopeIdentity = value;
    }

    public Value getLastIdentity() {
        return this.lastIdentity;
    }

    public void setLastScopeIdentity(Value value) {
        this.lastScopeIdentity = value;
    }

    public Value getLastScopeIdentity() {
        return this.lastScopeIdentity;
    }

    public void addLogPos(int n, int n2) {
        if (this.firstUncommittedLog == -1) {
            this.firstUncommittedLog = n;
            this.firstUncommittedPos = n2;
        }
    }

    public int getFirstUncommittedLog() {
        return this.firstUncommittedLog;
    }

    void setAllCommitted() {
        this.firstUncommittedLog = -1;
        this.firstUncommittedPos = -1;
    }

    public boolean containsUncommitted() {
        if (this.database.getMvStore() != null) {
            return this.transaction != null;
        }
        return this.firstUncommittedLog != -1;
    }

    public void addSavepoint(String string) {
        if (this.savepoints == null) {
            this.savepoints = this.database.newStringMap();
        }
        Savepoint savepoint = new Savepoint();
        savepoint.logIndex = this.undoLog.size();
        if (this.database.getMvStore() != null) {
            savepoint.transactionSavepoint = this.getStatementSavepoint();
        }
        this.savepoints.put(string, savepoint);
    }

    public void rollbackToSavepoint(String string) {
        this.checkCommitRollback();
        if (this.savepoints == null) {
            throw DbException.get(90063, string);
        }
        Savepoint savepoint = this.savepoints.get(string);
        if (savepoint == null) {
            throw DbException.get(90063, string);
        }
        this.rollbackTo(savepoint, false);
    }

    public void prepareCommit(String string) {
        if (this.transaction != null) {
            this.database.prepareCommit(this, string);
        }
        if (this.containsUncommitted()) {
            this.database.prepareCommit(this, string);
        }
        this.currentTransactionName = string;
    }

    public void setPreparedTransaction(String string, boolean bl) {
        if (this.currentTransactionName != null && this.currentTransactionName.equals(string)) {
            if (bl) {
                this.commit(false);
            } else {
                this.rollback();
            }
        } else {
            ArrayList<InDoubtTransaction> arrayList = this.database.getInDoubtTransactions();
            int n = bl ? 1 : 2;
            boolean bl2 = false;
            if (arrayList != null) {
                for (InDoubtTransaction inDoubtTransaction : arrayList) {
                    if (!inDoubtTransaction.getTransactionName().equals(string)) continue;
                    inDoubtTransaction.setState(n);
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) {
                throw DbException.get(90129, string);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void setThrottle(int n) {
        this.throttle = n;
    }

    public void throttle() {
        if (this.currentCommandStart == 0L) {
            this.currentCommandStart = System.currentTimeMillis();
        }
        if (this.throttle == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.lastThrottle + 50L > l) {
            return;
        }
        this.lastThrottle = l + (long)this.throttle;
        try {
            Thread.sleep(this.throttle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCurrentCommand(Command command) {
        this.currentCommand = command;
        if (this.queryTimeout > 0 && command != null) {
            long l;
            this.currentCommandStart = l = System.currentTimeMillis();
            this.cancelAt = l + (long)this.queryTimeout;
        }
    }

    public void checkCanceled() {
        this.throttle();
        if (this.cancelAt == 0L) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l >= this.cancelAt) {
            this.cancelAt = 0L;
            throw DbException.get(57014);
        }
    }

    public long getCancel() {
        return this.cancelAt;
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    public long getCurrentCommandStart() {
        return this.currentCommandStart;
    }

    public boolean getAllowLiterals() {
        return this.allowLiterals;
    }

    public void setAllowLiterals(boolean bl) {
        this.allowLiterals = bl;
    }

    public void setCurrentSchema(Schema schema) {
        ++this.modificationId;
        this.currentSchemaName = schema.getName();
    }

    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public JdbcConnection createConnection(boolean bl) {
        String string = bl ? "jdbc:columnlist:connection" : "jdbc:default:connection";
        return new JdbcConnection(this, this.getUser().getName(), string);
    }

    @Override
    public DataHandler getDataHandler() {
        return this.database;
    }

    public void unlinkAtCommit(Value value) {
        if (SysProperties.CHECK && !value.isLinked()) {
            DbException.throwInternalError();
        }
        if (this.unlinkLobMap == null) {
            this.unlinkLobMap = New.hashMap();
        }
        this.unlinkLobMap.put(value.toString(), value);
    }

    public void unlinkAtCommitStop(Value value) {
        if (this.unlinkLobMap != null) {
            this.unlinkLobMap.remove(value.toString());
        }
    }

    public String getNextSystemIdentifier(String string) {
        String string2;
        while (string.contains(string2 = SYSTEM_IDENTIFIER_PREFIX + this.systemIdentifier++)) {
        }
        return string2;
    }

    public void addProcedure(Procedure procedure) {
        if (this.procedures == null) {
            this.procedures = this.database.newStringMap();
        }
        this.procedures.put(procedure.getName(), procedure);
    }

    public void removeProcedure(String string) {
        if (this.procedures != null) {
            this.procedures.remove(string);
        }
    }

    public Procedure getProcedure(String string) {
        if (this.procedures == null) {
            return null;
        }
        return this.procedures.get(string);
    }

    public void setSchemaSearchPath(String[] stringArray) {
        ++this.modificationId;
        this.schemaSearchPath = stringArray;
    }

    public String[] getSchemaSearchPath() {
        return this.schemaSearchPath;
    }

    public int hashCode() {
        return this.serialId;
    }

    public String toString() {
        return "#" + this.serialId + " (user: " + this.user.getName() + ")";
    }

    public void setUndoLogEnabled(boolean bl) {
        this.undoLogEnabled = bl;
    }

    public void setRedoLogBinary(boolean bl) {
        this.redoLogBinary = bl;
    }

    public boolean isUndoLogEnabled() {
        return this.undoLogEnabled;
    }

    public void begin() {
        this.autoCommitAtTransactionEnd = true;
        this.autoCommit = false;
    }

    public long getSessionStart() {
        return this.sessionStart;
    }

    public long getTransactionStart() {
        if (this.transactionStart == 0L) {
            this.transactionStart = System.currentTimeMillis();
        }
        return this.transactionStart;
    }

    public Table[] getLocks() {
        ArrayList<Table> arrayList = New.arrayList();
        for (int i = 0; i < this.locks.size(); ++i) {
            try {
                arrayList.add(this.locks.get(i));
                continue;
            }
            catch (Exception exception) {
                break;
            }
        }
        Table[] tableArray = new Table[arrayList.size()];
        arrayList.toArray(tableArray);
        return tableArray;
    }

    public void waitIfExclusiveModeEnabled() {
        Session session;
        if (this.database.getLobSession() == this) {
            return;
        }
        while ((session = this.database.getExclusiveSession()) != null && session != this && !Thread.holdsLock(session)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addTemporaryResult(LocalResult localResult) {
        if (!localResult.needToClose()) {
            return;
        }
        if (this.temporaryResults == null) {
            this.temporaryResults = New.hashSet();
        }
        if (this.temporaryResults.size() < 100) {
            this.temporaryResults.add(localResult);
        }
    }

    private void closeTemporaryResults() {
        if (this.temporaryResults != null) {
            for (LocalResult localResult : this.temporaryResults) {
                localResult.close();
            }
            this.temporaryResults = null;
        }
    }

    public void setQueryTimeout(int n) {
        int n2 = this.database.getSettings().maxQueryTimeout;
        if (n2 != 0 && (n2 < n || n == 0)) {
            n = n2;
        }
        this.queryTimeout = n;
        this.cancelAt = 0L;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setWaitForLock(Table table, Thread thread) {
        this.waitForLock = table;
        this.waitForLockThread = thread;
    }

    public Table getWaitForLock() {
        return this.waitForLock;
    }

    public Thread getWaitForLockThread() {
        return this.waitForLockThread;
    }

    public int getModificationId() {
        return this.modificationId;
    }

    @Override
    public boolean isReconnectNeeded(boolean bl) {
        block2: {
            do {
                boolean bl2;
                if (bl2 = this.database.isReconnectNeeded()) {
                    return true;
                }
                if (!bl) break block2;
            } while (!this.database.beforeWriting());
            return false;
        }
        return false;
    }

    @Override
    public void afterWriting() {
        this.database.afterWriting();
    }

    @Override
    public SessionInterface reconnect(boolean bl) {
        this.readSessionState();
        this.close();
        Session session = Engine.getInstance().createSession(this.connectionInfo);
        session.sessionState = this.sessionState;
        session.recreateSessionState();
        if (bl) {
            while (!session.database.beforeWriting()) {
            }
        }
        return session;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public Value getTransactionId() {
        if (!this.database.isPersistent()) {
            return ValueNull.INSTANCE;
        }
        if (this.database.getMvStore() != null) {
            if (this.transaction == null) {
                return ValueNull.INSTANCE;
            }
            return ValueString.get(Long.toString(this.getTransaction().getId()));
        }
        if (this.undoLog.size() == 0) {
            return ValueNull.INSTANCE;
        }
        return ValueString.get(this.firstUncommittedLog + "-" + this.firstUncommittedPos + "-" + this.id);
    }

    public int nextObjectId() {
        return this.objectId++;
    }

    public boolean isRedoLogBinaryEnabled() {
        return this.redoLogBinary;
    }

    public TransactionStore.Transaction getTransaction() {
        if (this.transaction == null) {
            if (this.database.getMvStore().getStore().isClosed()) {
                throw DbException.get(90098);
            }
            this.transaction = this.database.getMvStore().getTransactionStore().begin();
            this.startStatement = -1L;
        }
        return this.transaction;
    }

    public long getStatementSavepoint() {
        if (this.startStatement == -1L) {
            this.startStatement = this.getTransaction().setSavepoint();
        }
        return this.startStatement;
    }

    public void startStatementWithinTransaction() {
        this.startStatement = -1L;
    }

    public void endStatement() {
        this.startStatement = -1L;
        this.closeTemporaryResults();
    }

    @Override
    public void addTemporaryLob(Value value) {
        if (this.temporaryLobs == null) {
            this.temporaryLobs = new ArrayList();
        }
        this.temporaryLobs.add(value);
    }

    public static class Savepoint {
        int logIndex;
        long transactionSavepoint;
    }
}

