<%@ page session="false" pageEncoding="UTF-8" %>
<%@ include file="common/includes.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title><c:if test="${!empty keyword}"> ${keyword} - </c:if>全文检索平台</title>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8"/>
    <link href="css/main.css" type="text/css" media="screen" rel="stylesheet"/>
    <script src="js/jquery-min.js" type="text/javascript"></script>
    <script src="js/jquery.autocomplete.js" type="text/javascript"></script>
    <script src="js/main.js" type="text/javascript"></script>
</head>
<body>
<form action="" method="get" id="s-form">
    <c:choose>
        <c:when test="${empty keyword}">
            <div id="s-input1">
                <div>
                    <img src="img/logo.jpg" alt=""/><br/><br/><br/><br/>
                    <c:if test="${!empty param.bid}"><a href="${ctx}">全部</a>&nbsp;&nbsp;</c:if>
                    <c:forEach items="${bizs}" var="biz">
                        <c:choose><c:when test="${biz.id==param.bid}"><strong>${biz.name}</strong></c:when><c:otherwise><a href="?bid=${biz.id}">${biz.name}</a></c:otherwise></c:choose>&nbsp;&nbsp;
                    </c:forEach>
                </div>
                <input type="hidden" name="bid" value="${param.bid}"/>
                <input type="text" name="keyword" id="keyword" value="${keyword}" class="text"/>&nbsp;
                <input type="submit" value="搜 索" class="btn"/>
                <div id="s-stat">
                    共有${stat.text}条记录,${stat.file}个文件,${stat.img}个图片,${stat.doc}个文档,${stat.biz}个业务,${stat.cat}个分类加入索引
                    <br/>处理了${stat.search}个检索请求
                </div>
                <br/><c:if test="${isAdmin}"><a href="console.do">管理索引</a></c:if>
            </div>
        </c:when>
        <c:otherwise>
            <input type="hidden" name="index"/>
            <div id="s-input">
                <a href="${ctx}" title="首页"><img src="img/logos.jpg" alt=""/></a>
                <input type="text" name="keyword" id="keyword" value="${keyword}" class="text"/>&nbsp;
                <input type="submit" value="搜 索" class="btn"/>
            </div>
            <c:if test="${!empty page}"><div id="s-count">
                找到 ${page.totalCount} 条结果 （用时 ${page.qTime/1000} 秒）
            </div></c:if>
            <div id="sidebar">
                <c:forEach items="${page.facets}" var="entry">
                    <ul>
                        <c:forEach items="${entry.value}" var="facet">
                            <c:choose>
                                <c:when test="${entry.key=='bid'}">
                                    <li<c:if test="${param.bid==facet.code || empty param.bid && empty facet.code}"> class="active"</c:if>>
                                        <a href="?keyword=${keyword}&bid=${facet.code}&mt=${param.mt}&date=${param.date}&sort=${param.sort}">${facet.name} (${facet.count})</a>
                                    </li>
                                </c:when>
                                <c:when test="${entry.key=='cid'}">
                                    <li<c:if test="${param.cid==facet.code || empty param.cid && empty facet.code}"> class="active"</c:if>>
                                        <a href="?keyword=${keyword}&bid=${param.bid}&cid=${facet.code}&mt=${param.mt}&date=${param.date}&sort=${param.sort}">${facet.name} (${facet.count})</a>
                                    </li>
                                </c:when>
                                <c:when test="${entry.key=='mt'}">
                                    <li<c:if test="${param.mt==facet.code || empty param.mt && empty facet.code}"> class="active"</c:if>>
                                        <a href="?keyword=${keyword}&bid=${param.bid}&cid=${param.cid}&mt=${facet.code}&date=${param.date}&sort=${param.sort}">${facet.name} (${facet.count})</a>
                                    </li>
                                </c:when>
                                <c:when test="${entry.key=='date'}">
                                    <li<c:if test="${param.date==facet.code || empty param.date && empty facet.code}"> class="active"</c:if>>
                                        <a href="?keyword=${keyword}&bid=${param.bid}&cid=${param.cid}&mt=${param.mt}&date=${facet.code}&sort=${param.sort}">${facet.name}</a>
                                    </li>
                                </c:when>
                                <c:when test="${entry.key=='sort'}">
                                    <li<c:if test="${param.sort==facet.code && !empty param.sort || empty param.sort && facet.code=='score'}"> class="active"</c:if>>
                                        <a href="?keyword=${keyword}&bid=${param.bid}&cid=${param.cid}&mt=${param.mt}&date=${param.date}&sort=${facet.code}">${facet.name}</a>
                                    </li>
                                </c:when>
                            </c:choose>
                        </c:forEach>
                        <li class="sep"></li>
                    </ul>
                </c:forEach>
            </div>
            <div id="tbody">
                <c:if test="${!empty page.scs}">
                    <div class="search-sc">您是不是要找：
                        <c:forEach items="${page.scs}" var="mlt">
                            <a href="?keyword=${mlt}">${mlt}</a>&nbsp;&nbsp;
                        </c:forEach>
                    </div>
                </c:if>
                <c:forEach items="${page.items}" var="result">
                    <div class="search-result">
                        <h3 class="result-title">
                            <a href="${result.url}" target="_blank"><c:if test="${!empty result.icon}"><img src="img/icon/${result.icon}" alt="icon"/></c:if><c:out value="${result.title}" default="无标题" escapeXml="false"/></a>
                        </h3>
                        <div class="result-info">
                            <c:if test="${empty param.bid && !empty result.businessName}"><a href="?keyword=${keyword}&bid=${result.businessId}&mt=${param.mt}&date=${param.date}&sort=${param.sort}">${result.businessName}</a>&nbsp;<c:set var="hasBn" value="true"/></c:if><c:if test="${empty param.cid && !empty result.categoryName}"><c:if test="${!empty hasBn}">›&nbsp;</c:if><a href="?keyword=${keyword}&bid=${result.businessId}&cid=${result.categoryId}&mt=${param.mt}&date=${param.date}&sort=${param.sort}">${result.categoryName}</a>&nbsp;</c:if><span class="info"><fmt:formatDate value="${result.date}" pattern="yyyy-MM-dd HH:mm"/></span>
                        </div>
                        <div class="result-body clearfix">${result.body}</div>
                    </div>
                </c:forEach>
                <c:if test="${!empty page.mlts}">
                    <div class="search-mlt"><h3><em>${keyword}</em>的相关搜索</h3>
                        <c:forEach items="${page.mlts}" var="mlt" varStatus="vs">
                            <a href="?keyword=${mlt}">${mlt}</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<c:if test="${vs.index % 4==3}"><br/></c:if>
                        </c:forEach>
                    </div>
                </c:if>
                <c:import url="common/pagination.jsp">
                    <c:param name="url" value="?keyword=${keyword}&bid=${param.bid}&cid=${param.cid}&mt=${param.mt}&date=${param.date}&sort=${param.sort}"/>
                </c:import>
            </div>
            <div style="clear: both;height: 50px;">&nbsp;</div>
        </c:otherwise>
    </c:choose>
</form>
</body>
</html>