<%@ page session="false" pageEncoding="UTF-8" %>
<%@ include file="common/header.jsp" %>
<table class="list-table" style="width: 100%;">
    <caption>
        <a href="reloadAll.do" class="a-btn" onclick="return confirm('确定要重载所有业务吗?')">重载所有业务</a>
        <a href="rebuildAll.do" class="a-btn" onclick="return confirm('确定要重建所有索引吗?')">重建所有索引</a>
        <a href="reset.do" class="a-btn" onclick="return confirm('确定要重置所有吗?')">重置所有</a>
        <a href="optimize.do" class="a-btn" onclick="return confirm('确定要优化索引吗?')">优化索引</a>
        <a href="rebuildSpellcheck.do" class="a-btn" onclick="return confirm('确定要重建语法检查吗?')">重建语法检查</a>
        <a href="rebuildSuggest.do" class="a-btn" onclick="return confirm('确定要重建自动完成吗?')">重建自动完成</a>
        <a href="?count=true" class="a-btn">查看索引数量</a>
    </caption>
    <tr>
        <th>名称</th>
        <th style="width:100px;">已索引数量</th>
        <th style="width:100px;">索引数量</th>
        <th style="width:130px;">操作</th>
    </tr>
    <c:forEach items="${bizs}" var="biz">
        <tr class="biz">
            <td style="font-weight: bold;">${biz.name}</td>
            <td><c:out value="${bizMap[biz.id]}" default="0"/></td>
            <td></td>
            <td>
                <a href="rebuild.do?bid=${biz.id}" onclick="return confirm('确定要重建索引吗?')">重建索引</a>&nbsp;
                <a href="reload.do?id=${biz.id}">重载业务</a>
            </td>
        </tr>
        <c:forEach items="${biz.categories}" var="cat">
            <tr>
                <td style="padding-left: 3em;"><c:out value="${cat.name}" default="${biz.name}"/></td>
                <td><c:out value="${catMap[cat.id]}" default="0"/></td>
                <th style="width:100px;"><a href="#" onclick="return getIndexCount('${cat.id}',this)">查看</a>&nbsp;&nbsp;<span><c:if test="${!empty counts}">${counts[cat.id]}</c:if></span></th>
                <td><a href="rebuild.do?cid=${cat.id}" onclick="return confirm('确定要重建索引吗?')">重建索引</a></td>
            </tr>
        </c:forEach>
    </c:forEach>
</table>
<%@ include file="common/footer.jsp" %>
