/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.search.web;

import com.gtis.common.Page;
import com.gtis.egov.search.model.Result;
import com.gtis.egov.search.service.CategoryIndexManager;
import com.gtis.egov.search.service.SearchManager;
import com.gtis.egov.search.service.StatManager;
import com.gtis.search.Business;
import com.gtis.search.MimeType;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class IndexController {
    private static final Pattern ID_PATTERN = Pattern.compile("^([A-Z0-9]{16}|[A-F0-9]{32})$");
    @Autowired
    private SearchManager searchManager;
    @Autowired
    private CategoryIndexManager categoryManager;
    @Autowired
    private StatManager statManager;

    @RequestMapping(value={"index.do"})
    public String index(@RequestParam(value="keyword", required=false) String keyword, @RequestParam(value="bid", required=false) String bid, @RequestParam(value="cid", required=false) String cid, @RequestParam(value="date", required=false) String date, @RequestParam(value="mt", required=false) Integer mimetype, @RequestParam(value="index", required=false) Integer index, @RequestParam(value="size", defaultValue="20") int size, @RequestParam(value="sort", required=false) String sort, Model model) {
        if (StringUtils.isEmpty((String)(keyword = StringUtils.trim((String)keyword)))) {
            Map map = this.statManager.getBusinessIndexCount(true);
            ArrayList<Business> bizs = new ArrayList<Business>();
            for (Business biz : this.categoryManager.getBusinesses()) {
                if (!map.containsKey(biz.getId())) continue;
                bizs.add(biz);
            }
            model.addAttribute("bizs", bizs);
            model.addAttribute("stat", (Object)this.statManager.getStat());
            model.addAttribute("isAdmin", (Object)SessionUtil.getCurrentUser().isAdmin());
        } else if (ID_PATTERN.matcher(keyword).matches()) {
            keyword = "id:" + keyword;
        }
        model.addAttribute("page", (Object)this.searchManager.search(keyword, bid, cid, date, mimetype == null ? null : MimeType.values()[mimetype], sort, Page.toStart((Integer)index, (int)size), size));
        model.addAttribute("keyword", (Object)keyword);
        return "index";
    }

    @ResponseBody
    @RequestMapping(value={"suggest.do"}, method={RequestMethod.GET})
    public List<Map<String, String>> suggest(@RequestParam(value="keyword", required=false) String keyword, @RequestParam(value="bid", required=false) String bid, @RequestParam(value="cid", required=false) String cid, @RequestParam(value="count", defaultValue="8") Integer count) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Result result : this.searchManager.suggest(keyword, bid, cid, count.intValue())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("url", result.getUrl());
            map.put("title", result.getTitle());
            map.put("icon", result.getIcon() == null ? "file/index.gif" : result.getIcon());
            map.put("bn", result.getBusinessName());
            map.put("cn", result.getCategoryName());
            list.add(map);
        }
        return list;
    }

    @ResponseBody
    @RequestMapping(value={"auto.do"}, method={RequestMethod.GET})
    public List<String> auto(@RequestParam(value="keyword", required=false) String keyword, @RequestParam(value="count", defaultValue="8") Integer count) {
        return this.searchManager.autocomplete(keyword, count.intValue());
    }

    @ResponseBody
    @RequestMapping(value={"test.do"})
    public void test() {
    }
}

