/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.search.web;

import com.gtis.config.EgovConfigLoader;
import com.gtis.spring.Container;
import java.io.File;
import java.io.FileNotFoundException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class EgovSolrDispatchFilter
extends SolrDispatchFilter {
    protected static final Logger LOG = LoggerFactory.getLogger(EgovSolrDispatchFilter.class);

    public void init(FilterConfig config) throws ServletException {
        EgovConfigLoader.load((String[])new String[0]);
        System.setProperty("solr.solr.home", config.getServletContext().getRealPath("/WEB-INF/solr"));
        try {
            File data = ResourceUtils.getFile((String)(System.getProperty("egov.data") + "/solr"));
            LOG.info("Use solr.data.dir:[{}]", (Object)data.getAbsolutePath());
            System.setProperty("solr.data.dir", data.getAbsolutePath());
        }
        catch (FileNotFoundException ignored) {
            throw new ServletException("solr data dir not found");
        }
        super.init(config);
        EmbeddedSolrServer solrServer = new EmbeddedSolrServer(this.cores, this.cores.getDefaultCoreName());
        config.getServletContext().setAttribute(EgovSolrDispatchFilter.class.getName(), (Object)solrServer);
        Container.createApplicationContext((ServletContext)config.getServletContext());
    }
}

