/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.search.web;

import com.gtis.egov.search.service.CategoryIndexManager;
import com.gtis.egov.search.service.StatManager;
import com.gtis.search.Business;
import com.gtis.search.Category;
import com.gtis.web.SessionUtil;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ConsoleController {
    @Autowired
    private CategoryIndexManager categoryManager;
    @Autowired
    private StatManager statManager;

    @RequestMapping(value={"console.do"}, method={RequestMethod.GET})
    public String index(Model model, @RequestParam(value="count", defaultValue="false") Boolean count) {
        model.addAttribute("bizs", (Object)this.categoryManager.getBusinesses());
        model.addAttribute("bizMap", (Object)this.statManager.getBusinessIndexCount(false));
        model.addAttribute("catMap", (Object)this.statManager.getCategoryIndexCount(false));
        model.addAttribute("tab", (Object)"console");
        if (count.booleanValue()) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Category cat : this.categoryManager.getCategories()) {
                map.put(cat.getId(), this.categoryManager.getTotalCount(cat.getId()));
            }
            model.addAttribute("counts", map);
        }
        return "console";
    }

    @RequestMapping(value={"queue.do"}, method={RequestMethod.GET})
    public String queue(Model model) {
        model.addAttribute("tasks", (Object)this.categoryManager.getRebuildTasks());
        model.addAttribute("bizMap", (Object)this.categoryManager.getBusinessMap());
        model.addAttribute("catMap", (Object)this.categoryManager.getCategoryMap());
        model.addAttribute("tab", (Object)"queue");
        return "queue";
    }

    @ResponseBody
    @RequestMapping(value={"count.do"})
    public int count(@RequestParam(value="id") String id) {
        return this.categoryManager.getTotalCount(id);
    }

    @RequestMapping(value={"stop.do"}, method={RequestMethod.GET})
    public String stop(@RequestParam(value="id") String id) {
        this.categoryManager.stopRebuildTask(id);
        return "redirect:/queue.do";
    }

    @RequestMapping(value={"rebuild.do"}, method={RequestMethod.GET})
    public String rebuild(@RequestParam(value="cid", required=false) String cid, @RequestParam(value="bid", required=false) String bid) {
        Business biz;
        if (StringUtils.isNotBlank((String)cid)) {
            this.categoryManager.rebuild(cid);
        }
        if (StringUtils.isNotBlank((String)bid) && (biz = this.categoryManager.getBusiness(bid)) != null) {
            for (Category cat : biz.getCategories()) {
                this.categoryManager.rebuild(cat.getId());
            }
        }
        return "redirect:/queue.do";
    }

    @RequestMapping(value={"rebuildAll.do"}, method={RequestMethod.GET})
    public String rebuildAll() {
        this.categoryManager.rebuildAll();
        return "redirect:/queue.do";
    }

    @RequestMapping(value={"reload.do"}, method={RequestMethod.GET})
    public String reload(@RequestParam(value="id") String id) {
        this.categoryManager.reload(id);
        return "redirect:/console.do";
    }

    @RequestMapping(value={"reloadAll.do"}, method={RequestMethod.GET})
    public String reloadAll() {
        this.categoryManager.reloadAll();
        return "redirect:/console.do";
    }

    @RequestMapping(value={"reset.do"}, method={RequestMethod.GET})
    public String reset() throws IOException, SolrServerException {
        this.categoryManager.reset();
        return "redirect:/console.do";
    }

    @RequestMapping(value={"analysis.do"}, method={RequestMethod.GET})
    public String analysis(Model model) {
        this.categoryManager.rebuildSuggest();
        model.addAttribute("tab", (Object)"analysis");
        return "analysis";
    }

    @RequestMapping(value={"optimize.do"}, method={RequestMethod.GET})
    public String optimize() throws IOException, SolrServerException {
        this.categoryManager.optimize();
        return "redirect:/console.do";
    }

    @RequestMapping(value={"rebuildSpellcheck.do"}, method={RequestMethod.GET})
    public String rebuildSpellcheck() throws IOException, SolrServerException {
        this.categoryManager.rebuildSpellcheck();
        return "redirect:/console.do";
    }

    @RequestMapping(value={"rebuildSuggest.do"}, method={RequestMethod.GET})
    public String rebuildSuggest() throws IOException, SolrServerException {
        this.categoryManager.rebuildSuggest();
        return "redirect:/console.do";
    }

    @ModelAttribute
    public void assertAdmin() {
        if (!SessionUtil.getCurrentUser().isAdmin()) {
            throw new RuntimeException("No permission!");
        }
    }
}

