/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.search.service.impl;

import com.gtis.egov.search.model.Stat;
import com.gtis.egov.search.service.CategoryIndexManager;
import com.gtis.egov.search.service.StatManager;
import com.gtis.egov.search.service.impl.StatManagerImpl;
import com.gtis.generic.cache.CacheUtils;
import com.gtis.generic.cache.EntityLoader;
import com.gtis.search.MimeType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.Ehcache;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatManagerImpl
implements StatManager {
    private AtomicInteger searchCount = new AtomicInteger();
    private SolrServer solrServer;
    private CategoryIndexManager categoryManager;
    private Ehcache cache;

    public void setSolrServer(SolrServer solrServer) {
        this.solrServer = solrServer;
    }

    public void setCategoryManager(CategoryIndexManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setCache(Ehcache cache) {
        this.cache = cache;
    }

    public Stat getStat() {
        Stat stat = (Stat)CacheUtils.load((Ehcache)this.cache, (Object)"stat", (EntityLoader)new /* Unavailable Anonymous Inner Class!! */);
        stat.setSearch(this.searchCount.intValue());
        return stat;
    }

    private Stat getCount() {
        Stat stat = new Stat();
        stat.setBiz(this.categoryManager.getBusinesses().size());
        stat.setCat(this.categoryManager.getCategories().size());
        SolrQuery query = new SolrQuery("type:0");
        query.setRows(Integer.valueOf(0));
        query.addFacetField(new String[]{"mimeType"});
        try {
            QueryResponse rsp = this.solrServer.query((SolrParams)query);
            FacetField ff = rsp.getFacetField("mimeType");
            if (ff != null) {
                int allCount = 0;
                for (FacetField.Count count : ff.getValues()) {
                    MimeType mt = MimeType.values()[Integer.valueOf(count.getName())];
                    int c = (int)count.getCount();
                    switch (4.$SwitchMap$com$gtis$search$MimeType[mt.ordinal()]) {
                        case 1: {
                            stat.setText(c);
                            break;
                        }
                        case 2: {
                            stat.setFile(c);
                            break;
                        }
                        case 3: {
                            stat.setDoc(c);
                            break;
                        }
                        case 4: {
                            stat.setImg(c);
                        }
                    }
                    allCount += c;
                }
                stat.setIndex(allCount);
            }
        }
        catch (SolrServerException solrServerException) {
            // empty catch block
        }
        return stat;
    }

    public void increaseSearchCount() {
        this.searchCount.incrementAndGet();
    }

    public Map<String, Integer> getBusinessIndexCount(boolean useCache) {
        if (!useCache) {
            return this.getBusinessIndexCount0();
        }
        return (Map)CacheUtils.load((Ehcache)this.cache, (Object)"bizs", (EntityLoader)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Map<String, Integer> getCategoryIndexCount(boolean useCache) {
        if (!useCache) {
            return this.getCategoryIndexCount0();
        }
        return (Map)CacheUtils.load((Ehcache)this.cache, (Object)"cats", (EntityLoader)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Map<String, Integer> getBusinessIndexCount0() {
        SolrQuery query = new SolrQuery("type:0");
        query.setRows(Integer.valueOf(0));
        query.addFacetField(new String[]{"businessId"});
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            QueryResponse rsp = this.solrServer.query((SolrParams)query);
            FacetField ff = rsp.getFacetField("businessId");
            if (ff != null) {
                for (FacetField.Count count : ff.getValues()) {
                    map.put(count.getName(), (int)count.getCount());
                }
            }
        }
        catch (SolrServerException solrServerException) {
            // empty catch block
        }
        return map;
    }

    private Map<String, Integer> getCategoryIndexCount0() {
        SolrQuery query = new SolrQuery("type:0");
        query.setRows(Integer.valueOf(0));
        query.addFacetField(new String[]{"categoryId"});
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            QueryResponse rsp = this.solrServer.query((SolrParams)query);
            FacetField ff = rsp.getFacetField("categoryId");
            if (ff != null) {
                for (FacetField.Count count : ff.getValues()) {
                    map.put(count.getName(), (int)count.getCount());
                }
            }
        }
        catch (SolrServerException solrServerException) {
            // empty catch block
        }
        return map;
    }

    static /* synthetic */ Stat access$000(StatManagerImpl x0) {
        return x0.getCount();
    }

    static /* synthetic */ Map access$100(StatManagerImpl x0) {
        return x0.getBusinessIndexCount0();
    }

    static /* synthetic */ Map access$200(StatManagerImpl x0) {
        return x0.getCategoryIndexCount0();
    }
}

