/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.search.service.impl;

import com.gtis.config.AppConfig;
import com.gtis.egov.search.model.Facet;
import com.gtis.egov.search.model.Result;
import com.gtis.egov.search.model.ResultModel;
import com.gtis.egov.search.model.ResultPage;
import com.gtis.egov.search.service.CategoryIndexManager;
import com.gtis.egov.search.service.SearchManager;
import com.gtis.egov.search.service.StatManager;
import com.gtis.fileCenter.service.MimeTypeService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.search.Business;
import com.gtis.search.Category;
import com.gtis.search.MimeType;
import com.gtis.web.SessionUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SearchManagerImpl
implements SearchManager {
    protected static final Logger LOG = LoggerFactory.getLogger(SearchManagerImpl.class);
    private static final List<Facet> DEFALUT_DATE_FACETS = new ArrayList();
    private static final List<Facet> DEFALUT_SORT_FACETS = new ArrayList();
    private static Map tplCaches = Collections.synchronizedMap(new LRUMap(500));
    private SolrServer solrServer;
    private CategoryIndexManager categoryManager;
    private Configuration freemarkerConfigurer;
    private MimeTypeService mimeTypeService;
    private StatManager statManager;
    private int bodyEllipsisCount = 85;

    public void setSolrServer(SolrServer solrServer) {
        this.solrServer = solrServer;
    }

    public void setCategoryManager(CategoryIndexManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setFreemarkerConfigurer(Configuration freemarkerConfigurer) {
        this.freemarkerConfigurer = freemarkerConfigurer;
    }

    public void setMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    public void setStatManager(StatManager statManager) {
        this.statManager = statManager;
    }

    public void setBodyEllipsisCount(int bodyEllipsisCount) {
        this.bodyEllipsisCount = bodyEllipsisCount;
    }

    public ResultPage search(String keyword, String businessId, String categoryId, String date, MimeType mimeType, String sort, int start, int size) {
        if (StringUtils.isBlank((String)keyword)) {
            return null;
        }
        if ("*".equals(keyword)) {
            keyword = "*:*";
        }
        SolrQuery query = new SolrQuery(keyword);
        if (StringUtils.isNotBlank((String)sort)) {
            query.setSortField(sort, SolrQuery.ORDER.desc);
        }
        query.setStart(Integer.valueOf(start)).setRows(Integer.valueOf(size));
        query.setHighlightSnippets(3).setHighlightFragsize(30).addHighlightField("*");
        query.set("spellcheck", true).set("spellcheck.dictionary", new String[]{"spellchecker"}).set("spellcheck.count", 3);
        query.addFilterQuery(new String[]{"type:0"});
        this.addPermissionFilter(query);
        query.setFacetMinCount(1);
        query.addFacetField(new String[]{"{!ex=bi,ci,mt}businessId"});
        if (StringUtils.isNotEmpty((String)businessId)) {
            query.addFilterQuery(new String[]{"{!tag=bi}businessId:" + businessId});
            query.addFacetField(new String[]{"{!ex=ci,mt}categoryId"});
        }
        if (StringUtils.isNotEmpty((String)categoryId)) {
            query.addFilterQuery(new String[]{"{!tag=ci}categoryId:" + categoryId});
        }
        if (mimeType != null) {
            if (mimeType == MimeType.BIN) {
                query.addFilterQuery(new String[]{"{!tag=mt}mimeType:(1 OR 2 OR 3)"});
            } else {
                query.addFilterQuery(new String[]{"{!tag=mt}mimeType:" + mimeType.ordinal()});
            }
        }
        query.addFacetField(new String[]{"{!ex=mt}mimeType"});
        if (StringUtils.isNotEmpty((String)date)) {
            query.addFilterQuery(new String[]{"date:[NOW" + date + " TO NOW]"});
        }
        ResultPage page = new ResultPage();
        page.setStart(start);
        page.setSize(size);
        try {
            QueryResponse rsp = this.solrServer.query((SolrParams)query);
            page.setItems(this.getResults(rsp));
            page.setFacets(this.extractFacets(rsp));
            page.setScs(this.extractSpellchecks(rsp));
            page.setMlts(this.autocomplete(keyword, 8));
            page.setTotalCount((int)rsp.getResults().getNumFound());
            page.setqTime(rsp.getQTime());
        }
        catch (SolrServerException e) {
            LOG.debug("Error to search keyword [" + keyword + "],message:[" + e.getMessage() + "]");
        }
        this.statManager.increaseSearchCount();
        return page;
    }

    private void addPermissionFilter(SolrQuery query) {
        UserInfo user = SessionUtil.getCurrentUser();
        if (user != null) {
            query.addFilterQuery(new String[]{"ownerId:(" + user.getId() + " OR 0)"});
        }
    }

    private List<String> extractSpellchecks(QueryResponse rsp) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (rsp.getSpellCheckResponse() != null) {
            for (SpellCheckResponse.Suggestion s : rsp.getSpellCheckResponse().getSuggestions()) {
                suggestions.addAll(s.getAlternatives());
            }
        }
        return suggestions;
    }

    public List<Result> suggest(String keyword, String businessId, String categoryId, int size) {
        List<Result> results = Collections.emptyList();
        try {
            if (StringUtils.isNotBlank((String)keyword)) {
                List words = this.autocomplete(keyword, size);
                SolrQuery query = new SolrQuery(words.isEmpty() ? keyword : (String)words.get(0));
                query.addFilterQuery(new String[]{"type:0"});
                if (StringUtils.isNotEmpty((String)businessId)) {
                    query.addFilterQuery(new String[]{"businessId:" + businessId});
                }
                if (StringUtils.isNotEmpty((String)categoryId)) {
                    query.addFilterQuery(new String[]{"categoryId:" + categoryId});
                }
                this.addPermissionFilter(query);
                query.setRows(Integer.valueOf(size)).setHighlightSnippets(1).setHighlightFragsize(20).addHighlightField("title");
                return this.getResults(this.solrServer.query((SolrParams)query));
            }
        }
        catch (SolrServerException e) {
            LOG.debug("Error to get suggest for [" + keyword + "],message:[" + e.getMessage() + "]");
        }
        return results;
    }

    public List<String> autocomplete(String keyword, int size) {
        ArrayList<String> terms = new ArrayList<String>();
        try {
            if (StringUtils.isNotBlank((String)keyword)) {
                SolrQuery query = new SolrQuery(keyword);
                query.setRows(Integer.valueOf(0)).set("spellcheck", true).set("spellcheck.dictionary", new String[]{"suggest"}).set("spellcheck.count", size);
                QueryResponse rsp = this.solrServer.query((SolrParams)query);
                return this.extractSpellchecks(rsp);
            }
        }
        catch (SolrServerException e) {
            LOG.debug("Error to get autocomplete for [" + keyword + "],message:[" + e.getMessage() + "]");
        }
        return terms;
    }

    private List<Result> getResults(QueryResponse rsp) {
        SolrDocumentList docs = rsp.getResults();
        ArrayList<Result> results = new ArrayList<Result>(docs.size());
        HashMap<Object, Object> env = new HashMap<Object, Object>(System.getProperties());
        env.putAll(AppConfig.getProperties());
        for (SolrDocument doc : docs) {
            Map hl = null;
            if (rsp.getHighlighting() != null) {
                hl = (Map)rsp.getHighlighting().get(SearchManagerImpl.getStr((SolrDocument)doc, (String)"id"));
            }
            if (hl == null) {
                hl = Collections.emptyMap();
            }
            results.add(this.renderResult(this.extractResult(doc, hl), env));
        }
        return results;
    }

    private Result renderResult(Result result, Map env) {
        Category category = this.categoryManager.getCategory(result.getCategoryId());
        if (category != null) {
            Business business = this.categoryManager.getBusiness(category.getBusinessId());
            Map model = category.getTplVars();
            model.putAll(business.getTplVars());
            model.put("env", env);
            ResultModel tm = new ResultModel(result, model);
            String text = this.renderTpl(this.getTpl(business, category, result.getMimeType() == MimeType.TEXT ? "textUrl" : "fileUrl"), (TemplateModel)tm);
            result.setUrl(StringUtils.isEmpty((String)text) ? "#" : text);
            text = this.renderTpl(this.getTpl(business, category, result.getMimeType() == MimeType.TEXT ? "textBody" : "fileBody"), (TemplateModel)tm);
            if (StringUtils.isNotEmpty((String)text)) {
                result.setBody(text);
            }
        }
        return result;
    }

    private String getTpl(Business business, Category category, String tplType) {
        String tpl = category.getTpl(tplType);
        if (tpl == null) {
            tpl = business.getTpl(tplType);
        }
        return tpl;
    }

    private String renderTpl(String tplText, TemplateModel model) {
        if (StringUtils.isEmpty((String)tplText)) {
            return null;
        }
        StringWriter result = new StringWriter();
        try {
            Template tpl = (Template)tplCaches.get(tplText);
            if (tpl == null) {
                tpl = new Template(null, (Reader)new StringReader(tplText), this.freemarkerConfigurer);
                tplCaches.put(tplText, tpl);
            }
            tpl.process((Object)model, (Writer)result);
        }
        catch (Exception e) {
            LOG.error("Render template:[{}] error", (Object)tplText, (Object)e);
        }
        return result.toString().trim();
    }

    private Map<String, List<Facet>> extractFacets(QueryResponse rsp) {
        Facet facet;
        int allCount;
        Facet allFacet;
        LinkedHashMap<String, List<Facet>> fs = new LinkedHashMap<String, List<Facet>>();
        FacetField ff = rsp.getFacetField("businessId");
        if (ff != null) {
            ArrayList<Facet> bfs = new ArrayList<Facet>();
            allFacet = new Facet();
            allFacet.setName("\u6240\u6709\u4e1a\u52a1");
            bfs.add(allFacet);
            allCount = 0;
            for (FacetField.Count count : ff.getValues()) {
                Business business = this.categoryManager.getBusiness(count.getName());
                if (business == null) continue;
                facet = new Facet();
                facet.setName(business.getName());
                facet.setCode(count.getName());
                facet.setIcon(business.getIcon());
                facet.setCount((int)count.getCount());
                allCount += facet.getCount();
                bfs.add(facet);
            }
            allFacet.setCount(allCount);
            fs.put("bid", bfs);
        }
        if ((ff = rsp.getFacetField("categoryId")) != null) {
            ArrayList<Facet> cfs = new ArrayList<Facet>();
            allFacet = new Facet();
            allFacet.setName("\u6240\u6709\u5206\u7c7b");
            cfs.add(allFacet);
            allCount = 0;
            for (FacetField.Count count : ff.getValues()) {
                Category category = this.categoryManager.getCategory(count.getName());
                if (category == null || !StringUtils.isNotEmpty((String)category.getName())) continue;
                facet = new Facet();
                facet.setName(category.getName());
                facet.setCode(count.getName());
                facet.setIcon(category.getIcon());
                facet.setCount((int)count.getCount());
                allCount += facet.getCount();
                cfs.add(facet);
            }
            allFacet.setCount(allCount);
            fs.put("cid", cfs);
        }
        if ((ff = rsp.getFacetField("mimeType")) != null) {
            ArrayList<Facet> mfs = new ArrayList<Facet>();
            allFacet = new Facet();
            allFacet.setName("\u6240\u6709\u7c7b\u578b");
            mfs.add(allFacet);
            allCount = 0;
            Facet fileFact = null;
            for (FacetField.Count count : ff.getValues()) {
                MimeType mimeType = MimeType.values()[Integer.valueOf(count.getName())];
                if (mimeType != MimeType.TEXT) {
                    if (fileFact == null) {
                        fileFact = new Facet();
                        fileFact.setName(MimeType.BIN.getName());
                        String code = String.valueOf(MimeType.BIN.ordinal());
                        fileFact.setCode(code);
                        fileFact.setIcon(code);
                        mfs.add(fileFact);
                    }
                    fileFact.setCount(fileFact.getCount() + (int)count.getCount());
                    if (mimeType == MimeType.BIN) continue;
                }
                Facet facet2 = new Facet();
                facet2.setName(mimeType.getName());
                facet2.setCode(count.getName());
                facet2.setIcon(count.getName());
                facet2.setCount((int)count.getCount());
                allCount += facet2.getCount();
                mfs.add(facet2);
            }
            allFacet.setCount(allCount);
            fs.put("mt", mfs);
        }
        fs.put("date", DEFALUT_DATE_FACETS);
        fs.put("sort", DEFALUT_SORT_FACETS);
        return fs;
    }

    private Result extractResult(SolrDocument doc, Map<String, List<String>> hl) {
        Result result = new Result();
        result.setId(SearchManagerImpl.getStr((SolrDocument)doc, (String)"id"));
        String businessId = SearchManagerImpl.getStr((SolrDocument)doc, (String)"businessId");
        result.setBusinessId(businessId);
        Business business = this.categoryManager.getBusiness(businessId);
        if (business != null) {
            result.setBusinessName(business.getName());
        }
        String categoryId = SearchManagerImpl.getStr((SolrDocument)doc, (String)"categoryId");
        result.setCategoryId(categoryId);
        Category category = this.categoryManager.getCategory(categoryId);
        if (category != null) {
            result.setCategoryName(category.getName());
        }
        int mimeInt = (Integer)doc.getFieldValue("mimeType");
        result.setMimeType(MimeType.values()[mimeInt]);
        if (mimeInt > 0) {
            result.setIcon("file/" + this.mimeTypeService.getIcon(SearchManagerImpl.getStr((SolrDocument)doc, (String)"title")));
        }
        for (Map.Entry<String, List<String>> entry : hl.entrySet()) {
            String name = entry.getKey();
            List<String> list = entry.getValue();
            if (CollectionUtils.isEmpty(list)) continue;
            String value = list.get(0);
            if ("title".equals(name)) {
                result.setTitle(value);
                continue;
            }
            result.insertBody(value);
        }
        if (result.getTitle() == null) {
            result.setTitle(StringUtils.abbreviate((String)SearchManagerImpl.getStr((SolrDocument)doc, (String)"title"), (int)100));
        }
        if (result.getBody() == null) {
            result.setBody(StringUtils.abbreviate((String)SearchManagerImpl.getStr((SolrDocument)doc, (String)"body"), (int)this.bodyEllipsisCount));
        }
        result.setDate((Date)doc.getFieldValue("date"));
        result.setPublic(((Boolean)doc.getFieldValue("public")).booleanValue());
        Float score = (Float)doc.getFieldValue("score");
        if (score != null) {
            result.setScore((int)Math.rint(score.floatValue() * 100.0f));
        }
        for (Map.Entry entry : doc.entrySet()) {
            String name = (String)entry.getKey();
            int index = name.lastIndexOf("_");
            if (index <= -1) continue;
            result.addField(name.substring(0, index), (Serializable)entry.getValue());
        }
        return result;
    }

    public static String getStr(SolrDocument doc, String name) {
        return (String)doc.getFieldValue(name);
    }

    static {
        String[] names = new String[]{"\u65f6\u95f4\u4e0d\u9650", "\u8fc7\u53bb 1 \u5c0f\u65f6\u5185", "\u8fc7\u53bb 1 \u5929\u5185", "\u8fc7\u53bb 3 \u5929\u5185", "\u8fc7\u53bb 1 \u5468\u5185", "\u8fc7\u53bb 1 \u4e2a\u6708\u5185", "\u8fc7\u53bb 6 \u4e2a\u6708\u5185", "\u8fc7\u53bb 1 \u5e74\u5185"};
        String[] codes = new String[]{null, "-1HOURS", "-1DAY", "-3DAY", "-7DAY", "-1MONTH", "-6MONTH", "-1YEAR"};
        for (int i = 0; i < names.length; ++i) {
            Facet facet = new Facet();
            facet.setName(names[i]);
            facet.setCode(codes[i]);
            facet.setIcon("df" + i);
            DEFALUT_DATE_FACETS.add(facet);
        }
        String[] sortNames = new String[]{"\u6392\u5e8f\u65b9\u5f0f", "\u76f8\u5173\u5ea6", "\u65f6\u95f4", "\u4e1a\u52a1", "\u5206\u7c7b"};
        String[] sortCodes = new String[]{null, "score", "date", "businessId", "categoryId"};
        for (int i = 0; i < sortNames.length; ++i) {
            Facet facet = new Facet();
            facet.setName(sortNames[i]);
            facet.setCode(sortCodes[i]);
            facet.setIcon("sc" + i);
            DEFALUT_SORT_FACETS.add(facet);
        }
    }
}

