/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.search.service.impl;

import com.gtis.egov.search.service.CategoryIndexManager;
import com.gtis.egov.search.solr.TypeAdaptedInputDocument;
import com.gtis.search.Index;
import com.gtis.search.IndexManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalIndexManager
implements IndexManager {
    protected static final Logger LOG = LoggerFactory.getLogger(InternalIndexManager.class);
    private SolrServer solrServer;
    private CategoryIndexManager categoryManager;

    public void setSolrServer(SolrServer solrServer) {
        this.solrServer = solrServer;
    }

    public void setCategoryManager(CategoryIndexManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void update(Index ... indexes) {
        if (ArrayUtils.isEmpty((Object[])indexes)) {
            return;
        }
        ArrayList<TypeAdaptedInputDocument> inputs = new ArrayList<TypeAdaptedInputDocument>(indexes.length);
        for (Index index : indexes) {
            TypeAdaptedInputDocument input = new TypeAdaptedInputDocument();
            input.addField("id", (Object)index.getId());
            input.addField("type", (Object)0);
            input.addField("mimeType", (Object)index.getMimeType().ordinal());
            input.addField("businessId", (Object)index.getBusinessId());
            input.addField("categoryId", (Object)index.getCategoryId());
            if (index.getOwnerIds() != null) {
                for (String ownerId : index.getOwnerIds()) {
                    input.addField("ownerId", (Object)ownerId);
                }
            }
            input.addField("title", (Object)Index.trimTag((String)index.getTitle()));
            input.addField("titleAuto", (Object)StringUtils.substring((String)Index.trimTag((String)index.getTitle()), (int)0, (int)20));
            input.addField("body", (Object)Index.trimTag((String)index.getBody()));
            input.addField("date", (Object)index.getDate());
            input.addField("public", (Object)index.isPublic());
            for (Map.Entry entry : index.getSearchableFields().entrySet()) {
                input.addSearchableField((String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : index.getFields().entrySet()) {
                input.addUnsearchableField((String)entry.getKey(), entry.getValue());
            }
            inputs.add(input);
        }
        try {
            this.solrServer.add(inputs);
        }
        catch (Exception e) {
            LOG.error("Error to update index [" + Arrays.toString(indexes) + "],message:[" + e.getMessage() + "]");
        }
    }

    public void remove(String ... ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return;
        }
        try {
            this.solrServer.deleteById(Arrays.asList(ids));
        }
        catch (Exception e) {
            LOG.error("Error to remove index [id:" + Arrays.toString(ids) + "],message:[" + e.getMessage() + "]");
        }
    }

    public void reloadBusiness(String businessId) {
        this.categoryManager.reload(businessId);
    }
}

