/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.search.service.impl;

import com.gtis.egov.search.ex.SolrException;
import com.gtis.egov.search.model.RebuildTask;
import com.gtis.egov.search.service.CategoryIndexManager;
import com.gtis.search.Business;
import com.gtis.search.Category;
import com.gtis.search.IndexManager;
import com.gtis.search.IndexProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.caucho.HessianProxyFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryIndexManagerImpl
implements CategoryIndexManager {
    public static final int BATCH_SIZE = 100;
    private static final Logger LOG = LoggerFactory.getLogger(CategoryIndexManagerImpl.class);
    private Map<String, IndexProvider> indexProviderMap = new ConcurrentHashMap();
    private Map<String, Business> businessMap = new LinkedHashMap();
    private Map<String, Category> categoryMap = new HashMap();
    private Map<String, RebuildTask> taskMap = new ConcurrentHashMap();
    private IndexManager indexManager;
    private SolrServer solrServer;
    private List<IndexProvider> indexProviders = new ArrayList();
    private ExecutorService executor;
    private int batchSize = 100;

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void setSolrServer(SolrServer solrServer) {
        this.solrServer = solrServer;
    }

    public void setIndexProviders(List<IndexProvider> indexProviders) {
        this.indexProviders.addAll(indexProviders);
    }

    public void setIndexProviderUrls(String providerUrls) {
        for (String s : StringUtils.split((String)providerUrls, (String)",")) {
            if ((s = s.trim()).startsWith("#") || "".equals(s)) continue;
            HessianProxyFactoryBean proxy = new HessianProxyFactoryBean();
            proxy.setServiceInterface(IndexProvider.class);
            proxy.setServiceUrl(s);
            proxy.setHessian2(true);
            proxy.setReadTimeout(60000L);
            proxy.afterPropertiesSet();
            this.indexProviders.add((IndexProvider)proxy.getObject());
        }
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public List<Business> getBusinesses() {
        return new ArrayList<Business>(this.businessMap.values());
    }

    public List<Category> getCategories() {
        return new ArrayList<Category>(this.categoryMap.values());
    }

    public Map<String, Business> getBusinessMap() {
        return this.businessMap;
    }

    public Map<String, Category> getCategoryMap() {
        return this.categoryMap;
    }

    public Business getBusiness(String businessId) {
        return (Business)this.businessMap.get(businessId);
    }

    public Category getCategory(String categoryId) {
        return (Category)this.categoryMap.get(categoryId);
    }

    public int getIndexCount(String categoryId) {
        SolrQuery query = new SolrQuery();
        query.setRows(Integer.valueOf(1));
        query.setStart(Integer.valueOf(0));
        query.setQuery("*:*");
        query.addFilterQuery(new String[]{"categoryId:" + categoryId});
        try {
            QueryResponse rsp = this.solrServer.query((SolrParams)query);
            return (int)rsp.getResults().getNumFound();
        }
        catch (SolrServerException solrServerException) {
            return 0;
        }
    }

    public int getTotalCount(String categoryId) {
        String businessId = ((Category)this.categoryMap.get(categoryId)).getBusinessId();
        return this.getProvider(businessId).getTotalCount(categoryId);
    }

    public synchronized void reset() {
        try {
            this.solrServer.deleteByQuery("*:*");
            this.solrServer.commit();
        }
        catch (Exception e) {
            throw new SolrException(e);
        }
        this.reloadAll();
        this.rebuildAll();
    }

    public void commit() {
        try {
            this.solrServer.commit();
        }
        catch (Exception e) {
            LOG.warn("Commit error: " + e.getMessage());
        }
    }

    public void optimize() {
        try {
            this.solrServer.optimize();
        }
        catch (Exception e) {
            LOG.warn("Optimize error: " + e.getMessage());
        }
    }

    public synchronized void reloadAll() {
        this.indexProviderMap.clear();
        for (IndexProvider ip : this.indexProviders) {
            try {
                this.loadBusinesses(ip);
            }
            catch (SolrException solrException) {}
        }
        this.commit();
    }

    private void loadBusinesses(IndexProvider indexProvider) throws SolrException {
        try {
            List bizs = indexProvider.getBusinesses();
            if (CollectionUtils.isNotEmpty((Collection)bizs)) {
                for (Business biz : bizs) {
                    this.indexProviderMap.put(biz.getId(), indexProvider);
                    this.reloadBusiness(biz);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("IndexProvider is not available," + e.getMessage());
            throw new SolrException(e);
        }
    }

    public synchronized void reload(String businessId) {
        List bizs = this.getProvider(businessId).getBusinesses();
        if (CollectionUtils.isNotEmpty((Collection)bizs)) {
            for (Business biz : bizs) {
                this.reloadBusiness(biz);
            }
        }
        this.commit();
    }

    protected void reloadBusiness(Business biz) {
        LOG.info("Load business:{}", (Object)biz);
        Business oldBiz = (Business)this.businessMap.get(biz.getId());
        if (oldBiz != null) {
            if (biz.getLastModified() != null && biz.getLastModified().equals(oldBiz.getLastModified())) {
                return;
            }
            for (Category cat : oldBiz.getCategories()) {
                this.categoryMap.remove(cat.getId());
            }
        }
        this.businessMap.put(biz.getId(), biz);
        for (Category cat : biz.getCategories()) {
            this.categoryMap.put(cat.getId(), cat);
        }
        this.updateAclIndex(biz.getCategories());
    }

    protected void updateAclIndex(List<Category> categories) {
        ArrayList<SolrInputDocument> inputs = new ArrayList<SolrInputDocument>(categories.size());
        for (Category cat : categories) {
            SolrInputDocument input = new SolrInputDocument();
            input.addField("id", (Object)cat.getId());
            input.addField("type", (Object)1);
            if (cat.getRoleIds() != null) {
                for (String roleId : cat.getRoleIds()) {
                    input.addField("roleId", (Object)roleId);
                }
            }
            inputs.add(input);
        }
        try {
            this.solrServer.add(inputs);
        }
        catch (Exception e) {
            LOG.error("Error to update index [" + categories + "],message:[" + e.getMessage() + "]");
        }
    }

    public boolean isAlive(String businessId) {
        try {
            return this.getProvider(businessId).ping();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void rebuildAll() {
        for (String categoryId : this.categoryMap.keySet()) {
            this.rebuild(categoryId);
        }
    }

    public synchronized void rebuild(String categoryId) {
        if (this.taskMap.containsKey(categoryId)) {
            return;
        }
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        }
        RebuildTask task = new RebuildTask();
        Category cat = (Category)this.categoryMap.get(categoryId);
        if (cat == null) {
            return;
        }
        task.setBusinessId(cat.getBusinessId());
        task.setCategoryId(categoryId);
        Future<?> future = this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        task.setFuture(future);
        this.taskMap.put(categoryId, task);
    }

    public void rebuildSpellcheck() {
        SolrQuery query = new SolrQuery();
        query.set("spellcheck", true).set("spellcheck.dictionary", new String[]{"spellchecker"}).set("spellcheck.build", true);
        try {
            this.solrServer.query((SolrParams)query);
        }
        catch (SolrServerException e) {
            throw new SolrException((Exception)((Object)e));
        }
    }

    public void rebuildSuggest() {
        SolrQuery query = new SolrQuery();
        query.set("spellcheck", true).set("spellcheck.dictionary", new String[]{"suggest"}).set("spellcheck.build", true);
        try {
            this.solrServer.query((SolrParams)query);
        }
        catch (SolrServerException e) {
            throw new SolrException((Exception)((Object)e));
        }
    }

    public void stopRebuildTask(String categoryId) {
        RebuildTask task = (RebuildTask)this.taskMap.get(categoryId);
        if (task != null) {
            task.getFuture().cancel(true);
            this.taskMap.remove(categoryId);
        }
    }

    public List<RebuildTask> getRebuildTasks() {
        return new ArrayList<RebuildTask>(this.taskMap.values());
    }

    public synchronized void init() {
        ArrayList providers = new ArrayList(this.indexProviders);
        AtomicInteger futureRetryCount = new AtomicInteger();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleWithFixedDelay((Runnable)new /* Unavailable Anonymous Inner Class!! */, 5L, 30L, TimeUnit.SECONDS);
        this.rebuildSuggest();
    }

    protected IndexProvider getProvider(String businessId) {
        return (IndexProvider)this.indexProviderMap.get(businessId);
    }

    static /* synthetic */ SolrServer access$000(CategoryIndexManagerImpl x0) {
        return x0.solrServer;
    }

    static /* synthetic */ int access$100(CategoryIndexManagerImpl x0) {
        return x0.batchSize;
    }

    static /* synthetic */ IndexManager access$200(CategoryIndexManagerImpl x0) {
        return x0.indexManager;
    }

    static /* synthetic */ Logger access$300() {
        return LOG;
    }

    static /* synthetic */ Map access$400(CategoryIndexManagerImpl x0) {
        return x0.taskMap;
    }

    static /* synthetic */ void access$500(CategoryIndexManagerImpl x0, IndexProvider x1) throws SolrException {
        x0.loadBusinesses(x1);
    }
}

