/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.search.analyzer;

import com.gtis.egov.search.analyzer.TokenJoinTokenFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public final class TokenJoinTokenFilter
extends TokenFilter {
    private final int minSize;
    private final int maxSize;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private LinkedList<Token> tokens = new LinkedList();
    private int point;

    protected TokenJoinTokenFilter(TokenStream input, int minSize, int maxSize) {
        super(input);
        if (minSize < 2) {
            throw new IllegalArgumentException("minSize must be greater than zero");
        }
        if (minSize > maxSize) {
            throw new IllegalArgumentException("maxSize must not be greater than minSize");
        }
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public boolean incrementToken() throws IOException {
        if (this.point >= this.minSize) {
            if (this.point > this.maxSize) {
                this.tokens.removeFirst();
                this.point = this.tokens.size();
            }
            StringBuilder sb = new StringBuilder();
            ListIterator it = this.tokens.listIterator(this.tokens.size() - this.point);
            int beginPosition = -1;
            Token token = null;
            while (it.hasNext()) {
                token = (Token)it.next();
                sb.append(token.getBuff());
                if (beginPosition >= 0) continue;
                beginPosition = token.getStartOffset();
            }
            if (token != null) {
                this.clearAttributes();
                this.offsetAtt.setOffset(beginPosition, token.getEndOffset());
                this.termAtt.append(sb.toString());
                --this.point;
            }
        } else {
            if (!this.input.incrementToken()) {
                return false;
            }
            Token token = new Token(this, this.termAtt.toString(), this.offsetAtt.startOffset(), this.offsetAtt.endOffset());
            this.tokens.add(token);
            this.point = this.tokens.size();
        }
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.tokens.clear();
        this.point = 0;
    }
}

