/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.search.analyzer;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.wltea.analyzer.IKSegmentation;
import org.wltea.analyzer.Lexeme;

public final class IKTokenizer
extends Tokenizer {
    private IKSegmentation ikimplement;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private int finalOffset;

    public IKTokenizer(Reader in, boolean isMaxWordLength) {
        super(in);
        this.ikimplement = new IKSegmentation(in, isMaxWordLength);
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        Lexeme nextLexeme = this.ikimplement.next();
        if (nextLexeme != null) {
            this.termAtt.append(nextLexeme.getLexemeText());
            this.offsetAtt.setOffset(nextLexeme.getBeginPosition(), nextLexeme.getEndPosition());
            int inc = nextLexeme.getEndPosition() - this.finalOffset;
            if (inc > 0) {
                this.posIncrAtt.setPositionIncrement(inc);
            }
            this.finalOffset = nextLexeme.getEndPosition();
            return true;
        }
        return false;
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.ikimplement.reset(input);
    }

    public final void end() {
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }
}

