package com.gtis.report;

import com.runqian.report4.usermodel.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

import javax.sql.DataSource;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-5-10
 */
public class ReportDataSourceConfigurer implements BeanPostProcessor {
    protected static final Log LOG = LogFactory.getLog(ReportDataSourceConfigurer.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource) {
            if (LOG.isDebugEnabled())
                LOG.debug("add dataSource key [" + beanName + "],source [" + bean + "]");
            Context.getInitCtx().setConnectionFactory(beanName, new DataSourceIConnectionFactory((DataSource) bean));
        }
        return bean;
    }
}
