package com.gtis.report;

import com.runqian.base4.util.ArgumentTokenizer;
import org.apache.commons.io.IOUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.Properties;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-5-10
 */
public class PrintSetupServlet extends HttpServlet {
    private static final long serialVersionUID = 8244322277174553565L;
    private boolean saveDisplayScale = false;
    private Properties props = new Properties();

    @SuppressWarnings("unchecked")
    public void init() throws ServletException {
        saveDisplayScale = "yes".equalsIgnoreCase(getServletConfig().getInitParameter("saveDisplayScale"));
        File store = getStoreFile();
        if (store.exists()) {
            InputStream is = null;
            try {
                is = new FileInputStream(store);
                props.load(new InputStreamReader(is, "gbk"));
            } catch (Exception e) {
                throw new ServletException(e);
            } finally {
                IOUtils.closeQuietly(is);
            }
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            response.setContentType("text/html; charset=utf-8");
            writer = response.getWriter();
            String action = request.getParameter("action");
            String key = request.getParameter("key");
            if ("write".equalsIgnoreCase(action)) {
                String width = request.getParameter("width");
                String height = request.getParameter("height");
                String x = request.getParameter("x");
                String y = request.getParameter("y");
                String w = request.getParameter("w");
                String h = request.getParameter("h");
                String orientation = request.getParameter("orientation");
                String printerName = request.getParameter("printerName");
                String a = request.getParameter("a");
                String scale = request.getParameter("scale");
                String setup = width + "|" + height + "|" + x + "|" + y + "|" + w + "|" + h + "|" + orientation + "|" + printerName + "|" + a + "|" + scale;
                synchronized (this) {
                    props.setProperty(key, setup);
                    OutputStream os = null;
                    try {
                        os = new FileOutputStream(getStoreFile());
                        props.store(new OutputStreamWriter(os, "gbk"), null);
                    } finally {
                        IOUtils.closeQuietly(os);
                    }
                }
                writer.println("ok");
            } else {
                String setup = props.getProperty(key);
                if (setup != null) {
                    ArgumentTokenizer tokenizer = new ArgumentTokenizer(setup, '|');
                    writer.println("width=" + tokenizer.nextToken());
                    writer.println("height=" + tokenizer.nextToken());
                    writer.println("x=" + tokenizer.nextToken());
                    writer.println("y=" + tokenizer.nextToken());
                    writer.println("w=" + tokenizer.nextToken());
                    writer.println("h=" + tokenizer.nextToken());
                    writer.println("orientation=" + tokenizer.nextToken());
                    writer.println("printerName=" + tokenizer.nextToken());
                    if (tokenizer.hasMoreTokens()) {
                        writer.println("a=" + tokenizer.nextToken());
                    }
                    if (tokenizer.hasMoreTokens()) {
                        String x = tokenizer.nextToken();
                        if (saveDisplayScale) writer.println("scale=" + x);
                    }
                    writer.println("setup=yes");
                } else {
                    writer.println("setup=no");
                }
            }
            writer.flush();
        } catch (Exception ex) {
            if (writer != null) {
                writer.println("setup=no");
            }
        } finally {
            IOUtils.closeQuietly(writer);
        }
    }


    private static File getStoreFile() {
        return new File(CfgPath.getFile("print-config.properties"));
    }
}
