package com.gtis.report;

import com.runqian.base4.util.*;
import com.runqian.report4.remote.*;
import com.runqian.report4.remote.example.RemoteManager;
import com.runqian.report4.remote.example.UserInfo;
import com.runqian.report4.remote.example.UserManager;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.IOUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.*;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-5-10
 */
public class RemoteServerServlet extends HttpServlet {
    private static final long serialVersionUID = -2857228140485120665L;

    private String getNodeAttr(Node node, String attrName) {
        NamedNodeMap map = node.getAttributes();
        Node attr = map.getNamedItem(attrName);
        if (attr == null) return "";
        return attr.getNodeValue();
    }

    public void init() throws ServletException {
        RemoteManager rm = RemoteManager.getInstance();
        UserManager um = rm.getUserManager();
        try {
            Properties p = new Properties();
            InputStream is = null;
            try {
                is = new FileInputStream(getConfigFile("users.properties"));
                p.load(new InputStreamReader(is, "gbk"));
            } finally {
                IOUtils.closeQuietly(is);
            }

            Enumeration em = p.propertyNames();
            while (em.hasMoreElements()) {
                String userId = (String) em.nextElement();
                UserInfo info = new UserInfo();
                String tmp = p.getProperty(userId);
                ArgumentTokenizer at = new ArgumentTokenizer(tmp, ',');
                String name = at.nextToken();
                try {
                    name = new String(name.getBytes("iso8859-1"), "GBK");
                } catch (Exception ignored) {
                }
                info.userName = name;
                info.password = new MD5().getMD5ofStr(at.nextToken());
                info.privilege = Integer.parseInt(at.nextToken(), 2);
                info.alarmRowNum = Integer.parseInt(at.nextToken());
                Logger.info("系统初始化，开始读取会话变量");
                tmp = at.nextToken();
                SegmentSet set;
                if ((tmp != null) && (tmp.trim().length() > 0)) {
                    tmp = new String(tmp.getBytes("iso8859-1"), "GBK");
                    Logger.info("tmp=" + tmp);
                    set = new SegmentSet(tmp, ';');
                    info.sessionVariables = set.toMap();
                }
                Logger.info("系统初始化，开始读取语义权限");
                tmp = at.nextToken();
                if ((tmp != null) && (tmp.trim().length() > 0)) {
                    tmp = new String(tmp.getBytes("iso8859-1"), "GBK");
                    set = new SegmentSet(tmp, ';');
                    info.semanticsPrivilege = set.toMap();
                }
                um.addUser(userId, info);
            }
            rm.setSemanticsFile("semantics.xml");

            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            HashMap<String, DataSourceDefine> dsMap = new HashMap<String, DataSourceDefine>();
            InputStream iis = null;
            try {
                iis = new FileInputStream(getConfigFile("datasource.xml"));
                Document doc = docBuilder.parse(iis);
                putCfgDataSource(doc.getDocumentElement().getChildNodes(), dsMap);
            } finally {
                IOUtils.closeQuietly(iis);
            }
            putSpringDataSource(dsMap);
            dsMap.remove("_default");
            rm.dataSources = dsMap;
            Logger.info("远程设计服务器已启动......");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void putCfgDataSource(NodeList list, HashMap<String, DataSourceDefine> map) {
        for (int i = 0; i < list.getLength(); i++) {
            Node node = list.item(i);
            if (node.getNodeName().equals("ds")) {
                DataSourceDefine dsd = new DataSourceDefine();
                String name = getNodeAttr(node, "name");
                dsd.setName(name);
                String caseSense = getNodeAttr(node, "CaseSensitive");
                dsd.setCaseSentence("1".equals(caseSense));
                String ideCharset = getNodeAttr(node, "ideCharset");
                if (ideCharset.length() > 0) dsd.setClientCharset(ideCharset);
                String dbCharset = getNodeAttr(node, "dbCharset");
                if (dbCharset.length() > 0) dsd.setDBCharset(dbCharset);
                String dbtype = getNodeAttr(node, "dbType");
                dsd.setDBType(DBTypes.getDBType(dbtype));
                String driver = getNodeAttr(node, "driverClass");
                dsd.setDriver(driver);
                dsd.setDSType(DataSourceDefine.TYPE_RELATIONAL);
                String transCharset = getNodeAttr(node, "transCharset");
                dsd.setNeedTranContent("1".equals(transCharset));
                String transSQLCharset = getNodeAttr(node, "transSQLCharset");
                dsd.setNeedTranSentence("1".equals(transSQLCharset));
                String pwd = getNodeAttr(node, "password");
                dsd.setPassword(pwd);
                dsd.setUrl(getNodeAttr(node, "url"));
                dsd.setUser(getNodeAttr(node, "user"));
                String useSchema = getNodeAttr(node, "useSchema");
                dsd.setUseSchema("1".equals(useSchema));
                map.put(name, dsd);
            }
        }
    }

    private void putSpringDataSource(HashMap<String, DataSourceDefine> map) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(getServletContext());
        wac.getBeansOfType(BasicDataSource.class);
        for (Map.Entry<String, BasicDataSource> entry : wac.getBeansOfType(BasicDataSource.class).entrySet()) {
            String name = entry.getKey();
            DataSourceDefine dsd = map.get(name);
            if (dsd == null) {
                dsd = new DataSourceDefine();
                dsd.setName(entry.getKey());
                DataSourceDefine df = map.get("_default");
                dsd.setCaseSentence(df.isCaseSentence());
                dsd.setNeedTranContent(df.getNeedTranContent());
                dsd.setNeedTranSentence(df.getNeedTranSentence());
                dsd.setUseSchema(df.isUseSchema());
                dsd.setClientCharset(df.getClientCharset());
                dsd.setDBCharset(df.getDBCharset());
                dsd.setDSType(df.getDSType());
                map.put(name, dsd);
            }
            BasicDataSource bds = entry.getValue();
            dsd.setDBType(getDBType(bds.getDriverClassName().toLowerCase()));
            dsd.setDriver(bds.getDriverClassName());
            dsd.setUrl(bds.getUrl());
            dsd.setUser(bds.getUsername());
            dsd.setPassword(bds.getPassword());
        }
    }

    private static final String[] DB_NAMES = {"unknown", "oracle", "sqlsvr", "sybase", "sqlany", "infmix", "foxpro", "access", "foxbas", "db2", "mysql", "kingbase", "derby"};

    private int getDBType(String className) {
        for (int i = 0; i < DB_NAMES.length; i++) {
            if (className.contains(DB_NAMES[i])) {
                return i;
            }
        }
        return 0;
    }

    public void service(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = request.getInputStream();
            ObjectInputStream ois = new ObjectInputStream(is);
            Request req = (Request) ois.readObject();
            RemoteManager rm = RemoteManager.getInstance();
            Response res = null;
            if ((req instanceof LoginRequest)) {
                res = rm.doLogin((LoginRequest) req);
            } else if ((req instanceof LogoutRequest)) {
                res = rm.doLogout((LogoutRequest) req);
            } else if ((req instanceof OpenRequest)) {
                OpenRequest openReq = (OpenRequest) req;
                openReq.fileName = openReq.fileType == Const.FILE_SEMANTICS ? getConfigFile(openReq.fileName) : getRaqFile(openReq.fileName);
                res = rm.doOpen(openReq);
            } else if ((req instanceof SaveRequest)) {
                SaveRequest saveReq = (SaveRequest) req;
                saveReq.fileName = saveReq.fileType == Const.FILE_SEMANTICS ? getConfigFile(saveReq.fileName) : getRaqFile(saveReq.fileName);
                res = rm.doSave(saveReq);
            }
            os = response.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(res);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (is != null) is.close();
            if (os != null) os.close();
        }
    }

    private String getConfigFile(String name) {
        return CfgPath.getFile("remote", name);
    }

    private String getRaqFile(String name) {
        return CfgPath.getFile("files", name);
    }
}