package com.gtis.portal.web.interceptor;

import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.service.LogService;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * .
 * <p/>任务所有动作拦截器
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/23
 */
@Aspect
@Component
@Deprecated
public class TaskActionInterceptor {
    private final Logger log = LoggerFactory.getLogger(TaskActionInterceptor.class);
    @Autowired
    LogService logService;

    /**
     * 删除任务执行成功后执行，删除日志
     *
     * @param wiid
     * @param taskid
     * @param reason
     */
    @After("execution (* com.gtis.portal.service.TaskActionService.delTask(..)) && args(wiid,taskid,userid,reason,pfWorkFlowInstanceVo,request)")
    public void saveDelTaskLog(String wiid, String taskid, String userid, String reason, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
//        logService.saveDelTaskLog(wiid, taskid, userid, reason, pfWorkFlowInstanceVo, request);
    }

    /**
     * 已办任务取回任务执行成功后执行，取回日志
     *
     * @param wiid
     * @param taskid
     * @param userid
     * @param pfWorkFlowInstanceVo
     * @param request
     */
    @After("execution (* com.gtis.portal.service.TaskActionService.retrieveTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void saveRetrieveTaskLog(String wiid,String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
//        logService.saveRetrieveTaskLog(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
    }

    /**
     * 已办任务、办理界面执行转发前验证任务，验证任务执行成功后执行，转发日志
     *
     * @param wiid
     * @param taskid
     * @param userid
     * @param pfWorkFlowInstanceVo
     * @param request
     */
    @After("execution (* com.gtis.portal.service.TaskActionService.turnTaskByXml(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void saveTurnTaskLog(String wiid,String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
//        logService.saveTurnTaskLog(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
    }

    /**
     * 已办任务、办理界面执行退回任务，执行成功后执行，退回日志
     *
     * @param wiid
     * @param taskid
     * @param userid
     * @param pfWorkFlowInstanceVo
     * @param request
     */
    @After("execution (* com.gtis.portal.service.TaskActionService.turnBackTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void saveTurnBackTaskLog(String wiid,String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
//        logService.saveTurnBackTaskLog(wiid, taskid, userid, "",pfWorkFlowInstanceVo, request);
    }

    /**
     * 已办任务、办理界面执行办结任务，执行成功后执行，办结日志
     *
     * @param wiid
     * @param taskid
     * @param userid
     * @param pfWorkFlowInstanceVo
     * @param request
     */
    @After("execution (* com.gtis.portal.service.TaskActionService.endTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void saveEndTaskTaskLog(String wiid,String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
//        logService.saveEndTaskLog(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
    }
}
