package com.gtis.portal.web.config;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Maps;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.entity.PfBusiness;
import com.gtis.portal.entity.PfWorkflowDefinition;
import com.gtis.portal.entity.PfWorkflowInstance;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.*;
import com.gtis.portal.util.MatrixToImageWriter;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: jibo
 * Date: 14-4-14
 * Time: 上午10:50
 * To change this template use File | Settings | File Templates.
 */
@Controller
@RequestMapping("config/workflow")
public class WorkflowController extends BaseController {
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfResourceGroupService groupService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    PfWorkflowDefinitionService workflowDefinitionService;
    @Autowired
    PfWorkflowInstanceService workflowInstanceService;
    @Autowired
    PfBusinessService businessService;
    @Autowired
    SysCalendarService sysCalendarService;

    @Resource
    @Qualifier("boolListNumber")
    List<PublicVo> boolListNumber;
    @Resource
    @Qualifier("priorityList")
    List<PublicVo> priorityList;
    @Resource
    @Qualifier("databaseList")
    List<PublicVo> databaseList;

    @RequestMapping("")
    public String manage(Model model) {
        model.addAttribute("boolListNumber",boolListNumber);
        model.addAttribute("priorityList",priorityList);
        model.addAttribute("databaseList",databaseList);
        return "/config/workflow/manage";
    }

    @RequestMapping("json")
    @ResponseBody
    public Object resourcejson(Model model) {
        if (SessionUtil.getCurrentUser().isAdmin()){
            //组织菜单树，类似构建平台
            Ztree ztree = workflowDefinitionService.getAllWfdTree();
            return ztree;
        }
        return null;
    }

    @RequestMapping("info")
    @ResponseBody
    public PfWorkflowDefinition getWorkflowDefinition(@RequestParam(value = "keyId", required = false) String keyId) {
        PfWorkflowDefinition wfd = workflowDefinitionService.findById(keyId);
        return wfd == null ? new PfWorkflowDefinition() : wfd;
    }

    @RequestMapping("image")
    @ResponseBody
    public void image(@RequestParam(value = "keyId", required = false) String keyId, HttpServletResponse response) {
        PfWorkflowDefinition wfd = workflowDefinitionService.findById(keyId);
        if (wfd != null && wfd.getWorkflowImage() != null){
            Blob blob = wfd.getWorkflowImage();
            InputStream in = null;
            try {
                in = blob.getBinaryStream();
                OutputStream out = response.getOutputStream();
                byte[] data = new byte[(int)blob.length()];
                int i = 0;
                while ((i=in.read(data))!=-1){
                    out.write(data);
                }
                out.close();
                in.close();
            }catch (Exception e){
                e.printStackTrace();
            }
        }
    }

    /*@RequestMapping("imageByProid")
    @ResponseBody
    public void imageByProid(@RequestParam(value = "proId", required = false) String proId, HttpServletResponse response) {
        PfWorkflowInstance wfi = workflowInstanceService.findById(proId);
        if (wfi != null && wfi.getWorkflowImage() != null){
            Blob blob = wfi.getWorkflowImage();
            InputStream in = null;
            try {
                in = blob.getBinaryStream();
                OutputStream out = response.getOutputStream();
                byte[] data = new byte[(int)blob.length()];
                int i = 0;
                while ((i=in.read(data))!=-1){
                    out.write(data);
                }
                out.close();
                in.close();
            }catch (Exception e){
                e.printStackTrace();
            }
        }
    }*/

    @RequestMapping("save")
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute("wfd") PfWorkflowDefinition wfd, Model model){
        if (RequestUtils.checkIsAdmin()){
            if (StringUtils.isNotBlank(wfd.getWorkflowDefinitionId())){
                workflowDefinitionService.update(wfd);
            }
            wfd = workflowDefinitionService.findById(wfd.getWorkflowDefinitionId());
            Map<String, Object> result = new HashMap<String, Object>();
            result.put("success", true);
            result.put("msg", "操作成功！");
            result.put("wfd", wfd);
            return result;
        }else{
            return handlerErrorJson(exceptionService.getExceptionMsg("9001"));
        }
    }

    @RequestMapping("infoBs")
    @ResponseBody
    public PfBusiness getBusiness(@RequestParam(value = "keyId", required = false) String keyId) {
        PfBusiness bs = businessService.findById(keyId);
        return bs == null ? new PfBusiness() : bs;
    }

    @RequestMapping("saveBs")
    @ResponseBody
    public Object saveBusiness(HttpServletRequest req, PfBusiness business, Model model){
        if (RequestUtils.checkIsAdmin()){
            if (StringUtils.isNotBlank(business.getBusinessId())){
                businessService.update(business);
            }
            business = businessService.findById(business.getBusinessId());
            Map<String, Object> result = new HashMap<String, Object>();
            result.put("success", true);
            result.put("msg", "操作成功！");
            result.put("business", business);
            return result;
        }else{
            return handlerErrorJson(exceptionService.getExceptionMsg("9001"));
        }
    }

    /**
     * 根据任务id，获取工作流定义信息
     * @param taskId
     * @return
     */
    @RequestMapping("getWDByTaskId")
    @ResponseBody
    public Object getWDByTaskId(@RequestParam String taskId){
        Map workflowDefinitionMap = Maps.newHashMap();
        PfWorkflowDefinition wd = workflowDefinitionService.getPfWorkflowDefinitionByTaskId(taskId);
        PfWorkFlowDefineVo pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wd.getWorkflowDefinitionId());
        if (pfWorkFlowDefineVo != null){
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(pfWorkFlowDefineVo);
            //直接创建工作流任务，不用弹出新建页面
            String directCreateTask = xmlDao.getExtendedAttribute("DirectCreateTask")+"";
            workflowDefinitionMap.put("directCreateTask",directCreateTask);
            //该属性表示，新建任务后弹出的待办任务办理界面，关闭时是否提示用户是否保存该流程，选择取消则删掉流程，该配置一般配合上面的直接创建任务的功能一起使用
            //因为如果直接创建，会导致冗余任务，因此通过这个参数提示用户，是否确认保留这个任务
            workflowDefinitionMap.put("createTaskAlertSave",xmlDao.getExtendedAttribute("CreateTaskAlertSave")+"");
        }
        workflowDefinitionMap.put("workflowDefine",pfWorkFlowDefineVo);
        return workflowDefinitionMap;
    }

    /**
     * 根据任务id，获取工作流定义信息
     * @param proid
     * @return
     */
    @RequestMapping("getQRCode")
    @ResponseBody
    public void getQRCode(@RequestParam(value = "proid", required = false)String proid, HttpServletResponse response){
        String remark = "";
        Map workflowDefinitionMap = Maps.newHashMap();
        if (StringUtils.isNotBlank(proid)){
            try {
                PfWorkFlowInstanceVo workflowInstance = sysWorkFlowInstanceService.getWorkflowInstance(proid);
                if (workflowInstance != null && StringUtils.isNotBlank(workflowInstance.getRemark())){
                    WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(workflowInstance);
                    //使用备注字段存储二维码信息
                    String useRemarkSaveQRCode = xmlDao.getExtendedAttribute("UseRemarkSaveQRCode")+"";
                    if (StringUtils.equalsIgnoreCase("true",useRemarkSaveQRCode)){
                        remark = workflowInstance.getRemark();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        try {
            if (StringUtils.isNotBlank(remark)){
                int width = 120;
                int height = 120;
                //二维码的图片格式
                String format = "jpg";
                Hashtable hints = new Hashtable();
                //内容所使用编码
                hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
                BitMatrix bitMatrix = new MultiFormatWriter().encode(remark, BarcodeFormat.QR_CODE, width, height, hints);
                //生成二维码
                MatrixToImageWriter.writeToResponse(bitMatrix, format, response);
            }else {
                //空白图片
                String imgPath = AppConfig.getPlatFormUrl()+"/pf/images/blank.gif";
                imgPath = RequestUtils.initOptProperties(imgPath);
                MatrixToImageWriter.writeToResponse(imgPath, "gif", response);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 根据工作流实例id获取工作流定义名称
     * @param proid
     * @return
     */
    @RequestMapping(value = "workflowDefineName",produces="text/html;charset=UTF-8")
    @ResponseBody
    public String getWorkflowDefineName(@RequestParam String proid){
        String workflownName = "";
        Map workflowDefinitionMap = Maps.newHashMap();
        PfWorkFlowInstanceVo workFlowInstanceVo = new PfWorkFlowInstanceVo();
        if (StringUtils.isNotBlank(proid)){
            workFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(proid);
            if (workFlowInstanceVo != null){
                PfWorkFlowDefineVo workFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
                if (workFlowDefineVo != null){
                    workflownName = workFlowDefineVo.getWorkflowName();
                }
            }
        }
        return workflownName;
    }

    @RequestMapping("updateWFIOvertime")
    @ResponseBody
    public Object updateWorkflowInstanceOvertime(String proid, String beginDate, String timeLimit){
        if (StringUtils.isNotBlank(proid)){
            PfWorkflowInstance workflowInstance = workflowInstanceService.findById(proid);
            if (proid != null){
                if (StringUtils.isNotBlank(timeLimit)){
                    workflowInstance.setTimeLimit(timeLimit);
                }
                Date beginAt = new Date();
                if (StringUtils.isNotBlank(beginDate)){
                    beginAt = CalendarUtil.formatDate(beginDate);
                }
                Date overTime = sysCalendarService.getOverTime(beginAt,timeLimit);
                workflowInstance.setOverTime(overTime);

                workflowInstanceService.update(workflowInstance);
            }
        }
        return null;
    }
}
