package com.gtis.portal.web.config;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.model.PageImpl;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.portal.entity.BdcCqtxjl;
import com.gtis.portal.entity.BdcZdpjjl;
import com.gtis.portal.service.server.OverTimeRemindService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liangxichang@gtmap.cn">liangxichang</a>
 * @version 1.0 , 2019/11/7
 * @description 超期提醒配置
 **/
@Controller
@RequestMapping("/overTimeRemind")
public class OverTimeRemindController {
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    OverTimeRemindService overTimeRemindService;
    @Autowired
    SysActivityService activityService;

    @RequestMapping("")
    public String overTimeRemind(Model model){
        List<PfWorkFlowDefineVo> pfWorkFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();

        if(CollectionUtils.isNotEmpty(pfWorkFlowDefineVoList)) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo = new PfWorkFlowDefineVo();
            pfWorkFlowDefineVo.setWorkflowName("全部");
            pfWorkFlowDefineVo.setWorkflowDefinitionId("");
            pfWorkFlowDefineVoList.add(0,pfWorkFlowDefineVo);
        }

        model.addAttribute("pfWorkFlowDefineVoList",pfWorkFlowDefineVoList);

        return "config/overtime-remind";
    }


    @RequestMapping("/getOverTimeRemindPagesJson")
    @ResponseBody
    public Object getOverTimeRemindPagesJson(Pageable pageable, String wdid, String jdmc, @RequestParam(value = "number", required = false) String number, @RequestParam(value = "currentPage", required = false) String currentPage){
        int pageNumber = pageable.getPageNumber();
        if (currentPage != null)
            pageNumber = Integer.parseInt(currentPage) - 1;
        QPageRequest pageable1 = new QPageRequest(pageNumber, 10);

        org.springframework.data.domain.Page<BdcCqtxjl> bdcCqtxjlPage = overTimeRemindService.queryBdcCqtxjlList( wdid, jdmc,  pageable1);
        Page<BdcCqtxjl> bdcCqtxjlPage1 = null;
        if (bdcCqtxjlPage != null) {
            bdcCqtxjlPage1 = new PageImpl(bdcCqtxjlPage.getContent(), pageNumber + 1, Integer.parseInt(bdcCqtxjlPage.getTotalElements() + ""), 10);
        }
        return bdcCqtxjlPage1;
    }

    @RequestMapping("/save")
    @ResponseBody
    public Object save(BdcCqtxjl bdcCqtxjl) {
        String msg = "true";
        try {
            BdcCqtxjl bdcCqtxjl1 = overTimeRemindService.getBdcCqtxjlByWdidAndJdid(bdcCqtxjl.getGzlid(), bdcCqtxjl.getJdid());
            if (bdcCqtxjl1 != null) {
                msg = "数据库存在该类型数据！";
                return URLEncoder.encode(msg);
            }
            overTimeRemindService.save(bdcCqtxjl);
        } catch (Exception e) {
            msg = "保存不成功！";
        }

        return URLEncoder.encode(msg);
    }

    @ResponseBody
    @RequestMapping("/del")
    public Object del(String ids){
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        overTimeRemindService.delBdcCqtxjl(id);
                } else
                    overTimeRemindService.delBdcCqtxjl(ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @RequestMapping("/getOverTimeRemindConfirm")
    @ResponseBody
    public Object getOverTimeRemindConfirm(@RequestParam(value = "gzlid") String gzlid,@RequestParam(value="gzlmc") String gzlmc,@RequestParam(value = "activityId") String activityId,@RequestParam(value = "jdmc") String jdmc){
        String jdid = null;
        Map<String,Object> resultMap = new HashMap<String, Object>();
        boolean msg = false;
        if(StringUtils.isBlank(gzlid)){
            List<PfWorkFlowDefineVo> workFlowDefineList = sysWorkFlowDefineService.getWorkFlowDefineList();
            if(StringUtils.isNotBlank(gzlmc)){
                for (PfWorkFlowDefineVo pfWorkFlowDefineVo : workFlowDefineList) {
                    if(gzlmc.equals(pfWorkFlowDefineVo.getWorkflowName())){
                        gzlid = pfWorkFlowDefineVo.getWorkflowDefinitionId();
                        break;
                    }
                }
            }
        }

        if(StringUtils.isNotBlank(activityId)){
            PfActivityVo activity = activityService.getActivityById(activityId);
            jdid = activity.getActivityDefinitionId();
        }
        BdcCqtxjl bdcCqtxjl = overTimeRemindService.getBdcCqtxjlByWdidAndJdid(gzlid, jdid);
        if(bdcCqtxjl !=null){
            msg =true;
        }
        resultMap.put("msg",msg);
        return resultMap;
    }

}
