package com.gtis.portal.web;


import com.google.common.collect.Maps;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfUser;

import com.gtis.portal.util.QueryCondition;

import org.apache.commons.collections.CollectionUtils;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Controller
public class UserCacertController extends BaseController {
    @Resource(name = "baseDaoImpl")
    BaseDao baseDao;

    @ResponseBody
    @RequestMapping("userCacert")
    public Object index(String loginName) {
        String cert = "";
        String iscert = "";
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("loginName", QueryCondition.EQ, loginName);

        queryConditions.add(queryCondition);
        List<PfUser> pfUserList = baseDao.get(PfUser.class, queryConditions);
        if (CollectionUtils.isNotEmpty(pfUserList)) {
            cert = pfUserList.get(0).getCacert();
            iscert = pfUserList.get(0).getIsCacert();
        }
        Map reminderMap = Maps.newHashMap();
        reminderMap.put("cert", cert);
        reminderMap.put("iscert", iscert);
        return reminderMap;
    }

}