package com.gtis.portal.web;

import com.google.common.collect.Maps;
import com.gtis.portal.entity.BdcSfxx;
import com.gtis.portal.service.server.BdcSfxxService;
import com.gtis.portal.service.server.BdcXmService;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Statistics;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2017/7/25
 * @description 登记信息获取
 */
@Controller
@RequestMapping("/queryDjxx")
public class QueryDjxxController extends BaseController{
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcSfxxService bdcSfxxService;

    /**
     * 获取登记信息（标准）
     *
     * @param wiids
     * @return
     */
    @RequestMapping("")
    @ResponseBody
    public Object getDjxxStd(String wiids) {
        Map map = null;
        List<Map> mapList = new ArrayList<Map>();
        String sfzt = "未缴费";
        if (StringUtils.isNotBlank(wiids)) {
            if (StringUtils.isNotBlank(wiids)) {
                for (String wiid : wiids.split(",")) {
                    List<com.gtis.portal.entity.BdcXm> bdcXmList = bdcXmService.getBdcXmList(wiid);
                    map = Maps.newHashMap();
                    if (CollectionUtils.isNotEmpty(bdcXmList)) {
                        String proid = bdcXmList.get(0).getProid();
                        if (StringUtils.isNotBlank(proid)) {
                            List<BdcSfxx> bdcSfxxList = bdcSfxxService.getBdcSfxxList(proid);
                            if (CollectionUtils.isNotEmpty(bdcSfxxList)) {
                                String sfztdm = bdcSfxxList.get(0).getSfzt();
                                if (StringUtils.equals(sfztdm, "1")) {
                                    sfzt = "已缴费";
                                } else {
                                    sfzt = "未缴费";
                                }
                            }
                        }

                    }
                    map.put("wiid", wiid);
                    map.put("SFZT", sfzt);
                    mapList.add(map);
                }
            }

        }

        return mapList;
    }
}
