package com.gtis.portal.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.entity.PfLog;
import com.gtis.portal.entity.PfNews;
import com.gtis.portal.service.LogService;
import com.gtis.portal.service.PfLogService;
import com.gtis.portal.service.PfNewsService;
import com.gtis.portal.util.Constants;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 政务任务
 *
 * @author <a href="mailto:shenfei@gtmap.cn">zx</a>
 * @version 1.0, 2019/5/31
 */
@Controller
@RequestMapping("/oaTask")
public class OaTaskController {
    @Autowired
    SysUserService sysUserService;
    @Autowired
    RestTemplate restTemplate;
    /**
     * @param request
     * @author : <a href="mailto:shenfei@gtmap.cn">zx</a>
     * @date : 2019-06-04 15:18
     * @return:java.lang.Object
     * @Description : 获取政务任务数量
     */
    @ResponseBody
    @RequestMapping("/count")
    public Object count( HttpServletRequest request) {
        String oaCountUrl = AppConfig.getProperty("oa.task.count.href");
        PfUserVo pfUserVo = sysUserService.getUserVo(SessionUtil.getCurrentUserId());
        if (StringUtils.isNotBlank(oaCountUrl))
            oaCountUrl = StringUtils.substring(oaCountUrl, 0, oaCountUrl.indexOf("${")) + pfUserVo.getLoginName() + StringUtils.substring(oaCountUrl, oaCountUrl.indexOf("}") + 1, oaCountUrl.length());
        HashMap map= Maps.newHashMap();
        try {
            HashMap param = new HashMap();
            Object obj = restTemplate.getForObject(oaCountUrl, String.class, param);
            if(obj!=null){
//            String obj="{\"taskcategory\":19,\"taskover\":8,\"task\":11736,\"taskoffsite\":50,\"tasksite\":5078,\"taskcq\":508}";
                map= JSON.parseObject(obj.toString(), HashMap.class);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

}
