package com.gtis.portal.web;

import cn.gtmap.estateplat.utils.ClientInfoUtil;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.entity.BdcXtLog;
import com.gtis.portal.service.server.impl.AuditLogServiceImpl;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.util.Date;

/**
 * .
 * <p/>登录记录日志
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
 * @version 1.0, 2017/1/4
 */
@Controller
@RequestMapping("/loginLog")
public class LoginLogController {
    @Autowired
    AuditLogServiceImpl auditLogService;
    @Autowired
    SysUserService sysUserService;

    @RequestMapping("")
    @ResponseBody
    public Object saveLog(HttpServletRequest request,@RequestParam(value = "ip", required = false) String ip, @RequestParam(value = "userId", required = false) String userId,
                          @RequestParam(value = "userName", required = false) String userName,@RequestParam(value = "controller", required = false) String controller,
                          @RequestParam(value = "content", required = false) String content) {
        String msg = "ok";
        String mac = "";
        try {
            if(StringUtils.isNotBlank(userName))
                userName= URLDecoder.decode(userName,"UTF-8");
            if(StringUtils.isNotBlank(content))
                content= URLDecoder.decode(content,"UTF-8");
            if(StringUtils.isNotBlank(controller))
                controller= URLDecoder.decode(controller,"UTF-8");
            try {
                ip = ClientInfoUtil.getIpAddr(request);

            } catch (Exception e) {
            }

            BdcXtLog bdcXtLog = new BdcXtLog();
            bdcXtLog.setUserid(userId);
            bdcXtLog.setUsername(userName);
            bdcXtLog.setIp(ip);
            bdcXtLog.setMac(mac);
            bdcXtLog.setComputername(ip);
            bdcXtLog.setController(controller);
            bdcXtLog.setCzrq(new Date());
            bdcXtLog.setParmjson(content);
            auditLogService.saveAuditLog(bdcXtLog);
        } catch (Exception e) {
            msg = "error";
        }

        return msg;
    }
    @RequestMapping("logoutLog")
    @ResponseBody
    public Object logoutLog(HttpServletRequest request,@RequestParam(value = "userId", required = false) String userId) {
        String msg = "ok";
        String ip = "";
        try {

            try {
                ip = ClientInfoUtil.getIpAddr(request);

            } catch (Exception e) {
            }

            BdcXtLog bdcXtLog = new BdcXtLog();
            bdcXtLog.setUserid(userId);
            bdcXtLog.setUsername(sysUserService.getUserVo(userId).getUserName());
            bdcXtLog.setIp(ip);
            bdcXtLog.setComputername(ip);
            bdcXtLog.setController("登出");
            bdcXtLog.setCzrq(new Date());
            bdcXtLog.setParmjson(bdcXtLog.getUsername()+"用户登出");
            auditLogService.saveAuditLog(bdcXtLog);
        } catch (Exception e) {
            msg = "error";
        }

        return msg;
    }

}
