package com.gtis.portal.web;

import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.service.impl.TaskPerformerMinWorkloadFilterServiceImpl;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;


/**
 * @author <a href="mailto:liangxichangg@gtmap.cn">lxc</a>
 * @version 1.0 , 2019/11/15
 * @description
 **/
@Controller
@RequestMapping("/createWorkFlowInstance")
public class CreateWorkFlowInstanceController {

    @Resource( name="taskPerformerMinWorkloadFilterService")
    TaskPerformerMinWorkloadFilterServiceImpl taskPerformerFilterService;

    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;

    /**
     *创建并自动全局派件实现
     * @param wdid 工作流定义id
     * @param wiid 工作流实例id
     * @param userId 当前用户id
     * @return workFlowInfo
     */
    @RequestMapping(value = "/autoTurnAllTask")
    @ResponseBody
    public Object createWorkFlowInstanceAndZdpjAll(@RequestParam(value = "wdid") String wdid, @RequestParam(value = "wiid") String wiid, @RequestParam(value ="userId") String userId) throws Exception {
        PfWorkFlowInstanceVo workFlowInstanceVo = new PfWorkFlowInstanceVo();
        WorkFlowInfo workFlowInfo =new WorkFlowInfo();
        if(StringUtils.isNotBlank(wiid)){
            workFlowInstanceVo.setWorkflowIntanceId(wiid);
            if(StringUtils.isNotBlank(wdid)){
                workFlowInstanceVo.setWorkflowDefinitionId(wdid);
                if(StringUtils.isBlank(userId)){
                    userId = SessionUtil.getCurrentUserId();
                }
                if (StringUtils.isNotBlank(userId)){
                    workFlowInfo = taskPerformerFilterService.createWorkFlowInstanceAndZdpjAll(workFlowInstanceVo, userId);
                }
            }
        }
        return workFlowInfo;
    }
}
