package com.gtis.portal.web;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.utils.ClientInfoUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.entity.BdcXtLog;
import com.gtis.portal.service.TaskActionService;
import com.gtis.portal.service.server.impl.AuditLogServiceImpl;
import com.gtis.portal.util.Constants;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * .
 * <p/>批量办结实现类
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
 * @version 1.0, 2017/1/4
 */
@Controller
@RequestMapping("/batchFinishTask")
public class BatchFinishTaskController extends BaseController{
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysActivityService sysActivityService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    TaskActionService taskActionService;
    /**
     * @param taskId 上传附件
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String createAllFileFolder(Model model, @RequestParam(value = "taskId", required = false) String taskId) {
        String fileCenterUrl = "fcm";
        String project_fileId = null;
        fileCenterUrl = fileCenterUrl + AppConfig.getFileCenterUrl().substring(4);
        List<String> proidList = null;
        Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF, true);
        PfTaskVo pfTaskVo=sysTaskService.getTask(taskId);
        PfActivityVo pfActivityVo=sysActivityService.getActivityById(pfTaskVo.getActivityId());
        PfWorkFlowInstanceVo workFlowInstanceVo = sysWorkFlowInstanceService
                .getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
        if (workFlowInstanceVo != null && StringUtils.isNotBlank(workFlowInstanceVo.getProId())) {
            proidList = new ArrayList<String>();
            proidList.add(workFlowInstanceVo.getProId());
        }
        if (CollectionUtils.isNotEmpty(proidList)) {
            try {
                for (String proid : proidList) {
                    Node node = nodeService.getNode(space.getId(), proid, true);
                    String nodeName=AppConfig.getProperty("batchUploadFile.name");
                    Node uploadNode = nodeService.getNode(node.getId(), nodeName, true);
                    if (uploadNode != null && StringUtils.isBlank(project_fileId))
                        project_fileId = uploadNode.getId().toString();
                    else
                        project_fileId = project_fileId + "," + uploadNode.getId().toString();
                }

            } catch (Exception ex) {

            }
        }
        if (workFlowInstanceVo == null)
            workFlowInstanceVo = new PfWorkFlowInstanceVo();
        model.addAttribute("fileCenterUrl", fileCenterUrl);
        model.addAttribute("nodeId", project_fileId);
        model.addAttribute("username",SessionUtil.getCurrentUser().getUsername());
        model.addAttribute("userid",SessionUtil.getCurrentUser().getId());
        model.addAttribute("uploadTaskId",taskId);
        model.addAttribute("workFlowInstanceVo", workFlowInstanceVo);
        return "task-upload-file";
    }

    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 批量办结流程 batchFinishTask
     */
    @RequestMapping("batchFinishTask")
    @ResponseBody
    public Object batchFinishTask(HttpServletRequest request, @RequestParam(value = "uploadTaskId", required = false) String uploadTaskId, @RequestParam(value = "uploadNodeId", required = false) String uploadNodeId, @RequestParam(value = "taskIds", required = false) String taskIds, @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskIds)) {
                //办结
                for(String taskid:taskIds.split(",")) {
                    PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                    if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                        PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                        if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                            pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                        String wiid="";
                        String proid="";
                        if (pfWorkFlowInstanceVo != null) {
                            wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                            proid = pfWorkFlowInstanceVo.getProId();
                        }
                        if(!StringUtils.equals(uploadTaskId,taskid)){
                            Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF, true);
                            String nodeName=AppConfig.getProperty("batchUploadFile.name");

                            Node destNode = nodeService.getNode(space.getId(), proid, true);
                            Node updateNode = nodeService.getNode(destNode.getId(), nodeName, true);
                            nodeService.remove(updateNode.getId());
                            Integer[] nodeIdList=new Integer[1];

                            nodeIdList[0]=Integer.parseInt(uploadNodeId);
                            nodeService.copy(nodeIdList,destNode.getId(),true);
                        }
                        taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "", null);
                    }
                }
            }

        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();

    }

    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 获取上传数量 batchFinishTask
     */
    @RequestMapping("uploadFileCount")
    @ResponseBody
    public Object uploadFileCount(HttpServletRequest request, @RequestParam(value = "uploadNodeId", required = false) String uploadNodeId) {
        HashMap map= Maps.newHashMap();
        int count=nodeService.getAllChildFilesCount(Integer.parseInt(uploadNodeId));
        map.put("count",count);

        return map;

    }
}
