package com.gtis.portal.service.server.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.UseridMachinePz;
import com.gtis.portal.service.server.UseridMachinePzService;
import com.gtis.portal.util.QueryCondition;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;


@Service
public class UseridMachinePzServiceImpl implements UseridMachinePzService {
    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;

    @Override
    public String getJqbm(String userid){
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("userid", QueryCondition.EQ, userid);
        queryConditions.add(queryCondition);
        String jqbm="";
        List<UseridMachinePz> result = baseDao.get(UseridMachinePz.class, queryConditions);
        if(CollectionUtils.isNotEmpty(result)){
            jqbm=result.get(0).getJqbm();
        }
        return jqbm;
    }

}
