package com.gtis.portal.service.server.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.server.PfWorkFlowEventConfigurationDao;
import com.gtis.portal.entity.PfWorkFlowEvent;
import com.gtis.portal.service.server.PfWorkFlowEventConfigurationService;
import com.gtis.portal.util.QueryCondition;
import com.gtis.portal.util.StaticParamHelper;
import com.gtis.util.ThreadPool;
import com.gtis.web.SessionUtil;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.*;

import static com.gtis.portal.entity.QPfWorkFlowEvent.pfWorkFlowEvent;


/**
 * @author <a href="mailto:songhaowen@gtmap.cn">ray</a>
 * @version 1.0, 2017/11/15
 * @description 不动产登记服务
 */
@Service
public class PfWorkFlowEventConfigurationServiceImpl implements PfWorkFlowEventConfigurationService {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(PfWorkFlowEventConfigurationServiceImpl.class);
    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;
    @Resource(name = "baseDaoImpl")
    BaseDao pfBaseDao;
    @Resource
    PfWorkFlowEventConfigurationDao pfWorkFlowEventConfigurationDao;
    @Resource
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;

    @Override
    public Page<PfWorkFlowEvent> listPfWorkFlowEventPage(String pfWorkFlowDefinitionId, String pfWorkFlowName, @PageableDefault(size = 10) Pageable page) {

        BooleanExpression expression = null;
        if (StringUtils.isNotBlank(pfWorkFlowName)) {
            expression = expression == null ? pfWorkFlowEvent.workFlowName.like("%" + pfWorkFlowName + "%") : expression.and(pfWorkFlowEvent.workFlowName.like("%" + pfWorkFlowName + "%"));
        }

        return pfWorkFlowEventConfigurationDao.findAll(expression, page);
    }

    @Override
    public List<PfWorkFlowEvent> listPfWorkFlowEvent(Map<String, Object> param) {
        if (MapUtils.isEmpty(param)) {
            return Lists.newArrayList();
        }
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        Iterator<Map.Entry<String, Object>> entries = param.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, Object> entry = entries.next();
            QueryCondition queryCondition = new QueryCondition(entry.getKey(), QueryCondition.EQ, entry.getValue());
            queryConditions.add(queryCondition);
        }
        if (StringUtils.equals(AppConfig.getProperty("workflowEvent.order.enable"), "true")) {
            String orderBy = " order by workflow_event_name,to_number(workflow_event_order)";
            return baseDao.get(PfWorkFlowEvent.class, queryConditions, orderBy);
        } else {
            return baseDao.get(PfWorkFlowEvent.class, queryConditions);
        }

    }

    @Override
    public void addPfWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        pfWorkFlowEvent.setId(UUIDGenerator.generate18());
        baseDao.save(pfWorkFlowEvent);
    }

    @Override
    public void savePfWorkFlowEventList(List<PfWorkFlowEvent> pfWorkFlowEventList) {
        if (CollectionUtils.isNotEmpty(pfWorkFlowEventList)) {
            for (PfWorkFlowEvent pfWorkFlowEvent : pfWorkFlowEventList) {
                addPfWorkFlowEvent(pfWorkFlowEvent);
            }
        }
    }

    @Override
    public void updatePfWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        baseDao.update(pfWorkFlowEvent);
    }

    @Override
    public void deletePfWorkFlowEventById(String[] ids) {
        baseDao.delete(PfWorkFlowEvent.class, ids);
    }

    @Override
    public PfWorkFlowEvent getPfWorkFlowEvent(String id) {
        return pfWorkFlowEventConfigurationDao.findOne(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Map<String, Object> importPfWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        Map<String, Object> result = new HashMap<String, Object>(1);
        if (pfWorkFlowEvent == null || StringUtils.isBlank(pfWorkFlowEvent.getWorkFlowDefinitionId())) {
            result.put("result", "未选择流程类型");
            return result;
        }
        String wfDefintionId = pfWorkFlowEvent.getWorkFlowDefinitionId();
        if (StringUtils.isNotBlank(wfDefintionId)) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wfDefintionId);
            String xmlEvent = sysWorkFlowDefineService.getWorkFlowDefineEventXml(pfWorkFlowDefineVo);
            List<PfWorkFlowEvent> pfWorkFlowEventList = cratePfWorkFlowEventByXml(pfWorkFlowEvent, xmlEvent);
            if (CollectionUtils.isEmpty(pfWorkFlowEventList)) {
                result.put("result", "未查找到配置数据或解析xml文件错误");
            }
            savePfWorkFlowEventList(pfWorkFlowEventList);
            //清空工作流事件
            cleanPfWorkFlowDefinitionEvent(wfDefintionId);
        }
        return result;
    }

    @Override
    public List<PfWorkFlowEvent> cratePfWorkFlowEventByXml(PfWorkFlowEvent pfWorkFlowEvent, String xml) {
        List<PfWorkFlowEvent> pfWorkFlowEventList = null;
        if (StringUtils.isNotBlank(xml)) {
            try {
                String eventName = pfWorkFlowEvent.getWorkFlowEventName();
                String wfDefintionId = pfWorkFlowEvent.getWorkFlowDefinitionId();
                Document doc = DocumentHelper.parseText(xml);
                String param = StringUtils.isNotBlank(eventName) ? "//Event[@name='" + eventName + "']" : "//Event";
                List eventNodes = doc.selectNodes(param);
                if (CollectionUtils.isNotEmpty(eventNodes)) {
                    pfWorkFlowEventList = new ArrayList<PfWorkFlowEvent>(eventNodes.size());
                    for (int i = 0; i < eventNodes.size(); i++) {
                        Node eventNode = (Node) eventNodes.get(i);
                        String activityDefinitionId = eventNode.valueOf("@activityDefinitionId");
                        if (StringUtils.isNotBlank(pfWorkFlowEvent.getActivityDefinitionId()) && !StringUtils.equals(activityDefinitionId, pfWorkFlowEvent.getActivityDefinitionId())) {
                            continue;
                        }
                        Element eleNode = (Element) eventNode;
                        String xmlEventName = eleNode.valueOf("@name");
                        List<Element> childsElement = eleNode.elements();
                        for (Element ele : childsElement) {
                            if (ele.getName().equalsIgnoreCase("Url")) {
                                String url = ele.getTextTrim();
                                String asyn = "0";
                                if (StringUtils.isNotBlank(ele.valueOf("@asyn")) && ele.valueOf("@asyn").equalsIgnoreCase("true")) {
                                    asyn = "1";
                                }
                                PfWorkFlowEvent workFlowEvent = new PfWorkFlowEvent();
                                workFlowEvent.setWorkFlowName(pfWorkFlowEvent.getWorkFlowName());
                                workFlowEvent.setWorkFlowDefinitionId(wfDefintionId);
                                workFlowEvent.setActivityDefinitionId(activityDefinitionId);
                                workFlowEvent.setWorkFlowEventName(xmlEventName);
                                workFlowEvent.setWorkFlowEventUrl(url);
                                workFlowEvent.setWorkFlowEventAsyn(asyn);
                                pfWorkFlowEventList.add(workFlowEvent);
                            }
                        }
                    }
                }
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        return pfWorkFlowEventList;
    }

    @Override
    public boolean doWfEvent(String wiid, String taskid, String userid, String eventName, String workFlowDefinitionId, String proid, String turnXml) throws Exception {
        //获取页面上选择的提交到下一步的节点的id
        String targetActivityId = "";
        log.info("-------------------------工作流实例id:" +wiid);
        if (StringUtils.isNotBlank(turnXml)) {
            Document document = DocumentHelper.parseText(turnXml);
            Element root = document.getRootElement();
            for (Iterator iter = root.elementIterator(); iter.hasNext(); ) {
                Element vals = (Element) iter.next();
                if ("Activity".equals(vals.getName())) {
                    targetActivityId = vals.attributeValue("Id");
                }
            }
        }
        WorkFlowInfo infoObj = getInfoObj(taskid, userid, workFlowDefinitionId, proid, wiid);
        List<PfWorkFlowEvent> pfWorkFlowEventList = null;
        if (StringUtils.isNotBlank(eventName)) {
            //处理转发验证
            //第一步  先查询是否配置转发项   通过WORKFLOW_DEFINITION_ID、WORKFLOW_EVENT_NAME
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
            Map<String, Object> param = new HashMap<String, Object>();
            param.put("workFlowEventName", eventName);
            if (pfWorkFlowInstanceVo != null) {
                param.put("workFlowDefinitionId", pfWorkFlowInstanceVo.getWorkflowDefinitionId());
                pfWorkFlowEventList = listPfWorkFlowEvent(param);
            } else if (StringUtils.isNotBlank(workFlowDefinitionId)) {
                param.put("workFlowDefinitionId", workFlowDefinitionId);
                pfWorkFlowEventList = listPfWorkFlowEvent(param);
            } else
                pfWorkFlowEventList = null;

        }
        //第二步 组织数据 调取server 包验证方法
        if (CollectionUtils.isNotEmpty(pfWorkFlowEventList)) {
            try {
                for (int i = 0; i < pfWorkFlowEventList.size(); i++) {
                    PfWorkFlowEvent pfWorkFlowEvent = pfWorkFlowEventList.get(i);
                    String activityDefinitionId = pfWorkFlowEvent.getActivityDefinitionId();
                    //获取数据库配置的目标节点
                    String targetActivityDefinitionId = pfWorkFlowEvent.getTargetActivityDefinitionId();
                    //查询数据里ACTIVITY_DEFINITION_ID  是否有值
                    PfActivityVo activityVo = infoObj.getSourceActivity();
                    //目标节点等于配置的目标节点，则执行，否则执行原先的逻辑
                    if (StringUtils.isNotBlank(targetActivityDefinitionId) && StringUtils.isNotBlank(targetActivityId) && targetActivityDefinitionId.equals(targetActivityId)) {
                        log.info("-------------------------事件名称:" + eventName);
                        excuteCommand(infoObj, pfWorkFlowEvent);
                    } else {
                        if (activityVo != null && activityDefinitionId != null && !"".equals(activityDefinitionId.trim())
                                && !activityDefinitionId.equals(activityVo.getActivityDefinitionId())) {
                            continue;
                        }
                        if (StringUtils.isBlank(targetActivityDefinitionId)) {
                            log.info("-------------------------事件名称:" + eventName);
                            excuteCommand(infoObj, pfWorkFlowEvent);
                        }
                    }
                }
            } catch (Exception e) {
                log.error(e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
        }
        return true;
    }

    public WorkFlowInfo getInfoObj(String taskid, String userid, String workFlowDefinitionId, String proid, String wiid) {
        WorkFlowInfo info = new WorkFlowInfo();
        info.setUserId(userid);
        PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
        if (pfTaskVo == null)
            pfTaskVo = sysTaskService.getHistoryTask(taskid);
        if (pfTaskVo != null) {
            info.setSourceTask(pfTaskVo);
            if (StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = sysTaskService.getActivity(pfTaskVo.getActivityId());
                if (pfActivityVo != null) {
                    //转发前的节点
                    info.setSourceActivity(pfActivityVo);
                    if (StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId())) {
                        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                        if (pfWorkFlowInstanceVo != null) {
                            info.setWorkFlowIntanceVo(pfWorkFlowInstanceVo);
                            if (StringUtils.isNotBlank(pfWorkFlowInstanceVo.getWorkflowDefinitionId())) {
                                PfWorkFlowDefineVo pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(pfWorkFlowInstanceVo.getWorkflowDefinitionId());
                                info.setWorkFlowDefineVo(pfWorkFlowDefineVo);
                            }
                        }
                        //获取转发后的节点
                        List<PfActivityVo> targetActivityVoList = sysTaskService.getWorkFlowInstanceActivityList(pfActivityVo.getWorkflowInstanceId());
                        if (CollectionUtils.isNotEmpty(targetActivityVoList)) {
                            List<PfActivityVo> targetActivityList = new ArrayList<PfActivityVo>();
                            for (PfActivityVo activityVo : targetActivityVoList) {
                                if (activityVo.getActivityState() == 1) {
                                    List<PfTaskVo> targetTaskList = sysTaskService.getTaskListByActivity(activityVo.getActivityId());
                                    targetActivityList.add(activityVo);
                                    info.setTargetTasks(targetTaskList);
                                }
                            }
                            info.setTargetActivitys(targetActivityList);
                        }
                    }
                }
            }
        } else {
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(wiid);
            workFlowIntanceVo.setProId(proid);
            info.setWorkFlowIntanceVo(workFlowIntanceVo);
            PfWorkFlowDefineVo pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(workFlowDefinitionId);
            info.setWorkFlowDefineVo(pfWorkFlowDefineVo);
        }
        return info;
    }

    private void excuteCommand(WorkFlowInfo infoObj, PfWorkFlowEvent pfWorkFlowEvent) throws UnsupportedEncodingException, WorkFlowException {

        String proId = infoObj.getWorkFlowIntanceVo().getProId();
        Long startExcuteTime=null,endExcuteTime=null;
        if (StringUtils.isNotEmpty(pfWorkFlowEvent.getWorkFlowEventUrl())) {
            String url = AppConfig.getPlaceholderValue(pfWorkFlowEvent.getWorkFlowEventUrl());
            boolean asyn = false;
            if (StringUtils.isNotBlank(pfWorkFlowEvent.getWorkFlowEventAsyn()) && StringUtils.equals(pfWorkFlowEvent.getWorkFlowEventAsyn(), "1")) {
                asyn = true; //表示异步执行
            }
            String method = "get";
            if (StringUtils.isNotBlank(pfWorkFlowEvent.getWorkFlowEventMethod()) && StringUtils.equals(pfWorkFlowEvent.getWorkFlowEventMethod(), "post")) {
                method = "post"; //表示异步执行
            }
            log.info("-------------------------执行开始时间 " + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss SSS").format(new Date(startExcuteTime = System.currentTimeMillis())));
            String result = excuteUrl(url, proId, infoObj, asyn, method);
            log.info("-------------------------执行结束时间 " + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss SSS").format(new Date(endExcuteTime = System.currentTimeMillis())));
            log.info("-------------------------执行时长  "+(endExcuteTime-startExcuteTime)+"ms");

            if (StringUtils.isNotBlank(result)) {
                throw new WorkFlowException(java.net.URLDecoder.decode(result, "UTF-8"));
            }

        }

    }

    private String excuteUrl(String urlString, boolean asyn, String method) throws IOException {
        final String urlStr = urlString;

        if (asyn) {
            if (StringUtils.equals("get", method)) {
                ///采用异步的方式执行，这个就没有返回结果了
                ThreadPool.execute(new Runnable() {
                    public void run() {
                        HttpClient httpClient = null;
                        GetMethod getMethod = null;
                        try {
                            httpClient = new HttpClient();
                            httpClient.getHttpConnectionManager().getParams()
                                    .setConnectionTimeout(5 * 10000);
                            getMethod = new GetMethod(urlStr);
                            httpClient.executeMethod(getMethod);

                        } catch (Exception ex) {
                            log.error(ex.getMessage(), ex);
                        } finally {
                            if (getMethod != null)
                                getMethod.releaseConnection();
                        }
                    }
                });
            } else {
                ThreadPool.execute(new Runnable() {
                    public void run() {
                        HttpClient httpClient = null;
                        PostMethod postMethod = null;
                        try {
                            httpClient = new HttpClient();
                            String[] arrurl = urlStr.split("\\?");
                            postMethod = new PostMethod(arrurl[0]);
                            String[] arrpara = arrurl[1].split("&");
                            for (int i = 0; i < arrpara.length; i++) {
                                String[] temp = arrpara[i].split("=");
                                postMethod.setParameter(temp[0], temp[1]);
                            }
                            httpClient.executeMethod(postMethod);

                        } catch (Exception ex) {
                            log.error(ex.getMessage(), ex);
                        } finally {
                            if (postMethod != null)
                                postMethod.releaseConnection();
                        }
                    }
                });
            }
        } else {
            if (StringUtils.equals("get", method)) {
                URL url = new URL(urlString);
                URLConnection urlConnection = url.openConnection();
                HttpURLConnection httpConnection = (HttpURLConnection) urlConnection;
                httpConnection.setConnectTimeout(5 * 10000);
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == HttpURLConnection.HTTP_OK) {
                    InputStream urlStream = null;
                    BufferedReader in = null;
                    try {
                        urlStream = httpConnection.getInputStream();
                        in = new BufferedReader(new InputStreamReader(urlStream, "GBK"));
                        StringBuilder stringBuilder = new StringBuilder();
                        String line;
                        while ((line = in.readLine()) != null) {
                            stringBuilder.append(line);
                        }
                        return stringBuilder.toString();
                    } catch (Exception ex) {
                        log.error(ex.getMessage(), ex);
                    } finally {
                        if (in != null)
                            in.close();
                        if (urlStream != null)
                            urlStream.close();
                    }
                }
                httpConnection.disconnect();
            } else {
                HttpClient httpClient = null;
                PostMethod postMethod = null;
                try {
                    httpClient = new HttpClient();
                    String[] arrurl = urlStr.split("\\?");
                    postMethod = new PostMethod(arrurl[0]);
                    String[] arrpara = arrurl[1].split("&");
                    for (int i = 0; i < arrpara.length; i++) {
                        String[] temp = arrpara[i].split("=");
                        postMethod.setParameter(temp[0], temp[1]);
                    }
                    httpClient.executeMethod(postMethod);
                    return postMethod.getResponseBodyAsString();
                } catch (Exception ex) {
                    log.error(ex.getMessage(), ex);
                } finally {
                    if (postMethod != null)
                        postMethod.releaseConnection();
                }
            }
        }
        return null;
    }

    private String excuteUrl(String urlStr, String proId, WorkFlowInfo infoObj, boolean asyn, String method) throws UnsupportedEncodingException {
        String[] urlStrs = urlStr.split(StaticParamHelper.URL_SEPARATOR_SPLIT);
        String workflowParaUrl = getWorkFlowInfoUrlFormat(infoObj);

        String platUrl = AppConfig.getProperty("platform.url");
        for (String urlTemp : urlStrs) {
            urlTemp = urlTemp.trim();
            if (!urlTemp.startsWith("http://")) {
                urlTemp = "http://" + platUrl + urlTemp;
            }
            try {
                if (urlTemp.indexOf("?") > 0)
                    urlTemp = urlTemp + "&proid=" + proId + "&" + workflowParaUrl;
                else
                    urlTemp = urlTemp + "?proid=" + proId + "&" + workflowParaUrl;
                if (infoObj.getSourceActivity() != null)
                    urlTemp = urlTemp + "&adid=" + infoObj.getSourceActivity().getActivityId();
                if (infoObj.getTargetActivitys() != null) {
                    StringBuilder targetActivityDefIds = new StringBuilder();
                    for (PfActivityVo pfActivityVo : infoObj.getTargetActivitys()) {
                        if (pfActivityVo != null) {
                            if (StringUtils.isNotBlank(targetActivityDefIds.toString()))
                                targetActivityDefIds.append(",").append(pfActivityVo.getActivityDefinitionId());
                            else
                                targetActivityDefIds.append(pfActivityVo.getActivityDefinitionId());
                        }
                    }
                    if (StringUtils.isNotBlank(targetActivityDefIds.toString()))
                        urlTemp = urlTemp + "&targetActivityDefids=" + targetActivityDefIds;
                }
                if (infoObj.getTargetTasks() != null && !infoObj.getTargetTasks().isEmpty()) {
                    List<HashMap> targetTaskList = new ArrayList<HashMap>();
//                    for (int i = 0; i < infoObj.getTargetTasks().size(); i++) {
//                        PfTaskVo taskVo = infoObj.getTargetTasks().get(i);
//                        HashMap map = new HashMap();
//                        map.put("targetTaskId", taskVo.getTaskId());
//                        map.put("targetUserId", taskVo.getUserVo().getUserId());
//                        map.put("targetActivityId", taskVo.getActivityId());
//                        targetTaskList.add(map);
//                    }
                    urlTemp = urlTemp + "&targetTasksInfo=" ;
                }
                log.info("-------------------------执行urlTemp:" + urlTemp);
                return excuteUrl(urlTemp, asyn, method);
            } catch (Exception e) {
                log.error("工作流事件定义url错误,请检查！" + urlTemp+"\n===错误信息==="+e.getMessage(), e);
            }
        }
        return null;
    }

    /**
     * 获取参数的WorkFlowInfo html url格式字符串的形式
     *
     * @return
     */
    private String getWorkFlowInfoUrlFormat(WorkFlowInfo infoObj) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("userid=");
        stringBuilder.append(infoObj.getUserId());
        if (infoObj.getSourceActivity() != null) {
            stringBuilder.append("&activityid=");
            stringBuilder.append(infoObj.getSourceActivity().getActivityId());
        }
        if (infoObj.getSourceTask() != null) {
            stringBuilder.append("&taskid=");
            stringBuilder.append(infoObj.getSourceTask().getTaskId());
        }
        List<PfActivityVo> targetActivitys = infoObj.getTargetActivitys();
        if (targetActivitys != null) {
            stringBuilder.append("&targetActivityIds=");
            for (int index = 0; index < targetActivitys.size(); index++) {
                if (index != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(targetActivitys.get(index).getActivityId());
            }
            stringBuilder.append("&targetActivityNames=");
            for (int index = 0; index < targetActivitys.size(); index++) {
                if (index != 0) {
                    stringBuilder.append(",");
                }
                if (StringUtils.isNotBlank(targetActivitys.get(index).getActivityName()))
                    stringBuilder.append(java.net.URLEncoder.encode(targetActivitys.get(index).getActivityName(), "utf-8"));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Map<String, Object> cleanWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        Map<String, Object> result = new HashMap<String, Object>(1);

        List<PfWorkFlowDefineVo> pfWorkFlowDefineVoList = null;
        if (pfWorkFlowEvent == null || StringUtils.isBlank(pfWorkFlowEvent.getWorkFlowDefinitionId()))
            pfWorkFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();
        if (pfWorkFlowEvent != null && StringUtils.isNotBlank(pfWorkFlowEvent.getWorkFlowDefinitionId())) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo1 = sysWorkFlowDefineService.getWorkFlowDefine(pfWorkFlowEvent.getWorkFlowDefinitionId());
            if (pfWorkFlowDefineVo1 != null) {
                pfWorkFlowDefineVoList = Lists.newArrayList();
                pfWorkFlowDefineVoList.add(pfWorkFlowDefineVo1);
            }
        }
        if (CollectionUtils.isNotEmpty(pfWorkFlowDefineVoList)) {
            for (PfWorkFlowDefineVo pfWorkFlowDefineVo : pfWorkFlowDefineVoList) {
                cleanPfWorkFlowDefinitionEvent(pfWorkFlowDefineVo.getWorkflowDefinitionId());
            }
        }
        return result;
    }

    @Override
    public void cleanPfWorkFlowDefinitionEvent(String workflowDefinitionId) {
        String sql = "update PfWorkFlowDefinition as p set p.workflowDefinitionShell =?0 where p.workflowDefinitionId=?1";
        pfBaseDao.executeJpql(sql, "", workflowDefinitionId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Map<String, Object> batchImportPfWorkFlowEvent() {
        Map<String, Object> result = new HashMap<String, Object>(1);
        List<PfWorkFlowDefineVo> pfWorkFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();
        if (CollectionUtils.isNotEmpty(pfWorkFlowDefineVoList)) {
            for (PfWorkFlowDefineVo pfWorkFlowDefineVo : pfWorkFlowDefineVoList) {
                String xmlEvent = sysWorkFlowDefineService.getWorkFlowDefineEventXml(pfWorkFlowDefineVo);
                PfWorkFlowEvent pfWorkFlowEvent = new PfWorkFlowEvent();
                pfWorkFlowEvent.setWorkFlowDefinitionId(pfWorkFlowDefineVo.getWorkflowDefinitionId());
                pfWorkFlowEvent.setWorkFlowName(pfWorkFlowDefineVo.getWorkflowName());
                List<PfWorkFlowEvent> pfWorkFlowEventList = cratePfWorkFlowEventByXml(pfWorkFlowEvent, xmlEvent);

                savePfWorkFlowEventList(pfWorkFlowEventList);
            }
        }
        return result;
    }
}
