package com.gtis.portal.service.impl.quartz;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Maps;
import com.gtis.common.Page;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SplitDataService;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.portal.util.ReadXmlProps;
import oracle.sql.DATE;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 超期自动挂起定时触发类
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/14
 */
@Service
public class AutoPostTaskService {
    @Autowired
    SplitDataService splitDataService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysCalendarService sysCalendarService;
    protected final Logger logger = Logger.getLogger(getClass());

    @Scheduled(cron = "${autoPostTask.quartz.config}")
    public void autoPostTask() {
        String autoPostTaskEnable = AppConfig.getProperty("autoPostTask.enable");
        String userid = AppConfig.getProperty("autoPostTask.userid");
        String reason = AppConfig.getProperty("autoPostTask.reason");
        //显示超期任务
        List<Map> overTimeConfigList = ReadXmlProps.getOverTimeConfigList();
        if (StringUtils.equals(autoPostTaskEnable, "true") && CollectionUtils.isNotEmpty(overTimeConfigList)) {
            if (StringUtils.isBlank(userid))
                userid = "0";
            if (StringUtils.isBlank(reason))
                reason = "自动挂起";
            try {
                HashMap mapParam2 = Maps.newHashMap();
                mapParam2.put("TASK_STATE", "1");
                mapParam2.put("STATE", "1");
//                mapParam2.put("ID", "2A9H2334NIWY622N");
                //不计算超期的节点
                String noComputeActivityNames = AppConfig.getProperty("overTime.noCompute.activityNames");
                if (StringUtils.isNotBlank(noComputeActivityNames)) {
                    String[] activityNameArray = noComputeActivityNames.split(",");
                    String activityNames = null;
                    for (String activityName : activityNameArray) {
                        if (StringUtils.isBlank(activityNames))
                            activityNames = "'" + activityName + "'";
                        else
                            activityNames += ",'" + activityName + "'";
                    }
                    mapParam2.put("NOT_IN_ACTIVITY_NAMES", activityNames);
                }
//                List<HashMap> overTimeList = splitDataService.query("getTaskList", mapParam2);
                List<HashMap> overTimeList = null;
                int overTimeListSize = splitDataService.getCount("getTaskList", mapParam2);
                Page<HashMap> overTimeListPage = splitDataService.query("getTaskList", mapParam2,0,overTimeListSize);
                if(overTimeListPage!=null && overTimeListPage.getItems()!=null && overTimeListPage.getItems()!=null)
                    overTimeList=overTimeListPage.getItems();
                if (CollectionUtils.isNotEmpty(overTimeList)) {
                    for (HashMap taskListMap : overTimeList) {
                        for (Map overTimeConfigMap : overTimeConfigList) {
                            if (taskListMap.get("WORKFLOW_NAME") != null && overTimeConfigMap.get("wfName") != null
                                    && overTimeConfigMap.get("activityName") != null && taskListMap.get("ACTIVITY_NAME") != null
                                    && StringUtils.equals(taskListMap.get("WORKFLOW_NAME").toString(), overTimeConfigMap.get("wfName").toString())
                                    && StringUtils.equals(taskListMap.get("ACTIVITY_NAME").toString(), overTimeConfigMap.get("activityName").toString())) {
                                if (taskListMap.get("TASK_OVER_TIME") != null && overTimeConfigMap.get("overtimeDay") != null) {
                                    String day = ((new Date().getTime() - ((Date)taskListMap.get("TASK_OVER_TIME")).getTime()  ) / (24 * 60 * 60 * 1000))+"";
                                    List<Date> holidayList=sysCalendarService.getHolidayList(((Date)taskListMap.get("TASK_OVER_TIME")),new Date());
                                    int workDay=0;
                                    if (StringUtils.isNotBlank(day))
                                        workDay=Integer.parseInt(day);
                                    if(CollectionUtils.isNotEmpty(holidayList))
                                        workDay=workDay-holidayList.size();
                                    //挂起任务
                                    if (workDay >= Integer.parseInt(overTimeConfigMap.get("overtimeDay").toString()))
                                        workFlowCoreService.lockWorkFlowInstance(taskListMap.get("WORKFLOW_INSTANCE_ID").toString(), taskListMap.get("ASSIGNMENT_ID").toString(), reason, userid);
                                }
                            }
                        }
                    }
                }
            } catch (Exception e) {
                logger.error("自动挂起异常，异常原因：" + e.getMessage());
            }
        }
    }
}
