package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfWorkflowInstance;
import com.gtis.portal.entity.QPfWorkflowInstance;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.service.PfWorkflowInstanceService;
import com.gtis.portal.util.CommonUtils;
import com.gtis.portal.util.QueryCondition;
import com.gtis.web.SessionUtil;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * java对象基础操作类
 *
 * @文件名 BaseServiceImpl.java
 * @作者 卢向伟
 * @创建日期 2015年12月12日
 * @创建时间 下午2:53:19
 * @版本号 V 1.0
 */
@Service
public class PfWorkflowInstanceServiceImpl implements PfWorkflowInstanceService {
    @Value("${egov.conf}/portal/workflow_default_name.json")
    private String location;
    @Resource(name = "baseDaoImpl")
    BaseDao baseDao;
    @Autowired
    public SysWorkFlowInstanceRelService workFlowInstanceRelService;
    @Autowired
    private SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    private PfUserService userService;

    @Override
    public PfWorkflowInstance findById(String proid) {
        if (StringUtils.isNotBlank(proid)) {
            return baseDao.getById(PfWorkflowInstance.class, proid);
        }
        return null;
    }

    @Override
    public Page queryPageList(String proid, @PageableDefault(size = 1) Pageable pageable) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition;

        QPfWorkflowInstance qPfWorkflowInstance = QPfWorkflowInstance.pfWorkflowInstance;
        BooleanExpression expression = null;
        List<PfWorkFlowInstanceVo> wfList = workFlowInstanceRelService.getWorkFlowRelList(proid);
        if (wfList != null) {
            StringBuffer jhlxClause = new StringBuffer();
            jhlxClause.append(" workflowInstanceId in (");
            for (int i = 0; i < wfList.size(); i++) {
                if (wfList.get(i) != null) {
                    jhlxClause.append("'" + wfList.get(i).getWorkflowIntanceId() + "',");
                }
            }
            jhlxClause.append("'')");
            queryConditions.add(new QueryCondition(jhlxClause.toString()));
        }

        return baseDao.get(PfWorkflowInstance.class, queryConditions, "order by createTime desc", pageable);
    }

    /**
     * 加载工作流实例创建的时候，默认的工作流名称配置
     *
     * @param reload
     */
    @Override
    public void initWorkflowInstanceName(boolean reload) {
        try {
            if (reload) {
                CommonUtils.defaultWINameMap = null;
            }
            if (CommonUtils.defaultWINameMap == null || CommonUtils.defaultWINameMap.keySet().size() <= 0) {
                CommonUtils.defaultWINameMap = (Map) CommonUtils.readJsonFile(location);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 初始化当前时间点、人员的工作流实例的默认名称
     *
     * @param wdId
     */
    @Override
    public String getWorkflowInstanceDefaultName(String wdId) {
        try {
            if (CommonUtils.defaultWINameMap != null && CommonUtils.defaultWINameMap.keySet().size() > 0) {
                Object obj = CommonUtils.defaultWINameMap.get(wdId);
                if (obj != null) {
                    Map<String, String> valueMap = (Map<String, String>) obj;
                    String wdname = MapUtils.getString(valueMap, "wdname");
                    PfWorkFlowDefineVo workFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdId);
                    String workflowDefineName = workFlowDefineVo != null ? workFlowDefineVo.getWorkflowName() : "";
                    wdname = StringUtils.isBlank(wdname) ? workflowDefineName : wdname;
                    String custom = MapUtils.getString(valueMap, "custom");
                    String defaultName = MapUtils.getString(valueMap, "defaultName");
                    String split = MapUtils.getString(valueMap, "split");
                    if (StringUtils.isNotBlank(defaultName)) {
                        //"user+date+wdname+custom+organ",
//						defaultName = StringUtils.replace(defaultName,"user","（"+SessionUtil.getCurrentUser().getUsername()+"）");
//						defaultName = StringUtils.replace(defaultName,"date", CalendarUtil.getCurChinaYMDStrDate());
//						defaultName = StringUtils.replace(defaultName,"wdname", wdname);
//						defaultName = StringUtils.replace(defaultName,"custom", custom);
//						defaultName = StringUtils.replace(defaultName,"organ",SessionUtil.getCurrentUser().getLstOragn().get(0).getOrganName());
//						defaultName = StringUtils.replace(defaultName,"+", split);
//						defaultName = StringUtils.replace(defaultName,"null","");
//						defaultName = StringUtils.replace(defaultName," ","");
//						return defaultName;
                        Map m = new HashMap();
                        m.put("user", SessionUtil.getCurrentUser().getUsername());
                        m.put("date", CalendarUtil.getCurChinaYMDStrDate());
                        m.put("wdname", wdname);
                        m.put("organ", SessionUtil.getCurrentUser().getLstOragn().get(0).getOrganName());
                        return CommonUtils.freemarkerProcess(m, defaultName);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public List<HashMap> getTaskList(HashMap param, Integer rownum) {
        try {
            String sql = "select t.* from ( ";

            String tasksql = " select t1.ASSIGNMENT_ID,t1.BEGIN_TIME,t1.OVER_TIME AS ACTIVITY_OVER_TIME,t3.OVER_TIME AS Workflow_OVER_TIME,t1.USER_ID,t2.ACTIVITY_NAME,t2.ACTIVITY_ID,t3.WORKFLOW_INSTANCE_NAME," +
                    " t3.CREATE_TIME,t3.WORKFLOW_INSTANCE_ID,t3.WORKFLOW_DEFINITION_ID,t3.create_user,t2.TIME_LIMIT,t3.time_limit as WFD_TIME_LIMIT,t3.priority" +
                    " from PF_ASSIGNMENT t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3" +
                    " where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id " +
                    " and t2.ACTIVITY_STATE=1 and (t3.WORKFLOW_STATE=1 or t3.WORKFLOW_STATE=3) ";
            if (param != null) {
                if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank(MapUtils.getString(param, "BEGIN_TIME"))) {
                    tasksql += " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '" + MapUtils.getString(param, "BEGIN_TIME") + "' ";
                }
                if (param.containsKey("userIds") && StringUtils.isNotBlank(MapUtils.getString(param, "userIds"))) {
                    tasksql += " and t1.USER_ID in (" + MapUtils.getString(param, "userIds") + ")";
                }
            }
            String orderfield = MapUtils.getString(param, "_orderfield_");
            if (StringUtils.isNotBlank(orderfield)) {
                tasksql += " order by " + orderfield;
            } else {
                tasksql += " order by t1.begin_time desc ";
            }
            sql += tasksql + " ) t ";
            if (rownum != null) {
                sql += "  where  rownum<= " + rownum;
            } else {
                sql += "  where  rownum<= 12";
            }
            List<HashMap> queryResults = baseDao.getMapBySql(sql);
            return queryResults;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<HashMap> getTaskListByConfig(HashMap param) {
        try {
            String sql = "select " +
                    "       t.ASSIGNMENT_ID, t.BEGIN_TIME, t.OVER_TIME AS ACTIVITY_OVER_TIME,t.USER_ID," +
                    "       t1.ACTIVITY_NAME, t1.ACTIVITY_ID," +
                    "       t2.WORKFLOW_INSTANCE_NAME,t2.OVER_TIME AS Workflow_OVER_TIME, t2.CREATE_TIME," +
                    "       t2.WORKFLOW_INSTANCE_ID, t2.WORKFLOW_DEFINITION_ID, t2.create_user," +
                    "       t2.TIME_LIMIT, t2.time_limit as WFD_TIME_LIMIT" +
                    "  from pf_assignment          t," +
                    "       pf_activity            t1," +
                    "       pf_workflow_instance   t2," +
                    "       pf_workflow_definition t3" +
                    " where t.activity_id = t1.activity_id" +
                    "   and t1.activity_state = 1" +
                    "   and t1.workflow_instance_id = t2.workflow_instance_id" +
                    "   and (t2.workflow_state = 1 or t2.workflow_state = 3)" +
                    "   and t2.workflow_definition_id = t3.workflow_definition_id";
            if (param.containsKey("userIds") && StringUtils.isNotEmpty(MapUtils.getString(param, "userIds"))) {
                sql += " and t.user_id in (" + MapUtils.getString(param, "userIds") + ")";
            }
            if (param.containsKey("BEGIN_TIME") && StringUtils.isNotEmpty(MapUtils.getString(param, "BEGIN_TIME"))) {
                sql += " and t.begin_time >=to_date('" + MapUtils.getString(param, "BEGIN_TIME") + "','yyyy-mm-dd')";
            }
            if (param.containsKey("definitionIds") && StringUtils.isNotEmpty(MapUtils.getString(param, "definitionIds"))) {
                sql += " and t3.workflow_definition_id in (" + MapUtils.getString(param, "definitionIds") + ")";
            } else if (param.containsKey("businessIds") && StringUtils.isNotEmpty(MapUtils.getString(param, "businessIds"))) {
                sql += " and t3.business_id in(" + MapUtils.getString(param, "businessIds") + ")";
            }
            sql += "and rownum<=8 order by t1.begin_time desc";
            List<HashMap> queryResults = baseDao.getMapBySql(sql);
            return queryResults;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getTaskListByConfigOfCount(HashMap param) {
        try {
            String sql = "select count(*) as TASKSIZE " +
                    " from pf_assignment t,pf_activity t1, pf_workflow_instance   t2, pf_workflow_definition t3" +
                    " where t.activity_id = t1.activity_id" +
                    "   and t1.activity_state = 1" +
                    "   and t1.workflow_instance_id = t2.workflow_instance_id" +
                    "   and (t2.workflow_state = 1 or t2.workflow_state = 3)" +
                    "   and t2.workflow_definition_id = t3.workflow_definition_id" ;
            if (param.containsKey("userIds") && StringUtils.isNotEmpty(MapUtils.getString(param, "userIds"))) {
                sql += " and t.user_id in (" + MapUtils.getString(param, "userIds") + ")";
            }
            if (param.containsKey("BEGIN_TIME") && StringUtils.isNotEmpty(MapUtils.getString(param, "BEGIN_TIME"))) {
                sql += " and t.begin_time >=to_date('" + MapUtils.getString(param, "BEGIN_TIME") + "','yyyy-mm-dd')";
            }
            if (param.containsKey("definitionIds") && StringUtils.isNotEmpty(MapUtils.getString(param, "definitionIds"))) {
                sql += " and t3.workflow_definition_id in (" + MapUtils.getString(param, "definitionIds") + ")";
            } else if (param.containsKey("businessIds") && StringUtils.isNotEmpty(MapUtils.getString(param, "businessIds"))) {
                sql += " and t3.business_id in(" + MapUtils.getString(param, "businessIds") + ")";
            }
            Object queryObject = baseDao.getMapObjBySql(sql);
            if (queryObject != null) {
                return MapUtils.getString((HashMap) queryObject, "TASKSIZE");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getTaskCount(HashMap param) {
        try {

            String tasksql = " select count(*) as TASKSIZE" +
                    " from PF_ASSIGNMENT t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3 ,pf_user t6" +
                    " where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id and t3.create_user=t6.user_id " +
                    " and t2.ACTIVITY_STATE=1 and (t3.WORKFLOW_STATE=1 or t3.WORKFLOW_STATE=3) ";
            if (param != null) {
                if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank(MapUtils.getString(param, "BEGIN_TIME"))) {
                    tasksql += " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '" + MapUtils.getString(param, "BEGIN_TIME") + "' ";
                }
                if (param.containsKey("userIds") && StringUtils.isNotBlank(MapUtils.getString(param, "userIds"))) {
                    tasksql += " and t1.USER_ID in (" + MapUtils.getString(param, "userIds") + ")";
                }
            }
            Object queryObject = baseDao.getMapObjBySql(tasksql);
            if (queryObject != null) {
                return MapUtils.getString((HashMap) queryObject, "TASKSIZE");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 查询用户日期内的项目列表
     *
     * @param createTime
     * @param userId
     * @param rownum
     * @return
     */
    @Override
    public List<HashMap> getProjectListByPerformer(String createTime, String userId, Integer rownum) {
        String agrs1 = "";
        //创建时间过滤
        if (StringUtils.isNotEmpty(createTime)) {
            agrs1 += " and to_char(t3.CREATE_TIME,'yyyy-MM-dd') >='" + createTime + "'";
        }
        //创建用户过滤
        String agrs2 = " ";
        if (StringUtils.isNotEmpty(userId)) {
            agrs2 = " and t2.user_id='" + userId + "'";
        }

        String sql = "select * from ( select * from ( " +
                " select " +
                " t3.WORKFLOW_INSTANCE_ID, " +
                " t3.WORKFLOW_INSTANCE_NAME, " +
                " t3.WORKFLOW_DEFINITION_ID, " +
                " t3.CREATE_TIME, " +
                " t3.FINISH_TIME, " +
                " t3.OVER_TIME, " +
                " t4.WORKFLOW_NAME, " +
                " t4.business_id, " +
                " t3.TIME_LIMIT, " +
                " t3.PRIORITY, " +
                " t3.WORKFLOW_STATE, " +
                " t3.REMARK, " +
                " t3.MONITOR_ID, " +
                " t3.create_user, " +
                " t4.TIME_LIMIT as WFD_TIME_LIMIT, " +
                " t5.user_name CREATE_USERNAME, " +
                " t3.REGION_CODE " +
                " from " +
                " PF_WORKFLOW_INSTANCE t3, " +
                " PF_WORKFLOW_DEFINITION t4, " +
                " pf_user t5 " +
                " where " +
                " t3.WORKFLOW_DEFINITION_ID=t4.WORKFLOW_DEFINITION_ID and " +
                " t3.create_user=t5.user_id " + agrs1 +
                " ) t " +
                " where t.workflow_instance_id in " +
                " ( " +
                " Select t1.workflow_instance_id from pf_activity t1, pf_assignmenthistory t2 " +
                " where t1.activity_id=t2.activity_id " + agrs2 +
                " ) order by t.CREATE_TIME desc ";
        sql += " ) t ";
        if (rownum != null) {
            sql += "  where  rownum<= " + rownum;
        } else {
            sql += "  where  rownum<= 12";
        }
        try {
            List<HashMap> queryResults = baseDao.getMapBySql(sql);
            return queryResults;
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<HashMap> getTaskOverList(HashMap param, Integer rownum) {
        try {
            String sql = "select t.* from ( ";

            String tasksql =
                    " select t1.ASSIGNMENT_ID,t1.BEGIN_TIME,t1.USER_ID,t2.ACTIVITY_NAME,t2.ACTIVITY_ID,t3.WORKFLOW_INSTANCE_NAME," +
                            " t3.CREATE_TIME,t3.WORKFLOW_INSTANCE_ID,t3.WORKFLOW_DEFINITION_ID,t3.create_user,t3.priority" +
                            " from PF_ASSIGNMENTHISTORY t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3 " +
                            " where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id " +
                            " and t1.isback=0 ";

            if (param != null) {
                if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank(MapUtils.getString(param, "BEGIN_TIME"))) {
                    tasksql += " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '" + MapUtils.getString(param, "BEGIN_TIME") + "' ";
                }
                if (param.containsKey("userIds") && StringUtils.isNotBlank(MapUtils.getString(param, "userIds"))) {
                    tasksql += " and t1.USER_ID in (" + MapUtils.getString(param, "userIds") + ")";
                }
            }

            tasksql += " order by t1.finish_time desc ";
            sql += tasksql + " ) t ";
            if (rownum != null) {
                sql += "  where  rownum<= " + rownum;
            } else {
                sql += "  where  rownum<= 12";
            }
            List<HashMap> queryResults = baseDao.getMapBySql(sql);
            return queryResults;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getTaskOverCount(HashMap param) {
        try {
            String tasksql =
                    " select count(*) as TASKSIZE" +
                            " from PF_ASSIGNMENTHISTORY t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3 " +
                            " where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id " +
                            " and t1.isback=0 ";
            if (param != null) {
                if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank(MapUtils.getString(param, "BEGIN_TIME"))) {
                    tasksql += " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '" + MapUtils.getString(param, "BEGIN_TIME") + "' ";
                }
                if (param.containsKey("userIds") && StringUtils.isNotBlank(MapUtils.getString(param, "userIds"))) {
                    tasksql += " and t1.USER_ID in (" + MapUtils.getString(param, "userIds") + ")";
                }
            }
            Object queryObject = baseDao.getMapObjBySql(tasksql);
            System.out.println(tasksql);
            if (queryObject != null) {
                return MapUtils.getString((HashMap) queryObject, "TASKSIZE");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void update(PfWorkflowInstance obj) {
        if (obj != null) {
            baseDao.update(obj);
        }
    }
}
