package com.gtis.portal.service.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfTaskAgent;
import com.gtis.portal.service.PfTaskAgentService;
import com.gtis.portal.util.QueryCondition;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:liangxichang@gtmap.cn">lxc</a>
 * @version 1.0 , 2020/1/8
 * @description
 **/
@Service
public class PfTaskAgentServiceImpl implements PfTaskAgentService {

    @Resource(name = "baseDaoImpl")
    BaseDao baseDao;

    @Override
    public List<PfTaskAgent> getByUserId(String userId) {
        return getByUserIdAndAgentType(userId, null);
    }

    @Override
    public List<PfTaskAgent> getByUserIdAndAgentType(String userId, Integer agentType) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        if (StringUtils.isNotBlank(userId)) {
            QueryCondition queryCondition = new QueryCondition("userId", QueryCondition.EQ, userId);
            queryConditions.add(queryCondition);
        }
        if (agentType != null) {
            QueryCondition queryCondition = new QueryCondition("agentType", QueryCondition.EQ, agentType);
            queryConditions.add(queryCondition);
        }
        return baseDao.get(PfTaskAgent.class,queryConditions);
    }
}
