package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.utils.ClientInfoUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.NewsDao;
import com.gtis.portal.entity.PfLog;
import com.gtis.portal.entity.PfMessageAccept;
import com.gtis.portal.entity.PfMessageSend;
import com.gtis.portal.entity.PfNews;
import com.gtis.portal.service.PfNewsService;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.QueryCondition;
import com.gtis.web.SessionUtil;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;

import static com.gtis.portal.entity.QPfNews.pfNews;

/**
 * @author: <a href="mailto:shenfei@gtmap.cn">sf</a>
 * @version: 1.0
 * @Date: 2019-05-31 15:01
 * @Description:
 */
@Service
public class PfNewsServiceImpl implements PfNewsService {
    @Resource(name = "baseDaoImpl")
    BaseDao baseDao;
    @Autowired
    private NewsDao newsDao;

    @Override
    public Page<PfNews> queryNewsList(String content, Date beginDate, Date endDate, @PageableDefault(size = 10) Pageable page) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank(content)) {
            expression = expression == null ? pfNews.newcontent.like("%" + content + "%") : expression.and(pfNews.newcontent.like("%" + content + "%"));
        }
        if (beginDate != null) {
            expression = expression == null ? pfNews.newdate.after(beginDate) : expression.and(pfNews.newdate.after(beginDate));
        }
        if (endDate != null) {
            expression = expression == null ? pfNews.newdate.before(endDate) : expression.and(pfNews.newdate.before(endDate));
        }
        return newsDao.findAll(expression, page);
    }
    @Override
    public void deleteNews(PfNews pfNews) {
        baseDao.delete(PfNews.class, pfNews.getNewid());
    }
    public void saveNews(PfNews pfNews)
    {
        baseDao.save(pfNews);
    }
    @Override
    public void updateNews(PfNews pfNews) {
        if (pfNews != null ) {
            baseDao.update(pfNews);
        }
    }
    public PfNews getById(String newId)
    {
        PfNews pfNews=new PfNews();
        if (StringUtils.isNotBlank(newId))
        {
            pfNews= baseDao.getById(PfNews.class,newId);
        }
        return  pfNews;
    }
    public List<PfNews> getList()
    {
        List<QueryCondition> queryConditionlist=new ArrayList<QueryCondition>();
       return baseDao.get(PfNews.class,queryConditionlist,"order by newdate desc");
    }

}
