package com.gtis.portal.service.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfLog;
import com.gtis.portal.service.PfLogService;
import com.gtis.portal.util.QueryCondition;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:liangxichang@gtmap.cn">lxc</a>
 * @version 1.0 , 2019/10/17
 * @description
 **/
@Service
public class PfLogServiceImpl implements PfLogService {
    @Resource(name = "baseDaoImpl")
    BaseDao baseDao;


    @Override
    public List<PfLog> getRecentLogByTimeAndUser(Date newdate,String userId) {
        QueryCondition queryCondition = new QueryCondition("userId", QueryCondition.EQ,userId);
        QueryCondition queryCondition1 = new QueryCondition("createTime", QueryCondition.GT,newdate);
        List<QueryCondition> queryConditions=new ArrayList<QueryCondition>();
        queryConditions.add(queryCondition);
        queryConditions.add(queryCondition1);
        List<PfLog> pfLogList = baseDao.get(PfLog.class,queryConditions);
        return pfLogList;

    }
}
