package com.gtis.portal.service;

import com.gtis.plat.vo.PfWorkFlowInstanceVo;

import javax.servlet.http.HttpServletRequest;

/**
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2016/9/30
 * @description 日志服务
 */
public interface LogService {
    /**
     * @param wiid   工作流id
     * @param taskid 实例id
     * @param userid 用户id
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @version 1.0, 2016/9/30
     * @description 删除任务方法
     */
    void saveDelTaskLog(String wiid, String taskid, String userid, String reason, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request);

    /**
     * @param wiid   工作流id
     * @param taskid 实例id
     * @param userid 用户id
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @version 1.0, 2016/9/30
     * @description 取回任务日志
     */
    void saveRetrieveTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request);

    /**
     * @param wiid   工作流id
     * @param taskid 实例id
     * @param userid 用户id
     * @author <a href="mailto:zhangyu@gtmap.cn">zx</a>
     * @version 1.0, 2017/12/02
     * @description 转发任务日志
     */
    void saveTurnTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request);


    /**
     * @param wiid   工作流id
     * @param taskid 实例id
     * @param userid 用户id
     * @param reason 原因
     * @author <a href="mailto:zhangyu@gtmap.cn">zx</a>
     * @version 1.0, 2017/12/02
     * @description 取回任务日志
     */
    void saveTurnBackTaskLog(String wiid, String taskid, String userid, String reason, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request);

    /**
     * @param wiid   工作流id
     * @param taskid 实例id
     * @param userid 用户id
     * @author <a href="mailto:zhangyu@gtmap.cn">zx</a>
     * @version 1.0, 2017/12/02
     * @description 办结任务日志
     */
    void saveEndTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request);

    /**
     * @param wiid   工作流id
     * @param taskid 实例id
     * @param userid 用户id
     * @author <a href="mailto:zhangyu@gtmap.cn">zx</a>
     * @version 1.0, 2017/12/02
     * @description 终止任务日志
     */
    void saveStopTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request);

    /**
     * @param wiid   工作流id
     * @param taskid 实例id
     * @param userid 用户id
     * @author <a href="mailto:zhangyu@gtmap.cn">zx</a>
     * @version 1.0, 2017/12/02
     * @description 挂起任务日志
     */
    void savePostTaskLog(String wiid, String taskid, String userid, String remark, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request);

    /**
     * @param wiid   工作流id
     * @param taskid 实例id
     * @param userid 用户id
     * @author <a href="mailto:zhangyu@gtmap.cn">zx</a>
     * @version 1.0, 2017/12/02
     * @description 解挂任务日志
     */
    void saveUpPostTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request);

    /**
     * @param wiid   工作流id
     * @param taskid 实例id
     * @param userid 用户id
     * @author <a href="mailto:zhangyu@gtmap.cn">zx</a>
     * @version 1.0, 2017/12/02
     * @description 创建任务日志
     */
    void saveCreateTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request);

    /**
     * @param wiid   工作流id
     * @param taskid 实例id
     * @param userid 用户id
     * @author <a href="mailto:zhangyu@gtmap.cn">zx</a>
     * @version 1.0, 2017/12/02
     * @description 任务调整优先任务日志
     */
    void savePriorityTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request);

    /**
     * @return void
     * @Param [request, userid, reason, wiid, content,controller]
     * @Author <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @Date 9:07 2019/5/21
     * @Description 保存日志到bdc_xt_log表
     */
    public void saveLog(HttpServletRequest request, String userid, String reason, String wiid, String content, String controller);

    public void saveLog(HttpServletRequest request, String userid, String content, String controller);
}
