/**
 * ztree控件的数据设置
 */
var treeLeft="treeLeft";
var treeRight="treeRight";
var zTreeLeft,zTreeRight;

var settingLeft = {
	edit: {
		enable: true,
		showRemoveBtn: false,
		showRenameBtn: false
	},
	view: {dblClickExpand: true},
	check: {enable: false},
	async: {
		enable: true,
		url:_leftTreeUrl,
		type: "get"
	},
	callback: {
		onAsyncSuccess: zTreeLeftOnAsyncSuccess,
		beforeDrag: beforeDrag,
		beforeDrop: beforeDrop
	}/*,
	callback: {
		onClick: ztreeLeftOnClick,
		onRightClick: ztreeLeftOnRightClick,
		onAsyncSuccess: zTreeLeftOnAsyncSuccess
	}*/
};

var settingRight = {
	edit: {
		enable: true,
		showRemoveBtn: showRemoveBtn,
		showRenameBtn: false
	},
	view: {dblClickExpand: true},
	check: {enable: false},
	async: {
		enable: true,
		url:_rightTreeUrl,
		type: "get"
	},callback: {
		onAsyncSuccess: zTreeRightOnAsyncSuccess
	}
};
$(document).ready(function(){
	$.fn.zTree.init($("#"+treeLeft), settingLeft);
	zTreeLeft = $.fn.zTree.getZTreeObj(treeLeft);

	$.fn.zTree.init($("#"+treeRight), settingRight);
	zTreeRight = $.fn.zTree.getZTreeObj(treeRight);

	zTreeLeft.setting.edit.drag.isCopy = true;
	zTreeLeft.setting.edit.drag.isMove = false;

	zTreeRight.setting.edit.drag.isCopy = false;
	zTreeRight.setting.edit.drag.isMove = false;

    $('#expandTreeLeft').click(function () {
        zTreeLeft.expandAll(true);
    });
    $('#collapseTreeLeft').click(function () {
        zTreeLeft.expandAll(false);
    });

    $('#refreshTreeLeft').click(function () {
        zTreeLeft.refresh();
    });

    $('#refreshTreeRight').click(function () {
        zTreeRight.refresh();
    });

	$('#saveNewFile').click(function () {
        saveNewNode();
	});

	$('#auroRelToRight').click(function () {
		auroRelToRight();
	});

});

/**
 * 刷新树节点样式
 */
function zTreeLeftOnAsyncSuccess(event, treeId, treeNode,msg) {
    zTreeLeft.expandAll(true);
}
/**
 * 拖动之前，判断左侧树节点是否符合拖拽条件
 * @param treeId
 * @param treeNodes
 * @returns {boolean}
 */
function beforeDrag(treeId, treeNodes) {
	for (var i=0,l=treeNodes.length; i<l; i++) {
		if (treeNodes[i].drag === false) {
			return false;
		}
	}
	return true;
}

/**
 * 拖拽之后，判断目标树节点是否符合接收条件
 * @param treeId
 * @param treeNodes
 * @param targetNode
 * @param moveType
 * @returns {boolean}
 */
function beforeDrop(treeId, treeNodes, targetNode, moveType) {
    if(targetNode){
		if(!targetNode.drag){
			//如果目标节点是根节点，则需要考虑拖拽类型，上一个和下一个都是不允许操作的，必须放到根节点内才行
			if(targetNode.level == 0){
				if(moveType == "inner"){
					return true;
				}
			}else{
				//只有操作类型不是其中的，或者目标节点是文件夹的，才允许拖拽
				if(targetNode.parent || moveType != "inner"){
					return true;
				}
			}
		}
    }
    return false;
}

function auroRelToRight(){
	var autoRelUrl = cur_proj_url+"/fileCenter/autoRelFile";
	//询问框
	var index = layer.confirm('即将进行自动挂接，重名文件是否覆盖？', {
		btn: ['确定覆盖','不覆盖','取消操作'] //按钮
	}, function(){
		relFile(autoRelUrl,true);
		layer.close(index);
	}, function(){
		relFile(autoRelUrl,false);
		layer.close(index);
	}, function(){
		layer.close(index);
		return;
	});

}

function relFile(autoRelUrl,cover){
	$.ajax({
		url:autoRelUrl,
		type:'post',
		dataType:'json',
		data:{fromProid:_fromProid,toProid:_toProid,cover:cover},
		success:function (data) {
			alert(data.msg);
			if(data.success){
				zTreeRight.reAsyncChildNodes(null, "refresh");
			}
		},
		error:function (data) {
			alert("保存失败");
		}
	});
}

//************************右侧树的方法**************************************
/**
 * 刷新树节点样式
 */
function zTreeRightOnAsyncSuccess(event, treeId, treeNode,msg) {
	zTreeRight.expandAll(true);
	var nodeArray = zTreeRight.transformToArray(zTreeRight.getNodes());
}
function showRemoveBtn(treeId, treeNode) {
	//只有从左侧拖过来的节点，才允许进行删除操作
	return treeNode.drag;
}

function saveNewNode(){
    //保存的时候，只针对拖动过来的数据进行存储，也就是有drag属性为true的节点
    var nodes = zTreeRight.getNodesByParam("drag", true, null);
	var parentNodes = [];
    if(nodes && nodes.length > 0) {
        for (var i = 0; i < nodes.length; i++) {
            var tmpNode = nodes[i];
            /*
             * 1、获取该节点的右侧父节点和左侧父节点
             * 右侧父节点获取：直接根据parentTid获取即可
             * 左侧父节点获取：根据parentId查找
             * 2、对比两个右节点是否一致，如果不一致，则取右侧节点作为新的parentId
             */
            var rightParent = tmpNode.getParentNode();
            tmpNode.pid=rightParent.id;

			//将拖拽的节点，在右侧的新节点也传递后台，用于判断该父节点是右侧原来的，还是拖拽过来的
			parentNodes.push(rightParent);
        }
    }
    $.ajax({
        url:_saveUrl,
        type:'post',
        dataType:'json',
        data:{nodes:$.toJSON(nodes),parentNodes:$.toJSON(parentNodes),fromProid:_fromProid,toProid:_toProid},
        success:function (data) {
            alert(data.msg);
            if(data.success){
				zTreeRight.reAsyncChildNodes(null, "refresh");
            }
        },
        error:function (data) {
            alert("保存失败");
        }
    });
}
//**************************************************************