/**
 * Created by zx on 2015/4/16.
 */
function trim(str) {
    return str.replace(/(^\s*)|(\s*$)/g, '');
}

var Cookie = {
    setCookie : function(name, value, option) {
        var str = name + "=" + escape(value);
        if (option) {
            var date = new Date();
            if (option['days'] || option['hours'] || option['minutes']) {
                var ms = ((option['days'] || 0) * 1440 + (option['hours'] || 0)
                    * 60 + (option['minutes'] || 0))
                    * 60000;
                date.setTime(date.getTime() + ms);
                str += "; expires=" + date.toGMTString();
            }
            if (option.path)
                str += "; path=" + option.path;
            if (option.domain)
                str += "; domain=" + option.domain;
            if (option.secure)
                str += "; true";
        }
        document.cookie = str;
    },
    getCookie : function(name) {
        var cookieArray = document.cookie.split("; ");
        for (var i = 0; i < cookieArray.length; i++) {
            var arr = cookieArray[i].split("=");
            if (arr[0] == name)
                return unescape(arr[1]);
        }
        return "";
    },
    deleteCookie : function(name) {
        this.setCookie(name, "", {
            days : -1
        });
    }
};