<#--jqGrid的列表-->
<#macro list tableId="" pageId="" keyField="" dataUrl="" rowdbclick="" rowNum="" height="" multiselect="">
<style>
    .form{
        text-align: right;
    }
    .form .row {
        margin: 10px 40px 10px 0px;
    }
    .form .row .date{
        width: 100%;
    }
    .form .row .col-xs-2 {
        padding-left: 0px;
        padding-right: 4px;
        text-align: right;
    }

    .form .row .col-xs-4 {
        padding-left: 0px;
        padding-right: 0px;
    }

    label {
        font-weight: bold;
    }
    /*重写下拉列表高度*/
    .chosen-container>.chosen-single, [class*="chosen-container"]>.chosen-single {
        height: 34px;
    }
    .button{
        margin-bottom: 10px;
    }
    .ui-jqgrid-bdiv{
        overflow-x: hidden!important;
    }
    /*新建弹出框的样式修改及ie8居中问题*/
    .modal-dialog {
        width: 650px;
        margin: 30px auto;
    }

</style>
<script type="text/javascript">
    function rendererEvent(fn, args) {
        return fn.apply(this, args);
    }
    function clickEvent(fn, args) {
        eval(fn + "(" + args + ")");

    }
</script>
<script type="text/javascript">
    $(function () {
        var multiselect=false;
        if("${multiselect!}"=="true")
            multiselect=true;
        var colmodels = new Array();
        var colNames = new Array();
        <#nested/>
        var grid_selector = "#${tableId!}";
        var pager_selector = "#${pageId!}";
        $(window).on('resize.jqGrid', function () {
            $(grid_selector).jqGrid('setGridWidth', $(".page-content").width());
        });
        var parent_column = $(grid_selector).closest('[class*="col-"]');
        $(document).on('settings.ace.jqGrid', function (ev, event_name, collapsed) {
            if (event_name === 'sidebar_collapsed' || event_name === 'main_container_fixed') {
                $(grid_selector).jqGrid('setGridWidth', parent_column.width());
            }
        });
        var rowNum;
        if("${rowNum}"==null || "${rowNum}"=="")
            rowNum=10;
        else
            rowNum=parseInt("${rowNum}");
        var height;
        if("${height}"==null || "${height}"=="")
            height='auto';
        else
            height="${height}px";
        jQuery(grid_selector).jqGrid({
            url: "${dataUrl!}",
            datatype: "json",
            height: height,
            jsonReader: {
                id: '${keyField!}'
    },
            colNames: colNames,
            colModel: colmodels,
            viewrecords: true,
            rowNum: rowNum,
            rowList: [rowNum, rowNum*2, rowNum*3],
            pager: pager_selector,
            pagerpos: "left",
            altRows: false,
//            page:0,
            multiboxonly: multiselect,
            multiselect: multiselect,
//            page:0,
//            multiboxonly: multiselect,
//            multiselect: multiselect,

            loadComplete: function () {
                var table = this;
                setTimeout(function () {
                    updatePagerIcons(table);
                    enableTooltips(table);
                    $(grid_selector).jqGrid('setGridWidth', $(".page-content").width());
                }, 0);
            },
            ondblClickRow:function (rowid) {
                if("${rowdbclick!}"!=null && "${rowdbclick!}"!="")
                    ${rowdbclick!}(rowid);
            },
            onPaging: function(pgButton) {
                var page;
                if (pgButton == "next_grid-pager")
                    page = parseInt($(".ui-pg-input").val() )+ 1;
                else if (pgButton == "prev_grid-pager" && this.p.page > 1)
                    page = parseInt($(".ui-pg-input").val() ) - 1;
                else if (pgButton == "first_grid-pager")
                    page = 1;
                else if (pgButton == "last_grid-pager")
                    page = this.p.lastpage;
                if (url != null && url != "") {
                    if(url.indexOf("&currentPage=")>-1)
                        url=url.substr(0,url.indexOf("&currentPage=")+13)+page;
                    else
                        url=url+"&currentPage="+page;
                    jQuery(grid_selector).setGridParam({url: url, datatype: 'json', page: page, postData: ''});
                    jQuery(grid_selector).trigger("reloadGrid");//重新加载JqGrid
                }
            },
            editurl: "",
            caption: "",
            autowidth: true
        });

    });

    function enableTooltips(table) {
        $('.navtable .ui-pg-button').tooltip({container: 'body'});
        $(table).find('.ui-pg-div').tooltip({container: 'body'});
    }
    function updatePagerIcons(table) {
        var replacement =
        {
            'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
            'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
            'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
            'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140'
        };
        $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
            var icon = $(this);
            var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

            if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
        })
    }   //时间控件
    $('.date-picker').datepicker({
        autoclose:true,
        todayHighlight:true,
        language:'zh-CN'
    }).next().on(ace.click_event, function () {
        $(this).prev().focus();
    });
    //下拉框
    $('.chosen-select').chosen({allow_single_deselect:true, no_results_text:"无匹配数据", width:"100%"});
    $(window).on('resize.chosen',function () {
        $.each($('.chosen-select'), function (index, obj) {
            $(obj).next().css("width", 0);
            var w = $(obj).parent().width();
            $(obj).next().css("width", w);
            $(obj).next().css("text-align", "left");
        })
    }).trigger('resize.chosen');
</script>

</#macro>
<#--jqGrid的查询表单-->
<#macro queryForm id="" method="" url="">
<form class="form advancedSearchTable" id="${id!}" name="${id!}" method="${method!}" url="${url!}">
    <#nested/>
</form>
</#macro>
<#--jqGrid的查询条件行-->
<#macro queryRow>
<div class="row">
    <#nested/>
</div>
</#macro>
<#--jqGrid的查询条件-->
<#--查询条件每一行，目前只支持两个条件一行，支持类型text，datefield，combo，combo必须要有showFieldName显示的名称valueFieldName实际值，defaultValue默认值，source支持json和后台传list-->
<#macro queryItem label="" name="" itemType="" showFieldName="" valueFieldName="" source="" defaultValue="">
    <div class="col-xs-2">
        <label>${label!}：</label>
    </div>
    <div class="col-xs-4">
        <#if itemType=="datefield">
            <span class="input-icon date">
                     <input type="text" class="date-picker form-control" name="${name!}"
                            data-date-format="yyyy-mm-dd">
                    <i class="ace-icon fa fa-calendar"></i>
                </span>
        <#elseif  itemType=="combo">
            <#if source?index_of("[") gt -1>
                <#assign text="{'source':${source}}" />
                <#assign json=text?eval />
                <select name="${name!}" class="form-control chosen-select" data-placeholder=" ">
                    <option value=""></option>
                    <#list json.source as item>
                        <option value="${item["${valueFieldName?if_exists}"]}" <#if item["${valueFieldName?if_exists}"]==defaultValue> selected="selected"</#if>>${item["${showFieldName?if_exists}"]}</option>
                    </#list>
                </select>
            <#else>
                <select name="${name!}" class="form-control chosen-select" data-placeholder=" ">
                    <option value=""></option>
                    <#list source?eval as item>
                        <option value="${item["${valueFieldName?if_exists}"]}" <#if item["${valueFieldName?if_exists}"]==defaultValue> selected="selected"</#if>>${item["${showFieldName?if_exists}"]}</option>
                    </#list>
                </select>
            </#if>
        <#else>
            <input type="text" name="${name!}" class="form-control">
        </#if>
    </div>
</#macro>
<#--jqGrid的查询按钮-->
<#macro queryBar text="" handler="" >
    <button type="button" class="btn btn-sm btn-primary button" onclick="clickEvent('${handler!}')">${text!}</button>
</#macro>
<#--jqGrid的列表按钮-->
<#macro toolBars >
<div class="tableHeader">
    <ul>
        <#nested/>
    </ul>
</div>
</#macro>
<#--jqGrid的列表按钮-->
<#macro toolBar handler="" text="">
<li>
    <button type="button"  onclick="clickEvent('${handler!}')">
        <span>${text!}</span>
    </button>
</li>
</#macro>
<#--jqGrid的列表字段-->
<#macro field fieldName="" header="" width="" renderer="" hidden="">
    var fieldName = "${fieldName!}";
    var header = "${header!}";
    var width = "${width!}";
    var renderer = "${renderer!}";
    var hidden = "${hidden!}";
    colNames.push(header);
    if (hidden == "")
        hidden = false;
    var colmodel;
    if (renderer != null && renderer != "") {
        colmodel = {
            name: fieldName,
            index: fieldName,
            width: width,
            sortable: false,
            hidden: hidden,
            formatter: function (cellvalue, options, rowObject) {
                return rendererEvent(eval("${renderer!}"), [cellvalue, options, rowObject]);
            }
        };
    } else
        colmodel = {name: fieldName, index: fieldName, width: width, sortable: false, hidden: hidden};

    colmodels.push(colmodel);
</#macro>