/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.interceptor;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.model.WorkflowEvent;
import com.gtis.portal.service.LogService;
import com.gtis.portal.service.TaskGeneralService;
import com.gtis.portal.service.server.PfWorkFlowEventConfigurationService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TaskServiceInterceptor {
    private final Logger log = LoggerFactory.getLogger(TaskServiceInterceptor.class);
    @Autowired
    LogService logService;
    @Autowired
    TaskGeneralService taskGeneralService;
    @Autowired
    PfWorkFlowEventConfigurationService pfWorkFlowEventConfigurationService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;

    @Before(value="execution (* com.gtis.portal.service.TaskActionService.delTask(..)) && args(wiid,taskid,userid,reason,proid,pfWorkFlowInstanceVo,request)")
    public void beforeDelTask(String wiid, String taskid, String userid, String reason, String proid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.logService.saveDelTaskLog(wiid, taskid, userid, reason, pfWorkFlowInstanceVo, request);
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_BeforeDel.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), proid, "");
    }

    @AfterReturning(value="execution (* com.gtis.portal.service.TaskActionService.delTask(..)) && args(wiid,taskid,userid,reason,proid,pfWorkFlowInstanceVo,request)")
    public void afterDelTask(String wiid, String taskid, String userid, String reason, String proid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_Del.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), proid, "");
    }

    @Before(value="execution (* com.gtis.portal.service.TaskActionService.retrieveTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void beforeRetrieveTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_BeforeRetrieve.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
    }

    @AfterReturning(value="execution (* com.gtis.portal.service.TaskActionService.retrieveTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void afterRetrieveTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_Retrieve.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
        this.logService.saveRetrieveTaskLog(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
    }

    @Before(value="execution (* com.gtis.portal.service.TaskActionService.turnTaskByXml(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request,turnXml) ||execution (* com.gtis.portal.service.TaskActionService.turnTaskByWorkFlowInfo(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request,turnXml) ||execution (* com.gtis.portal.service.TaskActionService.autoTurnTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request,turnXml)")
    public void beforeTurnTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request, String turnXml) throws Exception {
        this.taskGeneralService.turnBeforeTaskGeneralWork(wiid, taskid, userid);
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_BeforeTurn.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", turnXml);
    }

    @AfterReturning(value="execution (* com.gtis.portal.service.TaskActionService.turnTaskByXml(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request,turnXml) ||execution (* com.gtis.portal.service.TaskActionService.turnTaskByWorkFlowInfo(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request,turnXml) ||execution (* com.gtis.portal.service.TaskActionService.autoTurnTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request,turnXml)")
    public void afterTurnTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request, String turnXml) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_Turn.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", turnXml);
        this.taskGeneralService.turnAfterTaskGeneralWork(wiid, taskid, userid);
        this.logService.saveTurnTaskLog(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
    }

    @Before(value="execution (* com.gtis.portal.service.TaskActionService.turnBackTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request,adids,remark)")
    public void beforeTurnBackTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request, String adids, String remark) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_BeforeBack.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
    }

    @AfterReturning(value="execution (* com.gtis.portal.service.TaskActionService.turnBackTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request,adids,remark)")
    public void afterTurnBackTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request, String adids, String remark) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_Back.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
        String savePriorityEnable = AppConfig.getProperty((String)"turnback.task.save.priority.enable");
        if (StringUtils.equals((String)savePriorityEnable, (String)"true")) {
            this.workFlowIntanceService.updateWorkFlowIntancePriority(wiid, "4");
        }
        this.logService.saveTurnBackTaskLog(wiid, taskid, userid, remark, pfWorkFlowInstanceVo, request);
    }

    @Before(value="execution (* com.gtis.portal.service.TaskActionService.endTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request,turnXml,info)")
    public void beforeEndTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request, String turnXml, WorkFlowInfo info) throws Exception {
        this.taskGeneralService.turnBeforeTaskGeneralWork(wiid, taskid, userid);
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_BeforeTurn.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", turnXml);
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_BeforeEnd.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", turnXml);
    }

    @AfterReturning(value="execution (* com.gtis.portal.service.TaskActionService.endTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request,turnXml,info)")
    public void afterEndTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request, String turnXml, WorkFlowInfo info) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_End.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", turnXml);
        this.logService.saveEndTaskLog(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
    }

    @Before(value="execution (* com.gtis.portal.service.TaskActionService.stopTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void beforeStopTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_BeforeStop.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
    }

    @AfterReturning(value="execution (* com.gtis.portal.service.TaskActionService.stopTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void afterStopTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_Stop.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
        this.logService.saveStopTaskLog(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
    }

    @Before(value="execution (* com.gtis.portal.service.TaskActionService.postTask(..)) && args(wiid,taskid,userid,remark,pfWorkFlowInstanceVo,request)")
    public void beforePostTask(String wiid, String taskid, String userid, String remark, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_BeforePost.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
    }

    @AfterReturning(value="execution (* com.gtis.portal.service.TaskActionService.postTask(..)) && args(wiid,taskid,userid,remark,pfWorkFlowInstanceVo,request)")
    public void afterPostTask(String wiid, String taskid, String userid, String remark, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_Post.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
        this.logService.savePostTaskLog(wiid, taskid, userid, remark, pfWorkFlowInstanceVo, request);
    }

    @Before(value="execution (* com.gtis.portal.service.TaskActionService.upPostTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void beforeUnPostTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_BeforeUnPost.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
    }

    @AfterReturning(value="execution (* com.gtis.portal.service.TaskActionService.upPostTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void afterUnPostTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_UnPost.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
        this.logService.saveUpPostTaskLog(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
    }

    @Before(value="execution (* com.gtis.portal.service.TaskActionService.createTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void beforeCreateTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_BeforeBegin.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
    }

    @AfterReturning(value="execution (* com.gtis.portal.service.TaskActionService.createTask(..)) && args(wiid,taskid,userid,pfWorkFlowInstanceVo,request)")
    public void afterCreateTask(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_Begin.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
        this.logService.saveCreateTaskLog(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
    }

    @Before(value="execution (* com.gtis.portal.service.TaskActionService.priorityTask(..)) && args(wiid,taskid,userid,priority,pfWorkFlowInstanceVo,request)")
    public void beforePriorityTask(String wiid, String taskid, String userid, String priority, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_BeforePriority.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
    }

    @AfterReturning(value="execution (* com.gtis.portal.service.TaskActionService.priorityTask(..)) && args(wiid,taskid,userid,priority,pfWorkFlowInstanceVo,request)")
    public void afterPriorityTask(String wiid, String taskid, String userid, String priority, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) throws Exception {
        this.pfWorkFlowEventConfigurationService.doWfEvent(wiid, taskid, userid, WorkflowEvent.WorkFlow_Priority.name(), pfWorkFlowInstanceVo.getWorkflowDefinitionId(), "", "");
        this.logService.savePriorityTaskLog(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
    }
}

