/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.editor;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.PfResource;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ResourceEditorController {
    @Autowired
    PfMenuService menuService;
    @Autowired
    PfResourceService resourceService;

    @RequestMapping(value={"/editor/resource"})
    public String enter(@RequestParam(value="menuId", required=false) String menuId, Model model) {
        model.addAttribute("menuId", (Object)menuId);
        return "/editor/menu-resource";
    }

    @ModelAttribute(value="resource")
    public PfResource getResource(@RequestParam(value="menuId", required=false) String menuId, @RequestParam(value="rid", required=false) String rid) {
        PfMenu menu;
        PfResource resource = new PfResource();
        if (StringUtils.isNotBlank((String)rid)) {
            resource = this.resourceService.getResource(rid);
        } else if (StringUtils.isNotBlank((String)menuId) && StringUtils.isNotBlank((String)(menu = this.menuService.getMenu(menuId)).getResourceId())) {
            resource = this.resourceService.getResource(menu.getResourceId());
        }
        return resource;
    }

    @RequestMapping(value={"/editor/resource/save"})
    @ResponseBody
    public String save(@ModelAttribute(value="resource") PfResource resource, @RequestParam(value="menuId", required=false) String menuId, Model model) {
        if (StringUtils.isNotBlank((String)resource.getResourceId())) {
            this.resourceService.updateResource(resource);
        } else {
            String rid = UUIDGenerator.generate();
            resource.setResourceId(rid);
            this.resourceService.insertResource(resource);
            PfMenu menu = this.menuService.getMenu(menuId);
            menu.setResourceId(rid);
            this.menuService.updateMenu(menu);
        }
        return null;
    }
}

