/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Maps;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.entity.PfBusiness;
import com.gtis.portal.entity.PfWorkflowDefinition;
import com.gtis.portal.entity.PfWorkflowInstance;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfResourceGroupService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.PfWorkflowDefinitionService;
import com.gtis.portal.service.PfWorkflowInstanceService;
import com.gtis.portal.util.MatrixToImageWriter;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import java.io.InputStream;
import java.sql.Blob;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/workflow"})
public class WorkflowController
extends BaseController {
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfResourceGroupService groupService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    PfWorkflowDefinitionService workflowDefinitionService;
    @Autowired
    PfWorkflowInstanceService workflowInstanceService;
    @Autowired
    PfBusinessService businessService;
    @Autowired
    SysCalendarService sysCalendarService;
    @Resource
    @Qualifier(value="boolListNumber")
    List<PublicVo> boolListNumber;
    @Resource
    @Qualifier(value="priorityList")
    List<PublicVo> priorityList;
    @Resource
    @Qualifier(value="databaseList")
    List<PublicVo> databaseList;

    @RequestMapping(value={""})
    public String manage(Model model) {
        model.addAttribute("boolListNumber", (Object)this.boolListNumber);
        model.addAttribute("priorityList", (Object)this.priorityList);
        model.addAttribute("databaseList", (Object)this.databaseList);
        return "/config/workflow/manage";
    }

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object resourcejson(Model model) {
        if (SessionUtil.getCurrentUser().isAdmin()) {
            Ztree ztree = this.workflowDefinitionService.getAllWfdTree();
            return ztree;
        }
        return null;
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public PfWorkflowDefinition getWorkflowDefinition(@RequestParam(value="keyId", required=false) String keyId) {
        PfWorkflowDefinition wfd = this.workflowDefinitionService.findById(keyId);
        return wfd == null ? new PfWorkflowDefinition() : wfd;
    }

    @RequestMapping(value={"image"})
    @ResponseBody
    public void image(@RequestParam(value="keyId", required=false) String keyId, HttpServletResponse response) {
        PfWorkflowDefinition wfd = this.workflowDefinitionService.findById(keyId);
        if (wfd != null && wfd.getWorkflowImage() != null) {
            Blob blob = wfd.getWorkflowImage();
            InputStream in = null;
            try {
                in = blob.getBinaryStream();
                ServletOutputStream out = response.getOutputStream();
                byte[] data = new byte[(int)blob.length()];
                int i = 0;
                while ((i = in.read(data)) != -1) {
                    out.write(data);
                }
                out.close();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="wfd") PfWorkflowDefinition wfd, Model model) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)wfd.getWorkflowDefinitionId())) {
                this.workflowDefinitionService.update(wfd);
            }
            wfd = this.workflowDefinitionService.findById(wfd.getWorkflowDefinitionId());
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", true);
            result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
            result.put("wfd", wfd);
            return result;
        }
        return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
    }

    @RequestMapping(value={"infoBs"})
    @ResponseBody
    public PfBusiness getBusiness(@RequestParam(value="keyId", required=false) String keyId) {
        PfBusiness bs = this.businessService.findById(keyId);
        return bs == null ? new PfBusiness() : bs;
    }

    @RequestMapping(value={"saveBs"})
    @ResponseBody
    public Object saveBusiness(HttpServletRequest req, PfBusiness business, Model model) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)business.getBusinessId())) {
                this.businessService.update(business);
            }
            business = this.businessService.findById(business.getBusinessId());
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", true);
            result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
            result.put("business", business);
            return result;
        }
        return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
    }

    @RequestMapping(value={"getWDByTaskId"})
    @ResponseBody
    public Object getWDByTaskId(@RequestParam String taskId) {
        HashMap workflowDefinitionMap = Maps.newHashMap();
        PfWorkflowDefinition wd = this.workflowDefinitionService.getPfWorkflowDefinitionByTaskId(taskId);
        PfWorkFlowDefineVo pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(wd.getWorkflowDefinitionId());
        if (pfWorkFlowDefineVo != null) {
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel((PfWorkFlowDefineVo)pfWorkFlowDefineVo);
            String directCreateTask = xmlDao.getExtendedAttribute("DirectCreateTask") + "";
            workflowDefinitionMap.put("directCreateTask", directCreateTask);
            workflowDefinitionMap.put("createTaskAlertSave", xmlDao.getExtendedAttribute("CreateTaskAlertSave") + "");
        }
        workflowDefinitionMap.put("workflowDefine", pfWorkFlowDefineVo);
        return workflowDefinitionMap;
    }

    @RequestMapping(value={"getQRCode"})
    @ResponseBody
    public void getQRCode(@RequestParam(value="proid", required=false) String proid, HttpServletResponse response) {
        String remark = "";
        HashMap workflowDefinitionMap = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)proid)) {
            try {
                WorkFlowXml xmlDao;
                String useRemarkSaveQRCode;
                PfWorkFlowInstanceVo workflowInstance = this.sysWorkFlowInstanceService.getWorkflowInstance(proid);
                if (workflowInstance != null && StringUtils.isNotBlank((String)workflowInstance.getRemark()) && StringUtils.equalsIgnoreCase((String)"true", (String)(useRemarkSaveQRCode = (xmlDao = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)workflowInstance)).getExtendedAttribute("UseRemarkSaveQRCode") + ""))) {
                    remark = workflowInstance.getRemark();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (StringUtils.isNotBlank((String)remark)) {
                int width = 120;
                int height = 120;
                String format = "jpg";
                Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
                hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
                BitMatrix bitMatrix = new MultiFormatWriter().encode(remark, BarcodeFormat.QR_CODE, width, height, hints);
                MatrixToImageWriter.writeToResponse((BitMatrix)bitMatrix, (String)format, (HttpServletResponse)response);
            } else {
                String imgPath = AppConfig.getPlatFormUrl() + "/pf/images/blank.gif";
                imgPath = RequestUtils.initOptProperties((String)imgPath);
                MatrixToImageWriter.writeToResponse((String)imgPath, (String)"gif", (HttpServletResponse)response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"workflowDefineName"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWorkflowDefineName(@RequestParam String proid) {
        PfWorkFlowDefineVo workFlowDefineVo;
        String workflownName = "";
        HashMap workflowDefinitionMap = Maps.newHashMap();
        PfWorkFlowInstanceVo workFlowInstanceVo = new PfWorkFlowInstanceVo();
        if (StringUtils.isNotBlank((String)proid) && (workFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(proid)) != null && (workFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId())) != null) {
            workflownName = workFlowDefineVo.getWorkflowName();
        }
        return workflownName;
    }

    @RequestMapping(value={"updateWFIOvertime"})
    @ResponseBody
    public Object updateWorkflowInstanceOvertime(String proid, String beginDate, String timeLimit) {
        if (StringUtils.isNotBlank((String)proid)) {
            PfWorkflowInstance workflowInstance = this.workflowInstanceService.findById(proid);
            if (proid != null) {
                if (StringUtils.isNotBlank((String)timeLimit)) {
                    workflowInstance.setTimeLimit(timeLimit);
                }
                Date beginAt = new Date();
                if (StringUtils.isNotBlank((String)beginDate)) {
                    beginAt = CalendarUtil.formatDate((String)beginDate);
                }
                Date overTime = this.sysCalendarService.getOverTime(beginAt, timeLimit);
                workflowInstance.setOverTime(overTime);
                this.workflowInstanceService.update(workflowInstance);
            }
        }
        return null;
    }
}

