/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import cn.gtmap.estateplat.core.support.mybatis.page.model.PageImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.portal.entity.WorkFlowCommission;
import com.gtis.portal.service.server.WorkFlowCommissionService;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/workFlowCommission"})
public class WorkFlowCommissionController {
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    WorkFlowCommissionService workFlowCommissionService;

    @RequestMapping(value={""})
    public String autoTurnTask(Model model) {
        List pfWorkFlowDefineVoList = this.sysWorkFlowDefineService.getWorkFlowDefineList();
        List<PfUserVo> pfUserVoList = new ArrayList();
        pfUserVoList = this.sysUserService.getAllUsers();
        if (CollectionUtils.isNotEmpty((Collection)pfWorkFlowDefineVoList)) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo = new PfWorkFlowDefineVo();
            pfWorkFlowDefineVo.setWorkflowName("\u5168\u90e8");
            pfWorkFlowDefineVo.setWorkflowDefinitionId("");
            pfWorkFlowDefineVoList.add(0, pfWorkFlowDefineVo);
        }
        if (CollectionUtils.isNotEmpty(pfUserVoList)) {
            PfUserVo pfUserVo = new PfUserVo();
            pfUserVo.setUserName("\u5168\u90e8");
            pfUserVo.setUserId("");
            pfUserVoList.add(0, pfUserVo);
        }
        model.addAttribute("pfWorkFlowDefineVoList", (Object)pfWorkFlowDefineVoList);
        model.addAttribute("pfUserVoList", pfUserVoList);
        return "config/workflow-commission";
    }

    @ResponseBody
    @RequestMapping(value={"/getWorkFlowCommissionPagesJson"})
    public Object getWorkFlowCommissionPagesJson(Pageable pageable, String workFlowId, String principalId, String agentId, @RequestParam(value="number", required=false) String number, @RequestParam(value="currentPage", required=false) String currentPage) {
        int pageNumber = pageable.getPageNumber();
        if (currentPage != null) {
            pageNumber = Integer.parseInt(currentPage) - 1;
        }
        QPageRequest pageable1 = new QPageRequest(pageNumber, 10);
        Page workFlowCommissionPage = this.workFlowCommissionService.queryWorkFlowCommissionList(workFlowId, principalId, agentId, (Pageable)pageable1);
        PageImpl workFlowCommissionPage1 = null;
        if (workFlowCommissionPage != null) {
            workFlowCommissionPage1 = new PageImpl((Collection)workFlowCommissionPage.getContent(), pageNumber + 1, Integer.parseInt(workFlowCommissionPage.getTotalElements() + ""), 10);
        }
        return workFlowCommissionPage1;
    }

    @RequestMapping(value={"getPrincipalAndAgent"})
    @ResponseBody
    public Object getPrincipalAndAgent(String workFlowId, String principalId) {
        HashMap map = Maps.newHashMap();
        List pfUserVoList = Lists.newArrayList();
        ArrayList pfUserVoList1 = null;
        if (StringUtils.isNotBlank((String)workFlowId)) {
            pfUserVoList = this.sysUserService.getAllUsers();
            if (StringUtils.isNotBlank((String)principalId) && CollectionUtils.isNotEmpty((Collection)(pfUserVoList1 = Lists.newArrayList((Iterable)pfUserVoList)))) {
                Iterator it = pfUserVoList1.iterator();
                while (it.hasNext()) {
                    PfUserVo pfUserVo = (PfUserVo)it.next();
                    if (!principalId.equals(pfUserVo.getUserId())) continue;
                    it.remove();
                }
            }
        }
        map.put("principalList", pfUserVoList);
        map.put("agentList", pfUserVoList1);
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/save"})
    public Object save(WorkFlowCommission workFlowCommission) {
        String msg = "true";
        try {
            WorkFlowCommission workFlowCommission1 = this.workFlowCommissionService.getWorkFlowCommissionByWdidAndYhid(workFlowCommission.getWorkFlowId(), workFlowCommission.getPrincipalId(), workFlowCommission.getAgentId());
            if (workFlowCommission1 != null && !StringUtils.equals((String)workFlowCommission1.getWorkFlowCommissionId(), (String)workFlowCommission.getWorkFlowCommissionId())) {
                msg = "\u6570\u636e\u5e93\u5b58\u5728\u8be5\u7c7b\u578b\u6570\u636e\uff01";
                return URLEncoder.encode(msg);
            }
            this.workFlowCommissionService.save(workFlowCommission);
        }
        catch (Exception e) {
            msg = "\u4fdd\u5b58\u4e0d\u6210\u529f\uff01";
        }
        return URLEncoder.encode(msg);
    }

    @ResponseBody
    @RequestMapping(value={"/getWorkFlowCommission"})
    public Object getWorkFlowCommission(String workFlowCommissionId) {
        WorkFlowCommission workFlowCommission = new WorkFlowCommission();
        if (StringUtils.isNotBlank((String)workFlowCommissionId)) {
            workFlowCommission = this.workFlowCommissionService.getWorkFlowCommission(workFlowCommissionId);
        }
        return workFlowCommission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"del"})
    public HashMap del(String ids) {
        HashMap<String, String> map = new HashMap<String, String>();
        String result = "\u5220\u9664\u6210\u529f\uff01";
        try {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(",")) {
                        this.workFlowCommissionService.delWorkFlowCommission(id);
                    }
                } else {
                    this.workFlowCommissionService.delWorkFlowCommission(ids);
                }
            }
        }
        catch (Exception e) {
            result = "\u5220\u9664\u5931\u8d25\uff01";
            e.printStackTrace();
        }
        finally {
            map.put("result", result);
        }
        return map;
    }
}

