/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.portal.entity.PfStuffConfig;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfStuffConfigService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/stuff"})
public class StuffConfigController
extends BaseController {
    @Autowired
    PfStuffConfigService stuffConfigService;
    @Autowired
    NodeService nodeService;
    @Resource
    @Qualifier(value="boolListNumber")
    List<PublicVo> boolListNumber;
    @Resource
    @Qualifier(value="meterialList")
    List<PublicVo> meterialList;

    @RequestMapping(value={""})
    public String manage(Model model, @RequestParam(value="wfdId", required=true) String wfdId) {
        model.addAttribute("meterialList", (Object)this.meterialList);
        model.addAttribute("wfdId", (Object)wfdId);
        return "/config/stuff/stuff-tree";
    }

    @RequestMapping(value={"list"})
    public String list(Model model, @RequestParam(value="wfdId", required=true) String wfdId) {
        model.addAttribute("meterialList", (Object)this.meterialList);
        ArrayList stuffList = this.stuffConfigService.getListByWfdId(wfdId);
        if (stuffList == null) {
            stuffList = new ArrayList();
        }
        model.addAttribute("stuffList", stuffList);
        model.addAttribute("wfdId", (Object)wfdId);
        return "/config/stuff/stuff-list";
    }

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object stuffjson(Model model, @RequestParam(value="wfdId", required=true) String wfdId) {
        Ztree ztree = this.stuffConfigService.getZtreeByWfdId(wfdId);
        return ztree;
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public PfStuffConfig getWorkflowDefinition(@RequestParam(value="keyId", required=false) String keyId) {
        PfStuffConfig stuffConfig = (PfStuffConfig)this.stuffConfigService.findById((Object)keyId);
        return stuffConfig == null ? new PfStuffConfig() : stuffConfig;
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="stuffConfig") PfStuffConfig stuffConfig, @RequestParam(value="wfdId", required=false) String wfdId, Model model) {
        PfStuffConfig tmpStuff;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)stuffConfig.getStuffId())) {
            stuffConfig.setStuffId(UUIDGenerator.generate18());
        }
        if ((tmpStuff = (PfStuffConfig)this.stuffConfigService.findById((Object)stuffConfig.getStuffId())) == null) {
            this.stuffConfigService.insert((Object)stuffConfig);
            result.put("insert", true);
        } else {
            this.stuffConfigService.update((Object)stuffConfig);
        }
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("stuffConfig", stuffConfig);
        return result;
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public Object del(@RequestParam(value="keyId", required=false) String keyId) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)keyId)) {
                this.stuffConfigService.deleteStuffAndChildById(keyId);
                return this.handlerSuccessJson();
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"checkFile"})
    @ResponseBody
    public String checkFile(String proid, String fileName) throws Exception {
        String message = "";
        if (StringUtils.isNotBlank((String)proid) && StringUtils.isNotBlank((String)fileName)) {
            Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
            Node node = this.nodeService.getNode(space.getId(), proid, true);
            fileName = URLDecoder.decode(fileName, "UTF-8");
            String[] fileAry = StringUtils.split((String)fileName, (String)";");
            for (int i = 0; i < fileAry.length; ++i) {
                Node fileNode = this.nodeService.getNode(node.getId(), fileAry[i], true);
                List nodeList = this.nodeService.getAllChildNodes(fileNode.getId());
                if (!CollectionUtils.isEmpty((Collection)nodeList)) continue;
                message = message + "\u3010" + fileAry[i] + "\u3011";
            }
        }
        if (StringUtils.isNotBlank((String)message)) {
            message = "\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u6587\u4ef6\u662f\u5426\u4e0a\u4f20\uff1a" + message;
            message = URLEncoder.encode(message, "UTF-8");
        }
        return message;
    }
}

