/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import com.gtis.config.AppConfig;
import com.gtis.portal.model.FjStoreInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/showFileStore"})
public class ShowFileStoreController {
    private final Logger log = LoggerFactory.getLogger(ShowFileStoreController.class);
    private List<FjStoreInfo> fjStoreInfoList;

    @RequestMapping(value={""})
    public String showFileStore(Model model) {
        this.getFjStoreInfoList();
        model.addAttribute("fjStoreInfoList", (Object)this.fjStoreInfoList);
        return "config/show-fileCenter-fileStore";
    }

    @RequestMapping(value={"/getShowFileStorePagesJson"})
    @ResponseBody
    public Object getShowFileStorePagesJson(Pageable pageable, String name, String host, @RequestParam(value="number", required=false) String number, @RequestParam(value="currentPage", required=false) String currentPage) {
        int pageNumber = pageable.getPageNumber();
        if (currentPage != null) {
            pageNumber = Integer.parseInt(currentPage) - 1;
        }
        QPageRequest pageable1 = new QPageRequest(pageNumber, 10);
        name = StringUtils.trim((String)name);
        host = StringUtils.trim((String)host);
        List<FjStoreInfo> fjStoreInfoListTemp = new ArrayList();
        this.getFjStoreInfoList();
        if (CollectionUtils.isNotEmpty((Collection)this.fjStoreInfoList)) {
            if (StringUtils.isNotBlank((String)name) && StringUtils.isNotBlank((String)host)) {
                for (FjStoreInfo fjStoreInfo : this.fjStoreInfoList) {
                    if (!StringUtils.equals((String)fjStoreInfo.getName(), (String)name) || !StringUtils.equals((String)fjStoreInfo.getHost(), (String)host)) continue;
                    fjStoreInfoListTemp.add(fjStoreInfo);
                }
            } else if (StringUtils.isNotBlank((String)name)) {
                for (FjStoreInfo fjStoreInfo : this.fjStoreInfoList) {
                    if (!StringUtils.equals((String)fjStoreInfo.getName(), (String)name)) continue;
                    fjStoreInfoListTemp.add(fjStoreInfo);
                }
            } else if (StringUtils.isNotBlank((String)host)) {
                for (FjStoreInfo fjStoreInfo : this.fjStoreInfoList) {
                    if (!StringUtils.equals((String)fjStoreInfo.getHost(), (String)host)) continue;
                    fjStoreInfoListTemp.add(fjStoreInfo);
                }
            } else {
                fjStoreInfoListTemp = this.fjStoreInfoList;
            }
        }
        PageImpl FjStoreInfoPage = new PageImpl(fjStoreInfoListTemp, (Pageable)pageable1, (long)fjStoreInfoListTemp.size());
        cn.gtmap.estateplat.core.support.mybatis.page.model.PageImpl FjStoreInfoPage1 = null;
        if (FjStoreInfoPage != null) {
            FjStoreInfoPage1 = new cn.gtmap.estateplat.core.support.mybatis.page.model.PageImpl((Collection)FjStoreInfoPage.getContent(), pageNumber + 1, Integer.parseInt(FjStoreInfoPage.getTotalElements() + ""), 10);
        }
        return FjStoreInfoPage1;
    }

    private void getFjStoreInfoList() {
        this.fjStoreInfoList = new ArrayList();
        String nameVal = AppConfig.getProperty((String)"fileCenter.showStoreInfo.names");
        String hostVal = AppConfig.getProperty((String)"fileCenter.showStoreInfo.values");
        if (StringUtils.isNotBlank((String)nameVal) && StringUtils.isNotBlank((String)hostVal)) {
            String[] hostSplit;
            String[] nameSplit = nameVal.split(",");
            if (nameSplit.length == (hostSplit = hostVal.split(",")).length) {
                for (int i = 0; i < hostSplit.length; ++i) {
                    String[] hostSplit1 = hostSplit[i].split("&");
                    FjStoreInfo fjStoreInfo = new FjStoreInfo();
                    if (hostSplit1.length == 4) {
                        fjStoreInfo.setName(nameSplit[i]);
                        fjStoreInfo.setHost(hostSplit1[0]);
                        fjStoreInfo.setLoginName(hostSplit1[1]);
                        fjStoreInfo.setPassWord(hostSplit1[2]);
                        fjStoreInfo.setPath(hostSplit1[3].substring(0, 2));
                        this.fjStoreInfoList.add(fjStoreInfo);
                        continue;
                    }
                    if (hostSplit1.length == 2) {
                        fjStoreInfo.setName(nameSplit[i]);
                        fjStoreInfo.setHost(hostSplit1[0]);
                        fjStoreInfo.setPath(hostSplit1[1].substring(0, 2));
                        this.fjStoreInfoList.add(fjStoreInfo);
                        continue;
                    }
                    this.log.error("portal\u914d\u7f6efileCenter\u7684host\u9519\u8bef");
                }
            } else {
                this.log.error("portal\u914d\u7f6efileCenter\u7684storeInfo\u9519\u8bef");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)this.fjStoreInfoList)) {
            this.fjStoreInfoList = this.getFjStoreInfoFromList(this.fjStoreInfoList);
        }
    }

    private List<FjStoreInfo> getFjStoreInfoFromList(List<FjStoreInfo> fjStoreInfoList) {
        ArrayList<FjStoreInfo> fjStoreInfos = new ArrayList<FjStoreInfo>();
        for (FjStoreInfo fjStoreInfo : fjStoreInfoList) {
            FjStoreInfo diskInfo = null;
            diskInfo = StringUtils.isNotBlank((String)fjStoreInfo.getLoginName()) && StringUtils.isNotBlank((String)fjStoreInfo.getPassWord()) ? this.getRemoteDiskInfo(fjStoreInfo) : this.getLocalDiskInfo(fjStoreInfo);
            if (diskInfo == null) continue;
            fjStoreInfos.add(diskInfo);
        }
        return fjStoreInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FjStoreInfo getLocalDiskInfo(FjStoreInfo fjStoreInfo) {
        long totalSpace = 0L;
        long freeSpace = 0L;
        long usedSpace = 0L;
        try {
            Process process = Runtime.getRuntime().exec("cmd.exe /c wmic LogicalDisk where \"Caption='" + fjStoreInfo.getPath() + "'\" get FreeSpace,Size /value");
            StreamGobbler stdout = new StreamGobbler(process.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stdout, Charset.forName("GBK")));
            String len = null;
            while ((len = br.readLine()) != null) {
                String[] str;
                if (len.startsWith("FreeSpace")) {
                    str = len.split("=");
                    freeSpace = Long.parseLong(str[1]) / 1024L / 1024L;
                }
                if (!len.startsWith("Size")) continue;
                str = len.split("=");
                totalSpace = Long.parseLong(str[1]) / 1024L / 1024L;
            }
            usedSpace = totalSpace - freeSpace;
            this.log.info("\u603b\u7a7a\u95f4\u5927\u5c0f : " + totalSpace + "M");
            this.log.info("\u5269\u4f59\u7a7a\u95f4\u5927\u5c0f : " + freeSpace + "M");
            this.log.info("\u5df2\u7528\u7a7a\u95f4\u5927\u5c0f : " + usedSpace + "M");
            fjStoreInfo.setMaxCapacity(totalSpace + "M");
            fjStoreInfo.setUsedCapacity(usedSpace + "M");
            fjStoreInfo.setProportion((int)(usedSpace * 100L / totalSpace) + "%");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            fjStoreInfo.setLoginName("***");
            fjStoreInfo.setPassWord("***");
        }
        return fjStoreInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FjStoreInfo getRemoteDiskInfo(FjStoreInfo fjStoreInfo) {
        HashMap map = new HashMap();
        Connection conn = new Connection(fjStoreInfo.getHost(), 22);
        Session ssh = null;
        try {
            conn.connect();
            boolean flag = conn.authenticateWithPassword(fjStoreInfo.getLoginName(), fjStoreInfo.getPassWord());
            if (!flag) {
                System.out.println("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            } else {
                this.log.info("\u8fde\u63a5\u6210\u529f");
                ssh = conn.openSession();
                map = this.getWindowsServerDiskInfo(ssh, map, fjStoreInfo.getPath());
                fjStoreInfo.setMaxCapacity(map.get("total") + "M");
                fjStoreInfo.setUsedCapacity(map.get("used") + "M");
                fjStoreInfo.setProportion((int)((Long)map.get("used") * 100L / (Long)map.get("total")) + "%");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            fjStoreInfo.setLoginName("***");
            fjStoreInfo.setPassWord("***");
            try {
                if (ssh != null) {
                    ssh.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fjStoreInfo;
    }

    private HashMap<String, Long> getWindowsServerDiskInfo(Session ssh, HashMap<String, Long> map, String diskPath) throws IOException {
        long totalSpace = 0L;
        long freeSpace = 0L;
        long usedSpace = 0L;
        ssh.execCommand("cmd.exe /c wmic LogicalDisk where \"Caption='" + diskPath + "'\" get FreeSpace,Size /value");
        StreamGobbler stdout = new StreamGobbler(ssh.getStdout());
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stdout, Charset.forName("GBK")));
        String len = null;
        while ((len = br.readLine()) != null) {
            String[] str;
            if (len.startsWith("FreeSpace")) {
                str = len.split("=");
                freeSpace = Long.parseLong(str[1]) / 1024L / 1024L;
            }
            if (!len.startsWith("Size")) continue;
            str = len.split("=");
            totalSpace = Long.parseLong(str[1]) / 1024L / 1024L;
        }
        usedSpace = totalSpace - freeSpace;
        this.log.info("\u603b\u7a7a\u95f4\u5927\u5c0f : " + totalSpace + "M");
        this.log.info("\u5269\u4f59\u7a7a\u95f4\u5927\u5c0f : " + freeSpace + "M");
        this.log.info("\u5df2\u7528\u7a7a\u95f4\u5927\u5c0f : " + usedSpace + "M");
        map.put("total", totalSpace);
        map.put("free", freeSpace);
        map.put("used", usedSpace);
        return map;
    }
}

