/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.portal.entity.PfResource;
import com.gtis.portal.entity.PfResourceGroup;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfResourceGroupService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.util.CommonUtils;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/resource"})
public class ResourceController
extends BaseController {
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfResourceGroupService groupService;
    @Autowired
    PfUserService pfUserService;
    @Resource
    @Qualifier(value="zylxList")
    List<PublicVo> zylxList;
    @Resource
    @Qualifier(value="zyjzmsList")
    List<PublicVo> zyjzmsList;

    @RequestMapping(value={""})
    public String manage(Model model) {
        model.addAttribute("zylxList", (Object)this.zylxList);
        model.addAttribute("zyjzmsList", (Object)this.zyjzmsList);
        return "/config/resource/manage";
    }

    @RequestMapping(value={"select"})
    public String select(Model model, @RequestParam(value="foreignId", required=true) String foreignId, String paramString) {
        model.addAttribute("foreignId", (Object)foreignId);
        model.addAttribute("paramString", (Object)paramString);
        return "/config/resource/resource-select";
    }

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object resourcejson(Model model, @RequestParam(value="hascheck", required=false) String hascheck) {
        Ztree ztree = this.resourceService.getAllResourceTree(hascheck);
        return ztree;
    }

    @RequestMapping(value={"open"})
    @ResponseBody
    public PfResource openMenu(@RequestParam String link) {
        if (link.startsWith("r:")) {
            return this.handleResourceUrl((PfResource)this.resourceService.findById((Object)link.replace("r:", "")));
        }
        return this.handleResourceUrl((PfResource)this.resourceService.findById((Object)link));
    }

    private PfResource handleResourceUrl(PfResource pfResource) {
        if (pfResource != null) {
            String url;
            if (StringUtils.isNotBlank((String)pfResource.getResourceUrl())) {
                pfResource.setResourceUrl(RequestUtils.initOptProperties((String)pfResource.getResourceUrl()));
            }
            if (!(StringUtils.startsWith((String)(url = pfResource.getResourceUrl()), (String)"$") || StringUtils.startsWith((String)url, (String)"http") || StringUtils.startsWith((String)url, (String)"/"))) {
                url = AppConfig.getPlatFormUrl() + "/" + url;
            }
            if (StringUtils.contains((String)(url = StringUtils.indexOf((String)url, (String)"?") > 0 ? url + "&" : url + "?"), (String)"${")) {
                HashMap userParam = CommonUtils.initCurUserUrlMap((PfUserService)this.pfUserService);
                url = CommonUtils.freemarkerProcess((Map)userParam, (String)url);
            }
            pfResource.setResourceUrl(url);
        }
        return pfResource;
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public PfResource getResource(@RequestParam(value="resourceId", required=false) String resourceId) {
        PfResource resource = this.resourceService.getResourceHasBs(resourceId);
        return resource == null ? new PfResource() : resource;
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="resource") PfResource resource, Model model) {
        PfResource tmpResource;
        if (StringUtils.isBlank((String)resource.getResourceId())) {
            resource.setResourceId(UUIDGenerator.generate18());
        }
        if ((tmpResource = this.resourceService.getResourceHasBs(resource.getResourceId())) != null) {
            this.resourceService.update((Object)resource);
        } else {
            this.resourceService.insert((Object)resource);
        }
        resource = this.resourceService.getResourceHasBs(resource.getResourceId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("resource", resource);
        return result;
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public Object del(@RequestParam(value="keyId", required=false) String keyId) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)keyId)) {
                this.resourceService.deleteById((Object)keyId);
                return this.handlerSuccessJson();
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"infoGroup"})
    @ResponseBody
    public PfResourceGroup getGroup(@RequestParam(value="groupId", required=false) String groupId) {
        PfResourceGroup group = this.groupService.getGroupHasBs(groupId);
        return group == null ? new PfResourceGroup() : group;
    }

    @RequestMapping(value={"saveGroup"})
    @ResponseBody
    public Object saveGroup(HttpServletRequest req, @ModelAttribute(value="group") PfResourceGroup group, Model model) {
        PfResourceGroup tmpGroup;
        if (StringUtils.isBlank((String)group.getGroupId())) {
            group.setGroupId(UUIDGenerator.generate18());
        }
        if ((tmpGroup = this.groupService.getGroupHasBs(group.getGroupId())) != null) {
            this.groupService.update((Object)group);
        } else {
            this.groupService.insert((Object)group);
        }
        group = this.groupService.getGroupHasBs(group.getGroupId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("group", group);
        return result;
    }

    @RequestMapping(value={"delGroup"})
    @ResponseBody
    public Object delGroup(@RequestParam(value="keyId", required=false) String keyId, @RequestParam(value="delResource", required=false) String delResource) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)keyId)) {
                this.groupService.deleteGroup(keyId, StringUtils.equalsIgnoreCase((String)"true", (String)delResource));
                return this.handlerSuccessJson();
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlerSuccessJson();
    }
}

