/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.portal.entity.PfWorkFlowEvent;
import com.gtis.portal.service.server.PfWorkFlowEventConfigurationService;
import com.gtis.portal.web.BaseController;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/workFlowEvent"})
public class WorkFlowEventController
extends BaseController {
    @Autowired
    PfWorkFlowEventConfigurationService pfWorkFlowEventConfigurationService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    private static final int PAGE_SIZE = 10;

    @RequestMapping(value={"/list"})
    public String list(Model model) {
        List businessVoList = this.sysWorkFlowDefineService.getBusinessList();
        model.addAttribute("businessList", (Object)(businessVoList != null ? businessVoList : Lists.newArrayList()));
        return "workFlowEvent-list";
    }

    @ResponseBody
    @RequestMapping(value={"/initEventList"})
    public Object initWorkFlowEventList(String id, String workflowDefinitionId, String dcxc, Pageable page) {
        Page pfWorkFlowEventPage = null;
        int size = page == null ? 10 : page.getPageSize();
        int pagenum = page == null ? 1 : page.getPageNumber();
        JSONObject json = new JSONObject();
        try {
            page = new PageRequest(pagenum, size, Sort.Direction.DESC, new String[]{"id"});
            String workFlowName = null;
            if (StringUtils.isNotBlank((String)dcxc)) {
                workFlowName = dcxc;
            }
            if ((pfWorkFlowEventPage = this.pfWorkFlowEventConfigurationService.listPfWorkFlowEventPage(workflowDefinitionId, workFlowName, page)) == null) {
                return null;
            }
            json.put("rows", (Object)pfWorkFlowEventPage.getContent());
            json.put("total", (Object)pfWorkFlowEventPage.getTotalPages());
            json.put("records", (Object)pfWorkFlowEventPage.getTotalElements());
            json.put("page", (Object)(pfWorkFlowEventPage.getNumber() + 1));
            json.put("pageSize", (Object)pfWorkFlowEventPage.getSize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    @ResponseBody
    @RequestMapping(value={"/addWorkFlowEvent"})
    public Object addWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        boolean result = Boolean.TRUE;
        try {
            if (pfWorkFlowEvent == null) {
                result = Boolean.FALSE;
                return result;
            }
            this.pfWorkFlowEventConfigurationService.addPfWorkFlowEvent(pfWorkFlowEvent);
        }
        catch (Exception e) {
            result = Boolean.FALSE;
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/modifyWorkFlowEvent"})
    public Object modifyWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        boolean result = Boolean.TRUE;
        try {
            if (pfWorkFlowEvent == null) {
                result = Boolean.FALSE;
                return result;
            }
            this.pfWorkFlowEventConfigurationService.updatePfWorkFlowEvent(pfWorkFlowEvent);
        }
        catch (Exception e) {
            result = Boolean.FALSE;
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/deleteWorkFlowEvent"})
    public Object deleteWorkFlowEvent(String id) {
        boolean result = Boolean.TRUE;
        try {
            if (StringUtils.isBlank((String)id)) {
                result = Boolean.FALSE;
                return result;
            }
            this.pfWorkFlowEventConfigurationService.deletePfWorkFlowEventById(id.split(","));
        }
        catch (Exception e) {
            result = Boolean.FALSE;
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/getWorkFlowEvent"})
    public Object getWorkFlowEvent(String id) {
        HashMap maps = Maps.newHashMap();
        PfWorkFlowEvent pfWorkFlowEvent = null;
        String businessId = "";
        String businessName = "";
        try {
            PfBusinessVo pfBusinessVo;
            PfWorkFlowDefineVo pfWorkFlowDefineVo;
            if (StringUtils.isNotBlank((String)id) && (pfWorkFlowEvent = this.pfWorkFlowEventConfigurationService.getPfWorkFlowEvent(id)) != null && (pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(pfWorkFlowEvent.getWorkFlowDefinitionId())) != null && (pfBusinessVo = this.sysWorkFlowDefineService.getBusiness(businessId = pfWorkFlowDefineVo.getBusinessId())) != null) {
                businessName = pfBusinessVo.getBusinessName();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pfWorkFlowEvent == null) {
            pfWorkFlowEvent = new PfWorkFlowEvent();
        }
        maps.put("pfWorkFlowEvent", pfWorkFlowEvent);
        maps.put("businessId", businessId);
        maps.put("businessName", businessName);
        return maps;
    }

    @ResponseBody
    @RequestMapping(value={"/importWorkFlowEvent"})
    public Object importWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        return this.pfWorkFlowEventConfigurationService.importPfWorkFlowEvent(pfWorkFlowEvent);
    }

    @ResponseBody
    @RequestMapping(value={"/cleanWorkFlowEvent"})
    public Object cleanWorkFlowEvent(PfWorkFlowEvent pfWorkFlowEvent) {
        return this.pfWorkFlowEventConfigurationService.cleanWorkFlowEvent(pfWorkFlowEvent);
    }

    @ResponseBody
    @RequestMapping(value={"/batchImportPfWorkFlowEvent"})
    public Object batchImportPfWorkFlowEvent() {
        return this.pfWorkFlowEventConfigurationService.batchImportPfWorkFlowEvent();
    }
}

