/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.portal.model.Menu;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/taskOverHandle"})
public class TaskOverHandleController {
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    SysAuthorService sysAuthorService;
    @Autowired
    SysActivityService sysActivityService;

    @RequestMapping(value={""})
    public String taskHandle(Model model, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="rid", required=false) String rid) throws Exception {
        String fileTokenId = "";
        int fileCenterNodeId = 0;
        String defaultName = "";
        String busiType = "";
        String readOnly = "";
        String userid = SessionUtil.getCurrentUserId();
        boolean canDelOthers = false;
        int menuCount = 0;
        PfWorkFlowInstanceVo workFlowInstanceVo = null;
        ArrayList<Menu> menuList = null;
        if (StringUtils.isBlank((String)rid)) {
            rid = "";
        }
        model.addAttribute("rid", (Object)rid);
        if (StringUtils.isNotBlank((String)rid) && rid.startsWith("r:")) {
            rid = rid.replace("r:", "");
        }
        boolean showToolBar = AppConfig.getBooleanProperty((String)"report.showtoolbar.enable", (boolean)false);
        boolean disable = AppConfig.getBooleanProperty((String)"taskOverList.handle.url.param.disable.enable", (boolean)true);
        if (StringUtils.isNotBlank((String)taskid)) {
            List resourceNodeList;
            Document document;
            PfTaskVo taskVo = this.taskService.getHistoryTask(taskid);
            PfActivityVo activityVo = this.taskService.getActivity(taskVo.getActivityId());
            workFlowInstanceVo = this.workFlowIntanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
            PfWorkFlowDefineVo workFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
            Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
            try {
                Node node = this.nodeService.getNode(space.getId(), activityVo.getWorkflowInstanceId(), false);
                if (node != null) {
                    fileTokenId = this.nodeService.getToken(node);
                    fileCenterNodeId = node.getId();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel((PfWorkFlowDefineVo)workFlowDefineVo);
            busiType = xmlDao.getExtendedAttribute("BusiType") + "";
            if (StringUtils.isBlank((String)busiType)) {
                busiType = xmlDao.getExtendedAttribute("busiType") + "";
            }
            WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)workFlowInstanceVo);
            ActivityModel aModel = xmlModel.getActivity(activityVo.getActivityDefinitionId());
            defaultName = aModel.getExtendedAttribute("DefaultName");
            String menuXml = aModel.getResources();
            String menuname = AppConfig.getProperty((String)"show.report.showtoolbar.menuname");
            String hideMenuname = AppConfig.getProperty((String)"hide.resource.menuname");
            if (StringUtils.isNotBlank((String)menuXml) && (document = DocumentHelper.parseText((String)(menuXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + menuXml))) != null && (resourceNodeList = document.selectNodes("//Resources/Resource")) != null) {
                menuList = new ArrayList();
                for (int i = 0; i < resourceNodeList.size(); ++i) {
                    boolean showToolBarBol = showToolBar;
                    Element resourceEl = (Element)resourceNodeList.get(i);
                    Menu menu = new Menu();
                    menu.setId(resourceEl.attributeValue("Id"));
                    menu.setText(resourceEl.attributeValue("Name"));
                    if (StringUtils.indexOf((String)menuname, (String)resourceEl.attributeValue("Name")) > -1) {
                        showToolBarBol = true;
                    }
                    String firstLink = "/SysResource.action?disable=" + disable + "&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + resourceEl.attributeValue("Id") + "&userid=" + userid + "&isProjectList=true&__showtoolbar__=" + showToolBarBol;
                    List childrenNodeList1 = document.getRootElement().selectNodes("//Resources/Resource[@Id='" + resourceEl.attributeValue("Id") + "']/Resource");
                    if (childrenNodeList1 != null && childrenNodeList1.size() > 0) {
                        Element childEl1 = (Element)childrenNodeList1.get(0);
                        firstLink = "/SysResource.action?disable=" + disable + "&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl1.attributeValue("Id") + "&userid=" + userid + "&isProjectList=true&__showtoolbar__=" + showToolBarBol;
                    }
                    menu.setLink(firstLink);
                    List childrenNodeList = resourceEl.selectNodes("//Resources/Resource[@Id='" + resourceEl.attributeValue("Id") + "']/Resource");
                    if (childrenNodeList != null && childrenNodeList.size() > 0) {
                        ArrayList<Menu> childMenuList = new ArrayList<Menu>();
                        for (int j = 1; j < childrenNodeList.size(); ++j) {
                            Menu childMenu = new Menu();
                            Element childEl = (Element)childrenNodeList.get(j);
                            childMenu.setId(childEl.attributeValue("Id"));
                            childMenu.setText(childEl.attributeValue("Name"));
                            String firstChildLink = "/SysResource.action?disable=" + disable + "&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl.attributeValue("Id") + "&isProjectList=true&__showtoolbar__=" + showToolBar;
                            List childChildNodeList = resourceEl.selectNodes("//Resources/Resource[@Id='" + resourceEl.attributeValue("Id") + "']/Resource[@Id='" + childEl.attributeValue("Id") + "']/Resource");
                            if (childChildNodeList != null && childChildNodeList.size() > 0) {
                                Element childEl1 = (Element)childChildNodeList.get(0);
                                firstChildLink = "/SysResource.action?disable=" + disable + "&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childEl1.attributeValue("Id") + "&isProjectList=true&__showtoolbar__=" + showToolBar;
                            }
                            childMenu.setLink(firstChildLink);
                            if (childChildNodeList != null && childChildNodeList.size() > 0) {
                                ArrayList<Menu> childChildMenuList = new ArrayList<Menu>();
                                for (int k = 1; k < childChildNodeList.size(); ++k) {
                                    Menu childChildMenu = new Menu();
                                    Element childChildEl = (Element)childChildNodeList.get(k);
                                    childChildMenu.setId(childChildEl.attributeValue("Id"));
                                    childChildMenu.setText(childChildEl.attributeValue("Name"));
                                    childChildMenu.setLink("/SysResource.action?disable=" + disable + "&taskid=" + taskid + "&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + workFlowInstanceVo.getWorkflowIntanceId() + "&rid=" + childChildEl.attributeValue("Id") + "&isProjectList=true&__showtoolbar__=" + showToolBar);
                                    childChildMenuList.add(childChildMenu);
                                }
                                childMenu.setChildren(childChildMenuList);
                            }
                            childMenuList.add(childMenu);
                        }
                        menu.setChildren(childMenuList);
                        menu.setExpanded(true);
                    }
                    if (!StringUtils.isBlank((String)hideMenuname) && StringUtils.indexOf((String)hideMenuname, (String)menu.getText()) >= 0) continue;
                    menuList.add(menu);
                }
            }
        }
        if (workFlowInstanceVo == null) {
            workFlowInstanceVo = new PfWorkFlowInstanceVo();
        }
        if (menuList == null) {
            menuList = new ArrayList<Menu>();
        }
        boolean hasGetBack = false;
        if (SessionUtil.getCurrentUser().isAdmin()) {
            hasGetBack = true;
        } else {
            List pfTaskVoList;
            String acitivityName;
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List lstfPartitions = this.sysAuthorService.getSystemResrouceFunAuthorList(roles, rid);
            if (lstfPartitions != null) {
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (!partitionInfoVo.getElementName().endsWith("\u53d6\u56de") && !partitionInfoVo.getElementName().equalsIgnoreCase("resGetBack")) continue;
                    hasGetBack = true;
                    break;
                }
            }
            if (StringUtils.isNotBlank((String)(acitivityName = AppConfig.getProperty((String)"hide.getBack.btn.activityName"))) && CollectionUtils.isNotEmpty((Collection)(pfTaskVoList = this.taskService.getTaskListByInstance(workFlowInstanceVo.getWorkflowIntanceId())))) {
                for (PfTaskVo pfTaskVo : pfTaskVoList) {
                    PfActivityVo pfActivityVo;
                    if (!StringUtils.isNotBlank((String)pfTaskVo.getActivityId()) || (pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId())) == null || StringUtils.indexOf((String)acitivityName, (String)pfActivityVo.getActivityName()) <= -1) continue;
                    hasGetBack = false;
                    break;
                }
            }
        }
        boolean tabControlEnable = AppConfig.getBooleanProperty((String)"taskhandle.tab.control.enable", (boolean)false);
        UserInfo userInfo = SessionUtil.getCurrentUser();
        model.addAttribute("username", (Object)userInfo.getUsername());
        model.addAttribute("userid", (Object)userInfo.getId());
        model.addAttribute("fileTokenId", (Object)fileTokenId);
        model.addAttribute("fileCenterNodeId", (Object)fileCenterNodeId);
        model.addAttribute("defaultName", (Object)defaultName);
        model.addAttribute("busiType", (Object)busiType);
        model.addAttribute("readOnly", (Object)readOnly);
        model.addAttribute("canDelOthers", (Object)canDelOthers);
        model.addAttribute("workFlowInstanceVo", (Object)workFlowInstanceVo);
        model.addAttribute("taskid", (Object)taskid);
        model.addAttribute("menuCount", (Object)menuCount);
        model.addAttribute("menuList", menuList);
        model.addAttribute("hasFileBrowse", (Object)AppConfig.getBooleanProperty((String)"file.browse.enable", (boolean)false));
        model.addAttribute("hasGetBack", (Object)hasGetBack);
        model.addAttribute("tabControlEnable", (Object)tabControlEnable);
        if (tabControlEnable) {
            return "task-overHandle-tab-control";
        }
        return "task-overHandle";
    }
}

