/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import cn.gtmap.estateplat.utils.CommonUtil;
import com.google.common.collect.Maps;
import com.gtis.common.Page;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SplitDataService;
import com.gtis.plat.service.SysUserService;
import com.gtis.portal.model.RssContent;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taskCenterRss"})
public class TaskCenterRssController {
    @Autowired
    SysUserService sysUserService;
    @Autowired
    @Qualifier(value="platformSplitDataService")
    private SplitDataService splitDataService;

    @RequestMapping(value={"/rss"}, method={RequestMethod.GET})
    public ModelAndView getFeedInRss() throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        String loginName = "";
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            loginName = this.sysUserService.getUserVo(userId).getLoginName();
        }
        ArrayList<RssContent> items = new ArrayList<RssContent>();
        HashMap mapParam = Maps.newHashMap();
        mapParam.put("userIds", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds());
        Page page = this.splitDataService.query("getTaskList", (Object)mapParam, 0, 10);
        if (page != null && CollectionUtils.isNotEmpty((Collection)page.getItems())) {
            for (Object obj : page.getItems()) {
                Map map1 = (Map)obj;
                RssContent rss = new RssContent();
                rss.setDescription("\u4e1a\u52a1\u540d\u79f0\uff1a" + CommonUtil.formatEmptyValue(map1.get("WORKFLOW_NAME")) + "\n\u63cf\u8ff0\uff1a" + CommonUtil.formatEmptyValue(map1.get("REMARK")).replaceAll("\\$", "\n"));
                rss.setPubDate((Date)map1.get("CREATE_TIME"));
                rss.setTitle(CommonUtil.formatEmptyValue(map1.get("WORKFLOW_INSTANCE_NAME")));
                rss.setUrl(AppConfig.getProperty((String)"cas.url") + "/calogin?username=" + loginName + "&url=" + AppConfig.getProperty((String)"portal.url") + "/taskHandle%3Ftaskid=" + CommonUtil.formatEmptyValue(map1.get("ASSIGNMENT_ID")));
                items.add(rss);
            }
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("rssViewer");
        mav.addObject("feedContent", items);
        return mav;
    }
}

