/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.portal.service.MsgReminderProvider;
import com.gtis.portal.service.MsgReminderService;
import com.gtis.portal.web.BaseController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reminder"})
public class ReminderController
extends BaseController {
    private static final Log log = LogFactory.getLog(ReminderController.class);
    @Autowired
    MsgReminderService msgReminderService;
    @Resource(name="fyReminderService")
    MsgReminderProvider fyReminderService;
    @Autowired
    SysUserService sysUserService;

    @ResponseBody
    @RequestMapping(value={""})
    public Object reminder() throws Exception {
        ArrayList reminderList = Lists.newArrayList();
        List msgReminderList = this.msgReminderService.getAllMsgReminder();
        if (CollectionUtils.isNotEmpty((Collection)msgReminderList)) {
            for (Map map : msgReminderList) {
                if (map.get("count") == null || (Integer)map.get("count") == 0) continue;
                HashMap reminderMap = Maps.newHashMap();
                reminderMap.put("name", map.get("name"));
                reminderMap.put("count", map.get("count"));
                reminderMap.put("moreUrl", map.get("moreUrl"));
                reminderList.add(reminderMap);
            }
        }
        return reminderList;
    }

    @ResponseBody
    @RequestMapping(value={"fyReminder"})
    public Object fyReminder(String userId) throws Exception {
        boolean reminderBool = false;
        if (StringUtils.isNotBlank((String)userId)) {
            List pfRoleVos = this.sysUserService.getRoleListByUser(userId);
            String fyRoles = AppConfig.getProperty((String)"fyReminder.roleIds");
            if (StringUtils.isNotBlank((String)fyRoles)) {
                for (PfRoleVo pfRoleVo : pfRoleVos) {
                    if (StringUtils.indexOf((String)fyRoles, (String)pfRoleVo.getRoleId()) <= -1) continue;
                    reminderBool = true;
                }
            }
        }
        HashMap reminderMap = Maps.newHashMap();
        reminderMap.put("name", this.fyReminderService.getName());
        int count = 0;
        if (reminderBool) {
            count = this.fyReminderService.getCount();
        }
        reminderMap.put("count", count);
        reminderMap.put("moreUrl", this.fyReminderService.getMoreUrl());
        return reminderMap;
    }

    @ResponseBody
    @RequestMapping(value={"test"})
    public Object test(String userId) throws Exception {
        String count = "1";
        return count;
    }
}

