/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfResourceVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.model.Menu;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/projectHandle"})
public class ProjectHandleController {
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    SysMenuService menuService;
    @Autowired
    SysAuthorService sysAuthorService;

    @RequestMapping(value={""})
    public String taskHandle(Model model, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="rid", required=false) String rid, @RequestParam(value="proid", required=false) String proid, @RequestParam(value="wdno", required=false) String wdno) throws Exception {
        if (StringUtils.isBlank((String)rid) || StringUtils.equals((String)rid, (String)"undefined")) {
            rid = "";
        }
        if (StringUtils.isNotBlank((String)rid) && rid.startsWith("r:")) {
            rid = rid.replace("r:", "");
        }
        String fileTokenId = "";
        int fileCenterNodeId = 0;
        String defaultName = "";
        String busiType = "";
        String readOnly = "";
        boolean disable = false;
        boolean hasPriority = false;
        hasPriority = this.hasPriorityVisible(rid);
        int menuCount = 0;
        PfWorkFlowDefineVo workFlowDefineVo = null;
        ArrayList<Menu> menuList = null;
        String userid = SessionUtil.getCurrentUserId();
        boolean showToolBar = AppConfig.getBooleanProperty((String)"report.showtoolbar.enable", (boolean)false);
        PfWorkFlowInstanceVo workFlowInstanceVo = wiid != null && !wiid.equals("") ? this.workFlowIntanceService.getWorkflowInstance(wiid) : this.workFlowIntanceService.getWorkflowInstanceByProId(proid);
        if (workFlowInstanceVo != null) {
            workFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
            wiid = workFlowInstanceVo.getWorkflowIntanceId();
        } else if (StringUtils.isNotBlank((String)wdno)) {
            workFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowByDefinitionNo(wdno);
        }
        if (workFlowDefineVo != null) {
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel((PfWorkFlowDefineVo)workFlowDefineVo);
            disable = xmlDao.isDisable();
            Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
            try {
                Node node = null;
                node = StringUtils.isBlank((String)wiid) ? this.nodeService.getNode(space.getId(), proid, true) : this.nodeService.getNode(space.getId(), wiid, false);
                if (node != null) {
                    fileTokenId = this.nodeService.getToken(node);
                    fileCenterNodeId = node.getId();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            disable = AppConfig.getBooleanProperty((String)"projectList.handle.url.param.disable.enable", (boolean)false);
            busiType = xmlDao.getExtendedAttribute("BusiType") + "";
            if (StringUtils.isBlank((String)busiType)) {
                busiType = xmlDao.getExtendedAttribute("busiType") + "";
            }
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            workFlowInstanceVo = wiid != null && !wiid.equals("") ? this.workFlowIntanceService.getWorkflowInstance(wiid) : this.workFlowIntanceService.getWorkflowInstanceByProId(proid);
            if (workFlowInstanceVo != null) {
                workFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
            } else if (StringUtils.isNotBlank((String)wdno)) {
                workFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowByDefinitionNo(wdno);
            }
            List lstResult = this.menuService.getProjectMenu(roles, workFlowDefineVo.getWorkflowDefinitionId());
            String hideMenuname = AppConfig.getProperty((String)"hide.resource.menuname");
            HashMap<String, String> insertedMenuMap = new HashMap<String, String>();
            String menuname = AppConfig.getProperty((String)"show.report.showtoolbar.menuname");
            if (lstResult != null) {
                menuList = new ArrayList();
                for (int i = 0; i < lstResult.size(); ++i) {
                    PfResourceVo menuVo = (PfResourceVo)lstResult.get(i);
                    String tempKey = menuVo.getResourceId() + "_" + menuVo.getResourceName();
                    if (insertedMenuMap.get(tempKey) != null) continue;
                    insertedMenuMap.put(tempKey, tempKey);
                    Menu menu = new Menu();
                    menu.setId(menuVo.getResourceId());
                    String name = menuVo.getResourceName();
                    menu.setText(name);
                    boolean showToolBarBol = showToolBar;
                    if (StringUtils.indexOf((String)menuname, (String)name) > -1) {
                        showToolBarBol = true;
                    }
                    if (disable) {
                        menu.setLink("/SysResource.action?from=pro&disable=true&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + wiid + "&rid=" + menuVo.getResourceId() + "&userid=" + userid + "&isProjectList=true&__showtoolbar__=" + showToolBarBol);
                    } else {
                        menu.setLink("/SysResource.action?proid=" + workFlowInstanceVo.getProId() + "&wiid=" + wiid + "&rid=" + menuVo.getResourceId() + "&userid=" + userid + "&isProjectList=true&__showtoolbar__=" + showToolBarBol);
                    }
                    if (!StringUtils.isBlank((String)hideMenuname) && StringUtils.indexOf((String)hideMenuname, (String)menu.getText()) >= 0) continue;
                    menuList.add(menu);
                }
            }
        }
        if (workFlowInstanceVo == null) {
            workFlowInstanceVo = new PfWorkFlowInstanceVo();
        }
        if (menuList == null) {
            menuList = new ArrayList<Menu>();
        }
        boolean tabControlEnable = AppConfig.getBooleanProperty((String)"taskhandle.tab.control.enable", (boolean)false);
        UserInfo userInfo = SessionUtil.getCurrentUser();
        model.addAttribute("username", (Object)userInfo.getUsername());
        model.addAttribute("userid", (Object)userInfo.getId());
        model.addAttribute("fileTokenId", (Object)fileTokenId);
        model.addAttribute("fileCenterNodeId", (Object)fileCenterNodeId);
        model.addAttribute("defaultName", (Object)defaultName);
        model.addAttribute("busiType", (Object)busiType);
        model.addAttribute("readOnly", (Object)readOnly);
        model.addAttribute("workFlowInstanceVo", (Object)workFlowInstanceVo);
        model.addAttribute("menuCount", (Object)menuCount);
        model.addAttribute("menuList", menuList);
        model.addAttribute("hasFileBrowse", (Object)AppConfig.getBooleanProperty((String)"file.browse.enable", (boolean)false));
        model.addAttribute("hasPriority", (Object)hasPriority);
        model.addAttribute("tabControlEnable", (Object)tabControlEnable);
        if (tabControlEnable) {
            return "task-projectHandle-tab-control";
        }
        return "task-projectHandle";
    }

    private boolean hasPriorityVisible(String rid) {
        boolean hasPriority = false;
        if (SessionUtil.getCurrentUser().isAdmin()) {
            hasPriority = true;
        } else {
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List lstfPartitions = this.sysAuthorService.getSystemResrouceFunAuthorList(roles, rid);
            if (lstfPartitions != null) {
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (!partitionInfoVo.getElementName().endsWith("\u4f18\u5148") && !partitionInfoVo.getElementName().equalsIgnoreCase("priority")) continue;
                    hasPriority = true;
                    break;
                }
            }
        }
        return hasPriority;
    }

    @ResponseBody
    @RequestMapping(value={"/getActivityNames"})
    public Object getActivityNames(String wiid) {
        StringBuffer userNameBuffer = new StringBuffer();
        HashMap map = Maps.newHashMap();
        String activityName = "";
        String isOver = "false";
        if (StringUtils.isNotBlank((String)wiid)) {
            List activityVoList = this.taskService.getWorkFlowInstanceActivityList(wiid);
            for (int i = 0; i < activityVoList.size(); ++i) {
                if (i > 0) {
                    userNameBuffer.append(";");
                }
                try {
                    PfActivityVo activityVo = (PfActivityVo)activityVoList.get(i);
                    activityName = activityVo.getActivityName();
                    userNameBuffer.append(activityVo.getActivityName());
                    String noComputeActivityNames = AppConfig.getProperty((String)"overTime.noCompute.activityNames");
                    if (!StringUtils.isNotBlank((String)noComputeActivityNames)) continue;
                    List taskList = this.taskService.getTaskListByActivity(activityVo.getActivityId());
                    if (taskList != null && taskList.size() > 0) {
                        PfTaskVo taskVo = (PfTaskVo)taskList.get(0);
                        if (taskVo.getOverTime().compareTo(CalendarUtil.getCurDate()) < 0) {
                            userNameBuffer.append("\u5df2\u8d85\u671f");
                            isOver = "true";
                        } else {
                            long days = CalendarUtil.getDaysByTwoDate((Date)CalendarUtil.getCurDate(), (Date)taskVo.getOverTime());
                            userNameBuffer.append("\u5269\u4f59" + days + "\u5929");
                        }
                    }
                    if (i > 0) {
                        userNameBuffer.append("...");
                        break;
                    }
                    userNameBuffer.append("");
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        map.put("activityDesc", userNameBuffer.toString());
        map.put("activityName", activityName);
        map.put("isOver", isOver);
        return map;
    }
}

