/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.ByteObjectAccess;
import com.gtis.common.util.CommonUtil;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SplitDataService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParamImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/overTimeTask"})
public class OverTimeTaskController {
    @Autowired
    private SplitDataService splitDataService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysUserService sysUserService;

    @ResponseBody
    @RequestMapping(value={"getOverTaskCount/{userId}"})
    public String taskCenter(@PathVariable String userId) throws Exception {
        String warningDay;
        String workflowNames = AppConfig.getProperty((String)"overTime.task.workflowNames");
        String queryStr = "";
        if (StringUtils.isNotBlank((String)workflowNames)) {
            for (String workflowName : workflowNames.split(",")) {
                queryStr = StringUtils.isBlank((String)queryStr) ? "'" + workflowName + "'" : queryStr + ",'" + workflowName + "'";
            }
        }
        if (StringUtils.isBlank((String)(warningDay = AppConfig.getProperty((String)"task.warning.day")))) {
            warningDay = "0";
        }
        HashMap mapParam2 = Maps.newHashMap();
        mapParam2.put("userId", userId);
        mapParam2.put("workflowNames", queryStr);
        mapParam2.put("warningDay", warningDay);
        String noComputeActivityNames = AppConfig.getProperty((String)"overTime.noCompute.activityNames");
        if (StringUtils.isNotBlank((String)noComputeActivityNames)) {
            String[] activityNameArray = noComputeActivityNames.split(",");
            String activityNames = null;
            for (String activityName : activityNameArray) {
                activityNames = StringUtils.isBlank(activityNames) ? "'" + activityName + "'" : activityNames + ",'" + activityName + "'";
            }
            mapParam2.put("NOT_IN_ACTIVITY_NAMES", activityNames);
        }
        int totalCount = this.splitDataService.getCount("getTaskList", (Object)mapParam2);
        return totalCount + "";
    }

    @RequestMapping(value={"getOverTaskList"})
    public String getOverTaskList(Model model, @RequestParam(value="userId", required=false) String userId) throws Exception {
        List businessVoList = this.sysWorkFlowDefineService.getBusinessList();
        List pfOrganVoList = this.sysUserService.getAllOrganList();
        List pfUserVoList = this.sysUserService.getAllUsers();
        SplitParamImpl splitParam3 = new SplitParamImpl();
        splitParam3.setQueryString("getTaskList");
        HashMap mapParam2 = Maps.newHashMap();
        mapParam2.put("userId", userId);
        String workflowNames = AppConfig.getProperty((String)"overTime.task.workflowNames");
        String queryStr = "";
        if (StringUtils.isNotBlank((String)workflowNames)) {
            for (String workflowName : workflowNames.split(",")) {
                queryStr = StringUtils.isBlank((String)queryStr) ? "'" + workflowName + "'" : queryStr + ",'" + workflowName + "'";
            }
        }
        mapParam2.put("workflowNames", queryStr);
        String warningDay = AppConfig.getProperty((String)"task.warning.day");
        if (StringUtils.isBlank((String)warningDay)) {
            warningDay = "0";
        }
        mapParam2.put("warningDay", warningDay);
        String noComputeActivityNames = AppConfig.getProperty((String)"overTime.noCompute.activityNames");
        if (StringUtils.isNotBlank((String)noComputeActivityNames)) {
            String[] activityNameArray = noComputeActivityNames.split(",");
            String activityNames = null;
            for (String activityName : activityNameArray) {
                activityNames = StringUtils.isBlank(activityNames) ? "'" + activityName + "'" : activityNames + ",'" + activityName + "'";
            }
            mapParam2.put("NOT_IN_ACTIVITY_NAMES", activityNames);
        }
        splitParam3.setQueryParam((Serializable)mapParam2);
        model.addAttribute("overTimeTaskList", (Object)ByteObjectAccess.objectToString((Object)splitParam3));
        model.addAttribute("noComputeActivityNames", (Object)noComputeActivityNames);
        model.addAttribute("currentDate", (Object)CommonUtil.getCurrStrDate());
        model.addAttribute("businessList", (Object)(businessVoList != null ? businessVoList : Lists.newArrayList()));
        model.addAttribute("wrapEnable", (Object)AppConfig.getBooleanProperty((String)"task.list.wrap.enable", (boolean)true));
        model.addAttribute("pfOrganVoList", (Object)pfOrganVoList);
        model.addAttribute("pfUserVoList", (Object)pfUserVoList);
        model.addAttribute("splitStr", (Object)"$");
        model.addAttribute("userid", (Object)SessionUtil.getCurrentUserId());
        model.addAttribute("stateShowBegin", (Object)AppConfig.getBooleanProperty((String)"task.state.showBegin.enable", (boolean)false));
        model.addAttribute("overTimeEnble", (Object)AppConfig.getProperty((String)"task.overTime.enable"));
        model.addAttribute("showBusinessName", (Object)AppConfig.getBooleanProperty((String)"workflowName.show.businessName", (boolean)false));
        model.addAttribute("showUploadFile", (Object)AppConfig.getBooleanProperty((String)"task.taskList.showUploadFile", (boolean)true));
        return "task-over-time";
    }
}

